/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui.supportbundle.contributor;

import com.vmware.vide.logging.supportbundle.FileBundleContribution;
import com.vmware.vide.logging.supportbundle.ISupportBundleContribution;
import com.vmware.vide.logging.supportbundle.ISupportBundleContributor;
import com.vmware.vide.logging.supportbundle.StringBundleContribution;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.ConfigurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseInfoContributor
implements ISupportBundleContributor {
    private static final Logger logger = LoggerFactory.getLogger(EclipseInfoContributor.class);

    public List<ISupportBundleContribution> getContributions() {
        logger.debug("Getting contributions from Eclipse");
        LinkedList<ISupportBundleContribution> contributions = new LinkedList<ISupportBundleContribution>();
        contributions.add((ISupportBundleContribution)new StringBundleContribution("eclipse-installation-details.txt", "Eclipse Installation Details", ConfigurationInfo.getSystemSummary()));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath logFilePath = workspace.getRoot().getLocation().append(".metadata").append(".log");
        File logFile = logFilePath.toFile();
        contributions.add((ISupportBundleContribution)new FileBundleContribution(logFile, "logs/eclipse.log", "Eclipse .log file from workspace/.metadata dir"));
        return contributions;
    }
}

