/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.api.impl;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.vmware.vide.rse.api.impl.RemoteProcess;
import com.vmware.vide.rse.api.impl.TargetFile;
import com.vmware.vide.rse.api.impl.TargetManager;
import com.vmware.vide.rse.connector.ResourcesConnectorService;
import com.vmware.vide.rse.connector.vIDESshConnectorService;
import com.vmware.vide.rse.subsystems.ResourcesSubSystem;
import com.vmware.vide.rse.util.RSEHelper;
import com.vmware.vide.rse.util.SshScpHelper;
import com.vmware.vide.target.api.ICommandOutputChangedEvent;
import com.vmware.vide.target.api.ICommandOutputListener;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetFile;
import com.vmware.vide.target.api.ITargetProcess;
import com.vmware.vide.target.api.TargetType;
import com.vmware.vim25.mo.ServiceInstance;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorService;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class Target
implements ITarget {
    private final IHost host;
    private final TargetManager targetManager;
    private final TargetType targetType;

    public Target(TargetManager targetManager, TargetType targetType, IHost host) {
        this.host = host;
        this.targetManager = targetManager;
        this.targetType = targetType;
        JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
    }

    public String getName() {
        return this.host.getAliasName();
    }

    public void setName(String name) {
        this.host.setAliasName(name);
    }

    public TargetManager getTargetManager() {
        return this.targetManager;
    }

    IHost getHost() {
        return this.host;
    }

    public String getHostName() {
        return this.host.getHostName();
    }

    public void setHostName(String newName) {
        this.host.setHostName(newName);
    }

    public String getDescription() {
        String description = this.host.getDescription();
        return description;
    }

    public String getLabel() {
        String label = this.host.getSystemType().getLabel();
        return label;
    }

    public void setDescription(String desc) {
        this.host.setDescription(desc);
    }

    public boolean isSupportSsh() {
        if (this.targetType == null) {
            return false;
        }
        return this.targetType.isSshSupported();
    }

    public String getTargetType() {
        if (this.targetType == null) {
            return "unknown";
        }
        return this.targetType.getId();
    }

    public ServiceInstance getServiceInstance() throws Exception {
        return RSEHelper.getServiceInstance(this.getHost());
    }

    public boolean isVisor() throws Exception {
        return RSEHelper.isVisor(this.getHost());
    }

    public void connect(IProgressMonitor monitor) throws Exception {
        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
        if (fss != null && !fss.isConnected()) {
            String password;
            IConnectorService connectorService = fss.getConnectorService();
            if (connectorService != null && connectorService.supportsPassword() && (password = this.getPassword(false)) != null && !password.isEmpty()) {
                connectorService.setPassword(connectorService.getUserId(), password, true, true);
            }
            fss.connect((IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor), false);
        }
    }

    public void disconnect() throws Exception {
        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
        if (fss != null && fss.isConnected()) {
            fss.disconnect();
        }
    }

    public boolean isConnected() {
        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
        if (fss != null) {
            return fss.isConnected();
        }
        return false;
    }

    public String getUserId() {
        IConnectorService[] connectors = this.host.getConnectorServices();
        if (connectors != null && connectors.length > 0) {
            return connectors[0].getUserId();
        }
        return null;
    }

    public void setPassword(String pass, boolean persist) {
        IConnectorService[] connectors = this.host.getConnectorServices();
        if (connectors != null && connectors.length > 0) {
            IConnectorService rconnector;
            ResourcesSubSystem rss;
            IConnectorService connector = connectors[0];
            connector.setPassword(connector.getUserId(), pass, persist, true);
            if (connector instanceof SshConnectorService && (rss = RSEHelper.getResourcesSubSystem(this.host)) != null && ((rconnector = rss.getConnectorService()).isConnected() || rconnector.hasPassword(false))) {
                rconnector.setPassword(rconnector.getUserId(), pass, persist, false);
            }
        }
    }

    public void setUserId(String user) {
        IConnectorService[] connectors = this.host.getConnectorServices();
        if (connectors != null && connectors.length > 0) {
            connectors[0].setUserId(user);
        }
    }

    public String getPassword(boolean prompt) {
        IConnectorService[] conns;
        IConnectorService connector = null;
        SystemSignonInformation ssInfo = null;
        IConnectorService[] iConnectorServiceArray = conns = this.host.getConnectorServices();
        int n = conns.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService conn = iConnectorServiceArray[n2];
            if (conn instanceof vIDESshConnectorService) {
                connector = conn;
                ssInfo = ((vIDESshConnectorService)conn).getSignonInfo();
                break;
            }
            if (conn instanceof ResourcesConnectorService) {
                connector = conn;
                ssInfo = ((ResourcesConnectorService)conn).getSignonInfo();
                break;
            }
            ++n2;
        }
        if (connector != null) {
            if (connector.hasPassword(false) && ssInfo != null) {
                return ssInfo.getPassword();
            }
            if (connector.hasPassword(true) && (ssInfo = PasswordPersistenceManager.getInstance().find(this.host.getSystemType(), this.host.getHostName(), connector.getUserId())) != null) {
                return ssInfo.getPassword();
            }
            if (prompt) {
                try {
                    ISubSystem[] sses = connector.getSubSystems();
                    if (((SubSystem)sses[0]).promptForPassword()) {
                        if (connector instanceof vIDESshConnectorService) {
                            ssInfo = ((vIDESshConnectorService)connector).getSignonInfo();
                        } else if (connector instanceof ResourcesConnectorService) {
                            ssInfo = ((ResourcesConnectorService)connector).getSignonInfo();
                        }
                        return ssInfo.getPassword();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void downloadFile(String remoteFile, File localFileOrDir, IProgressMonitor monitor) throws Exception {
        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
        IRemoteFile srcFile = fss.getRemoteFileObject(remoteFile, monitor);
        String dstFile = localFileOrDir.isDirectory() ? String.valueOf(localFileOrDir.getAbsolutePath().concat("/")) + srcFile.getName() : localFileOrDir.getAbsolutePath();
        fss.download(srcFile, dstFile, null, monitor);
    }

    public void uploadFile(File localFile, String remoteFileOrDir, IProgressMonitor monitor) throws Exception {
        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
        IRemoteFile dstFile = fss.getRemoteFileObject(remoteFileOrDir, monitor);
        if (dstFile.isDirectory()) {
            dstFile = fss.getRemoteFileObject(dstFile, localFile.getName(), monitor);
        }
        fss.upload(localFile.getAbsolutePath(), dstFile, null, monitor);
    }

    public ITargetFile getTargetFile(String remoteFile, IProgressMonitor monitor) throws Exception {
        if (remoteFile == null || remoteFile.isEmpty()) {
            throw new Exception("No path is provided");
        }
        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
        IRemoteFile rFile = fss.getRemoteFileObject(remoteFile, monitor);
        return new TargetFile(this, rFile);
    }

    public ITargetFile getTargetFile(ITargetFile parent, String child, IProgressMonitor monitor) throws Exception {
        if (child == null || child.isEmpty()) {
            throw new Exception("No path is provided");
        }
        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
        if (parent == null) {
            return this.getTargetFile(child, monitor);
        }
        IRemoteFile remoteParent = fss.getRemoteFileObject(parent.getAbsolutePath(), monitor);
        IRemoteFile remoteFile = fss.getRemoteFileObject(remoteParent, child, monitor);
        return new TargetFile(this, remoteFile);
    }

    public int executeCommand(String command, ICommandOutputListener listener, IProgressMonitor monitor) throws Exception {
        SequenceInputStream is;
        RemoteProcess proc = new RemoteProcess(this, command);
        if (listener != null && (is = new SequenceInputStream(proc.getInputStream(), proc.getErrorStream())) != null) {
            Thread handler = new Thread(new HandleOutput(is, listener));
            handler.start();
        }
        proc.run();
        while (proc.isActive()) {
            if (monitor != null && monitor.isCanceled()) {
                proc.destroy();
                throw new OperationCanceledException();
            }
            Thread.sleep(1000L);
        }
        return proc.exitValue();
    }

    public void executeCommandAsync(String command, ICommandOutputListener listener) throws Exception {
        SequenceInputStream is;
        RemoteProcess proc = new RemoteProcess(this, command);
        if (listener != null && (is = new SequenceInputStream(proc.getInputStream(), proc.getErrorStream())) != null) {
            Thread handler = new Thread(new HandleOutput(is, listener));
            handler.start();
        }
        proc.run();
    }

    public ITargetProcess getTargetProcess(String command) throws Exception {
        return new RemoteProcess(this, command);
    }

    public byte[] readRemoteFile(String remoteFile, int size, IProgressMonitor monitor) throws Exception {
        if (remoteFile == null || remoteFile.isEmpty()) {
            throw new Exception("File name can't be empty");
        }
        if (size <= 0) {
            return null;
        }
        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
        IConnectorService connector = fss.getConnectorService();
        if (connector instanceof SshConnectorService) {
            Session session = ((SshConnectorService)connector).getSession();
            return SshScpHelper.readRemoteFile(session, remoteFile, size, monitor);
        }
        return null;
    }

    public String getESXVersion() throws Exception {
        ServiceInstance si = this.getServiceInstance();
        return si == null ? "" : si.getAboutInfo().getVersion();
    }

    public boolean isFileSystemSupported() {
        return this.targetType.isFileSystemSupported();
    }

    private class HandleOutput
    implements Runnable {
        private final InputStream is;
        private final ICommandOutputListener listener;

        public HandleOutput(InputStream is, ICommandOutputListener listener) {
            this.is = is;
            this.listener = listener;
        }

        @Override
        public void run() {
            BufferedReader buffer = new BufferedReader(new InputStreamReader(this.is));
            try {
                String line;
                while ((line = buffer.readLine()) != null) {
                    String output = line;
                    class CommandOutputChangedEvent
                    implements ICommandOutputChangedEvent {
                        private final /* synthetic */ String val$output;

                        CommandOutputChangedEvent(String string) {
                            this.val$output = string;
                        }

                        public String[] getOutputLines() {
                            return new String[]{this.val$output};
                        }
                    }
                    this.listener.commandOutputChanged((ICommandOutputChangedEvent)new CommandOutputChangedEvent(output));
                }
            }
            catch (IOException iOException) {}
        }
    }
}

