/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.api.impl;

import com.vmware.vide.rse.api.impl.Target;
import com.vmware.vide.rse.api.impl.TargetManager;
import com.vmware.vide.rse.api.impl.WindowsTarget;
import com.vmware.vide.target.api.TargetType;
import com.vmware.vide.utils.net.HttpLogger;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetFactory {
    private static final Logger logger = LoggerFactory.getLogger(TargetFactory.class);

    public static Target createTarget(TargetManager targetManager, IHost host) {
        if (host == null) {
            logger.error("Attempt to create target for a null host");
            return null;
        }
        Target target = null;
        IRSESystemType systemType = host.getSystemType();
        if (systemType == null) {
            logger.error("RSE host '" + host.getName() + "' has no system type");
            return null;
        }
        String systemTypeId = systemType.getId();
        boolean isWindowsHost = "org.eclipse.rse.systemtype.windows".equals(systemTypeId);
        TargetType targetType = targetManager.lookupTargetTypeByRseSystemType(systemTypeId);
        if (targetType == null) {
            logger.warn("Unable to lookup TargetType for system type='" + systemTypeId + "'");
        }
        target = isWindowsHost ? new WindowsTarget(targetManager, targetType, host) : new Target(targetManager, targetType, host);
        HttpLogger.logActivity((String)"rse", (String)"OpenConnection", (String)systemTypeId);
        return target;
    }
}

