/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.api.impl;

import com.vmware.vide.rse.api.impl.Target;
import com.vmware.vide.rse.api.impl.TargetManager;
import com.vmware.vide.rse.connector.UserCredentialsConnectorService;
import com.vmware.vide.target.api.TargetType;
import com.vmware.vim25.mo.ServiceInstance;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;

public class WindowsTarget
extends Target {
    public WindowsTarget(TargetManager targetManager, TargetType targetType, IHost host) {
        super(targetManager, targetType, host);
    }

    @Override
    public boolean isSupportSsh() {
        return false;
    }

    @Override
    public String getTargetType() {
        return "windows";
    }

    @Override
    public ServiceInstance getServiceInstance() throws Exception {
        return null;
    }

    @Override
    public boolean isVisor() throws Exception {
        return false;
    }

    @Override
    public String getESXVersion() throws Exception {
        return null;
    }

    @Override
    public String getUserId() {
        IConnectorService[] connectors = this.getHost().getConnectorServices();
        if (connectors != null) {
            IConnectorService[] iConnectorServiceArray = connectors;
            int n = connectors.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectorService connector = iConnectorServiceArray[n2];
                if (connector instanceof UserCredentialsConnectorService) {
                    return connector.getUserId();
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void setUserId(String user) {
        IConnectorService[] connectors = this.getHost().getConnectorServices();
        if (connectors != null) {
            IConnectorService[] iConnectorServiceArray = connectors;
            int n = connectors.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectorService connector = iConnectorServiceArray[n2];
                if (connector instanceof UserCredentialsConnectorService) {
                    connector.setUserId(user);
                    break;
                }
                ++n2;
            }
        }
    }

    @Override
    public String getPassword(boolean prompt) {
        IConnectorService[] connectors;
        IConnectorService connector = null;
        SystemSignonInformation ssInfo = null;
        IHost host = this.getHost();
        IConnectorService[] iConnectorServiceArray = connectors = host.getConnectorServices();
        int n = connectors.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService c = iConnectorServiceArray[n2];
            if (c instanceof UserCredentialsConnectorService) {
                connector = c;
                ssInfo = ((UserCredentialsConnectorService)c).getSignonInfo();
                break;
            }
            ++n2;
        }
        if (connector != null) {
            if (connector.hasPassword(false) && ssInfo != null) {
                return ssInfo.getPassword();
            }
            if (connector.hasPassword(true) && (ssInfo = PasswordPersistenceManager.getInstance().find(host.getSystemType(), host.getHostName(), connector.getUserId())) != null) {
                return ssInfo.getPassword();
            }
            if (prompt) {
                try {
                    ISubSystem[] subSystems = connector.getSubSystems();
                    if (((SubSystem)subSystems[0]).promptForPassword()) {
                        ssInfo = ((UserCredentialsConnectorService)connector).getSignonInfo();
                        return ssInfo.getPassword();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public void setPassword(String password, boolean persist) {
        IConnectorService[] connectors = this.getHost().getConnectorServices();
        if (connectors != null) {
            IConnectorService[] iConnectorServiceArray = connectors;
            int n = connectors.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectorService connector = iConnectorServiceArray[n2];
                if (connector instanceof UserCredentialsConnectorService) {
                    connector.setPassword(connector.getUserId(), password, persist, true);
                    break;
                }
                ++n2;
            }
        }
    }
}

