/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.model;

import com.vmware.vim25.DatastoreSummary;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class DataStoreElement
extends AbstractResource {
    private Datastore dataStore;
    private DatastoreSummary summary;
    private String name = null;

    public DataStoreElement(Datastore ds, ISubSystem parentSubSystem) {
        super(parentSubSystem);
        this.dataStore = ds;
        this.summary = ds.getSummary();
    }

    public String getName() {
        if (this.name == null && this.summary != null) {
            this.name = this.summary.getName();
        }
        return this.name;
    }

    public String getLocation() {
        if (this.summary != null) {
            return this.summary.getUrl();
        }
        return null;
    }

    public String getType() {
        if (this.summary != null) {
            return this.summary.getType();
        }
        return null;
    }

    public String getFreeSpace() {
        if (this.summary != null) {
            long freeSpace = this.summary.getFreeSpace();
            freeSpace = this.byteToGiga(freeSpace);
            return String.valueOf(new Long(freeSpace).toString()) + " G";
        }
        return null;
    }

    public String getCapacity() {
        if (this.summary != null) {
            long capacity = this.summary.getCapacity();
            capacity = this.byteToGiga(capacity);
            return String.valueOf(new Long(capacity).toString()) + " G";
        }
        return null;
    }

    private long byteToGiga(long bytes) {
        return bytes / 1000000000L;
    }

    public List getVms() {
        if (this.dataStore != null) {
            VirtualMachine[] vms = this.dataStore.getVms();
            ArrayList<String> vmList = new ArrayList<String>();
            int i = 0;
            while (i < vms.length) {
                vmList.add(vms[i].getName());
                ++i;
            }
            return vmList;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

