/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.service;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import com.vmware.vide.rse.api.impl.RemoteProcess;
import com.vmware.vide.rse.service.VMWBFileATTR;
import com.vmware.vide.rse.service.VMWBLSEntry;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.rse.services.clientserver.PathUtility;

public class VMWBFileChannel {
    private Session session;

    public VMWBFileChannel(Session session) {
        this.session = session;
    }

    public String[] runCommand(String command, IProgressMonitor monitor) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        RemoteProcess proc = null;
        try {
            if (monitor != null) {
                monitor.beginTask(command, 20);
            }
            proc = new RemoteProcess(this.session, command);
            proc.setInputStream(null);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            proc.setErrorStream(err);
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            proc.run();
            if (monitor != null) {
                monitor.worked(10);
            }
            String line = null;
            while ((line = reader.readLine()) != null) {
                results.add(line);
            }
            int exit = proc.waitFor();
            if (exit != 0) {
                throw new Exception(String.valueOf(command) + ":" + err.toString());
            }
        }
        finally {
            if (proc != null && proc.isActive()) {
                proc.destroy();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        return results.toArray(new String[0]);
    }

    public Vector list(String parent) throws Exception {
        StringBuffer command = new StringBuffer("ls -l ");
        command.append(parent);
        if (!parent.endsWith("/")) {
            command.append('/');
        }
        String[] results = this.runCommand(command.toString(), null);
        Vector<VMWBLSEntry> v = new Vector<VMWBLSEntry>();
        int i = 0;
        while (i < results.length) {
            try {
                v.addElement(new VMWBLSEntry(results[i]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return v;
    }

    public VMWBFileATTR stat(String path) throws Exception {
        String[] results = this.runCommand("stat -t " + PathUtility.enQuoteUnix((String)path), null);
        return new VMWBFileATTR(path, results[0]);
    }

    public String pwd() throws Exception {
        String[] results = this.runCommand("pwd", null);
        return results[0];
    }

    public void chmod(int permission, String path) throws Exception {
        String perm = Integer.toOctalString(permission);
        this.runCommand("chmod " + perm + " " + path, null);
    }

    public String readlink(String path) throws Exception {
        String[] results = this.runCommand("readlink " + path, null);
        return results[0];
    }

    public void ScpTo(String srcFile, String dstFile, SftpProgressMonitor monitor) throws Exception {
        Channel channel = null;
        FileInputStream fis = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            int len;
            String command = "scp -p -t " + dstFile;
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            if (this.checkAck(in) != 0) {
                throw new IOException("ScpTo : Failed to connect to ssh channel");
            }
            long size = new File(srcFile).length();
            command = "C0644 " + size + " ";
            command = srcFile.lastIndexOf(File.separatorChar) > 0 ? String.valueOf(command) + srcFile.substring(srcFile.lastIndexOf(File.separator) + 1) : String.valueOf(command) + srcFile;
            command = String.valueOf(command) + "\n";
            out.write(command.getBytes());
            out.flush();
            if (this.checkAck(in) != 0) {
                throw new IOException("ScpTo : Failed to send file size and name");
            }
            if (monitor != null) {
                monitor.init(0, srcFile, dstFile, size);
            }
            fis = new FileInputStream(srcFile);
            byte[] buf = new byte[1024];
            int count = 0;
            int written = 0;
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
                written += len;
                if (++count != 48) continue;
                if (monitor != null && !monitor.count((long)written)) {
                    throw new OperationCanceledException();
                }
                written = 0;
                count = 0;
            }
            this.sendAck(out);
            if (this.checkAck(in) != 0) {
                System.out.println("ScpTo failed after uploading " + srcFile);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (fis != null) {
                fis.close();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (monitor != null) {
                monitor.end();
            }
        }
    }

    public void ScpFrom(String srcFile, String dstFile, SftpProgressMonitor monitor) throws Exception {
        Channel channel = null;
        FileOutputStream fos = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            String command = "scp -f " + srcFile;
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            this.sendAck(out);
            if (this.checkAck(in) != 67) {
                throw new IOException("ScpFrom failed. Asking sink mode from remote failed.");
            }
            in.skip(5L);
            long filesize = 0L;
            while (true) {
                int b;
                if ((b = in.read()) < 0) {
                    throw new IOException("ScpFrom failed. Error during reading file size");
                }
                if (b == 32) break;
                filesize = filesize * 10L + (long)(b - 48);
            }
            byte[] buf = new byte[1024];
            int i = 0;
            while (true) {
                in.read(buf, i, 1);
                if (buf[i] == 10) break;
                ++i;
            }
            String filename = new String(buf, 0, i);
            this.sendAck(out);
            if (monitor != null) {
                monitor.init(1, srcFile, dstFile, filesize);
            }
            fos = new File(dstFile).isDirectory() ? new FileOutputStream(String.valueOf(dstFile) + File.separator + filename) : new FileOutputStream(dstFile);
            int count = 0;
            int written = 0;
            while (filesize > 0L) {
                int readSize = (long)buf.length < filesize ? buf.length : (int)filesize;
                if ((readSize = in.read(buf, 0, readSize)) < 0) {
                    throw new IOException("ScpFrom failed. Error during read remote file");
                }
                fos.write(buf, 0, readSize);
                filesize -= (long)readSize;
                written += readSize;
                if (++count != 48) continue;
                if (monitor != null && !monitor.count((long)written)) {
                    throw new OperationCanceledException();
                }
                written = 0;
                count = 0;
            }
            if (this.checkAck(in) != 0) {
                System.out.println("ScpFrom failed after downloading " + srcFile);
            }
            this.sendAck(out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (monitor != null) {
                monitor.end();
            }
        }
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            System.out.print(String.valueOf(sb.toString()) + " : " + b);
        }
        return b;
    }

    private void sendAck(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }
}

