/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.subsystems;

import com.vmware.vide.rse.RSEResources;
import com.vmware.vide.rse.connector.ResourcesConnectorService;
import com.vmware.vide.rse.connector.ResourcesConnectorServiceManager;
import com.vmware.vide.rse.service.ISDKService;
import com.vmware.vide.rse.service.vIDESDKService;
import com.vmware.vide.rse.subsystems.ResourcesSubSystem;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.services.IService;

public class ResourcesSubSystemConfiguration
extends SubSystemConfiguration {
    private Map services = new HashMap();

    public ISubSystem createSubSystemInternal(IHost conn) {
        ResourcesConnectorService connectorService = (ResourcesConnectorService)this.getConnectorService(conn);
        return new ResourcesSubSystem(conn, (IConnectorService)connectorService, this.getSDKService(conn));
    }

    public IConnectorService getConnectorService(IHost host) {
        return ResourcesConnectorServiceManager.getInstance().getConnectorService(host, ISDKService.class);
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        ResourcesConnectorServiceManager.getInstance().setConnectorService(host, ISDKService.class, connectorService);
    }

    public final IService getService(IHost host) {
        return this.getSDKService(host);
    }

    public final ISDKService getSDKService(IHost host) {
        ISDKService service = (ISDKService)this.services.get(host);
        if (service == null) {
            service = this.createSDKService(host);
            this.services.put(host, service);
        }
        return service;
    }

    public ISDKService createSDKService(IHost host) {
        ResourcesConnectorService conn = (ResourcesConnectorService)this.getConnectorService(host);
        return new vIDESDKService(conn);
    }

    protected ISystemFilterPool createDefaultFilterPool(ISystemFilterPoolManager mgr) {
        ISystemFilterPool defaultPool = null;
        try {
            String poolName = ResourcesSubSystemConfiguration.getDefaultFilterPoolName((String)mgr.getName(), (String)this.getId());
            defaultPool = mgr.createSystemFilterPool(poolName, false);
            ISystemFilter filter = mgr.createSystemFilter((ISystemFilterContainer)defaultPool, RSEResources.VMList_FilterType, new String[]{RSEResources.TypeInfo_VirtualMachine});
            this.configureFilter(filter, RSEResources.VMList_FilterType);
            filter = mgr.createSystemFilter((ISystemFilterContainer)defaultPool, RSEResources.LUNList_FilterType, new String[]{RSEResources.TypeInfo_SCSILun});
            this.configureFilter(filter, RSEResources.LUNList_FilterType);
            filter = mgr.createSystemFilter((ISystemFilterContainer)defaultPool, RSEResources.HBAList_FilterType, new String[]{RSEResources.TypeInfo_HBA});
            this.configureFilter(filter, RSEResources.HBAList_FilterType);
            filter = mgr.createSystemFilter((ISystemFilterContainer)defaultPool, RSEResources.DSList_FilterType, new String[]{RSEResources.TypeInfo_DataStore});
            this.configureFilter(filter, RSEResources.DSList_FilterType);
            filter = mgr.createSystemFilter((ISystemFilterContainer)defaultPool, RSEResources.VSwitchList_FilterType, new String[]{RSEResources.TypeInfo_VSwitch});
            this.configureFilter(filter, RSEResources.VSwitchList_FilterType);
            filter = mgr.createSystemFilter((ISystemFilterContainer)defaultPool, RSEResources.PNicList_FilterType, new String[]{RSEResources.TypeInfo_PNic});
            this.configureFilter(filter, RSEResources.PNicList_FilterType);
        }
        catch (Exception exception) {}
        return defaultPool;
    }

    private void configureFilter(ISystemFilter filter, String type) {
        filter.setType(type);
        filter.setNonChangable(true);
        filter.setNonDeletable(true);
        filter.setNonRenamable(true);
    }
}

