/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.actions;

import com.vmware.vide.rse.connector.ResourcesConnectorService;
import com.vmware.vide.rse.model.VirtualMachineElement;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class ConfigureRemoteDisplay
extends SystemBaseAction {
    public ConfigureRemoteDisplay(String text, String tooltip, ImageDescriptor image, Shell parent) {
        super(text, tooltip, image, parent);
    }

    public void run() {
        Object object = this.getFirstSelection();
        if (object instanceof VirtualMachineElement) {
            CheckVNCConfig job = new CheckVNCConfig("Checking Remote Display", (VirtualMachineElement)((Object)object));
            job.schedule();
        }
    }

    private class CheckVNCConfig
    extends Job {
        private VirtualMachineElement vmElement;
        private VirtualMachine vm;
        private HashMap<String, String> portMap;
        private String port;

        public CheckVNCConfig(String name, VirtualMachineElement vmElement) {
            super(name);
            this.vmElement = vmElement;
            this.vm = vmElement.getVirtualMachine();
            this.portMap = new HashMap();
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.port = this.getRemoteDisplayPort(this.vm);
                boolean poweredOn = this.vm.getSummary().getRuntime().getPowerState().equals((Object)VirtualMachinePowerState.poweredOn);
                final StringBuffer buffer = new StringBuffer();
                buffer.append("Remote Display on system ");
                buffer.append(this.vm.getName());
                if (poweredOn) {
                    if (this.port != null) {
                        buffer.append(" is already enabled on port number ");
                        buffer.append(this.port);
                        buffer.append(".");
                    } else {
                        buffer.append(" is disabled. Power off or suspend VM to enable Remote Display.");
                    }
                    ConfigureRemoteDisplay.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)ConfigureRemoteDisplay.this.getShell(), (String)("Remote Display - " + CheckVNCConfig.this.vm.getName()), (String)buffer.toString());
                        }
                    });
                } else {
                    this.scanPortNumbers();
                    if (this.port != null) {
                        buffer.append(" is enabled. Enter a new number to change port number:");
                    } else {
                        buffer.append(" is disabled. Enter a port number to enable Remote Display (For example : 5900):");
                    }
                    ConfigureRemoteDisplay.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String newPort;
                            InputDialog input = new InputDialog(ConfigureRemoteDisplay.this.getShell(), "Remote Display - " + CheckVNCConfig.this.vm.getName(), buffer.toString(), CheckVNCConfig.this.port, new IInputValidator(){

                                public String isValid(String newText) {
                                    try {
                                        Integer.parseInt(newText);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        return "Enter a valid port number";
                                    }
                                    if (CheckVNCConfig.this.portMap.containsKey(newText)) {
                                        return "Port number is being used by " + (String)CheckVNCConfig.this.portMap.get(newText);
                                    }
                                    return null;
                                }
                            });
                            if (input.open() == 0 && !(newPort = input.getValue().trim()).equals(CheckVNCConfig.this.port)) {
                                CheckVNCConfig.this.reconfigureRemoteDisplay(newPort);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                return new Status(4, "com.vmware.vide.rse", "Failed to check Remote Display configuration", (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        private String getRemoteDisplayPort(VirtualMachine virtualMachine) {
            OptionValue[] values;
            boolean enabled = false;
            String port = null;
            OptionValue[] optionValueArray = values = virtualMachine.getConfig().getExtraConfig();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                OptionValue value = optionValueArray[n2];
                if (value.getKey().equals("RemoteDisplay.vnc.enabled")) {
                    if (value.getValue().equals("true")) {
                        enabled = true;
                    }
                } else if (value.getKey().equals("RemoteDisplay.vnc.port")) {
                    port = (String)value.getValue();
                }
                ++n2;
            }
            if (enabled && port != null && !port.isEmpty()) {
                return port;
            }
            return null;
        }

        private void reconfigureRemoteDisplay(String newPort) {
            OptionValue[] values;
            VirtualMachineConfigSpec vSpec = null;
            if (this.port != null) {
                OptionValue[] optionValueArray = values = this.vm.getConfig().getExtraConfig();
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    OptionValue value = optionValueArray[n2];
                    if (value.getKey().equals("RemoteDisplay.vnc.port")) {
                        value.setValue((Object)newPort);
                        break;
                    }
                    ++n2;
                }
                vSpec = new VirtualMachineConfigSpec();
                vSpec.setExtraConfig(values);
            } else {
                values = this.vm.getConfig().getExtraConfig();
                ArrayList<OptionValue> list = new ArrayList<OptionValue>(Arrays.asList(values));
                OptionValue opt = new OptionValue();
                opt.setKey("RemoteDisplay.vnc.enabled");
                opt.setValue((Object)"true");
                list.add(opt);
                opt = new OptionValue();
                opt.setKey("RemoteDisplay.vnc.port");
                opt.setValue((Object)newPort);
                list.add(opt);
                vSpec = new VirtualMachineConfigSpec();
                vSpec.setExtraConfig(list.toArray(new OptionValue[list.size()]));
            }
            if (vSpec != null) {
                try {
                    this.vm.reconfigVM_Task(vSpec);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void scanPortNumbers() {
            ManagedObject mo;
            IConnectorService conn = this.vmElement.getSubSystem().getConnectorService();
            ServiceInstance si = null;
            if (conn instanceof ResourcesConnectorService) {
                si = ((ResourcesConnectorService)conn).getServiceInstance();
            }
            if (si == null) {
                return;
            }
            ManagedObjectReference mor = this.vm.getRuntime().getHost();
            if (mor != null && mor.getType().equals("HostSystem") && (mo = MorUtil.createExactManagedObject((ServerConnection)si.getServerConnection(), (ManagedObjectReference)mor)) instanceof HostSystem) {
                try {
                    VirtualMachine[] vmList;
                    VirtualMachine[] virtualMachineArray = vmList = ((HostSystem)mo).getVms();
                    int n = vmList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VirtualMachine aVM = virtualMachineArray[n2];
                        if (!aVM.getMOR().equals(this.vm.getMOR())) {
                            try {
                                String port = this.getRemoteDisplayPort(aVM);
                                if (port != null && !port.isEmpty()) {
                                    this.portMap.put(port, aVM.getName());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

