/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.actions;

import com.vmware.vide.rse.ui.views.SyslogMonitorView;
import com.vmware.vide.utils.net.HttpLogger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class LaunchLogMonitor
implements IObjectActionDelegate {
    private IHost host = null;
    private IWorkbenchPart part;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void run(IAction action) {
        String systemType = this.host.getSystemType().getId();
        if (!(systemType.equals("vide.rse.systemtype.esx") || systemType.equals("vide.rse.systemtype.vc") || systemType.equals("vide.rse.systemtype.vcva"))) {
            MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)this.host.getHostName(), (String)"This function works only with ESX or Virtual Center");
            return;
        }
        HttpLogger.logActivity((String)"rse", (String)"SyslogMonitor");
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IViewPart view = null;
        try {
            view = page.showView("vide.rse.view.log", this.host.getAliasName(), 1);
            page.bringToTop((IWorkbenchPart)view);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        if (view instanceof SyslogMonitorView) {
            ((SyslogMonitorView)view).start(this.host);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        for (Object obj : (IStructuredSelection)selection) {
            if (!(obj instanceof IHost)) continue;
            this.host = (IHost)obj;
            break;
        }
    }
}

