/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.dialogs;

import com.vmware.vide.logging.PlatformLoggingController;
import com.vmware.vide.rse.VIDERSEPlugin;
import com.vmware.vide.rse.util.CertificateUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallCertificateDialog
extends TitleAreaDialog {
    private static final Logger logger = LoggerFactory.getLogger(InstallCertificateDialog.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private Text txtHost;
    private Text txtIssuedTo;
    private Text txtIssuedBy;
    private Text txtValidFromto;
    private Text txtMdthumbprint;
    private Text txtShaThumbprint;
    private final CertificateUtil.CertificateInfo certificateInfo;
    private final CertificateUtil certificateUtil;
    private boolean isInstallSuccessful = false;
    private Text txtSerialNumber;

    private static String getTrustStorePath() {
        return VIDERSEPlugin.getWorkbenchTrustStoreFile().getAbsolutePath();
    }

    public static boolean checkCertificate(Shell parent, boolean promptIfUntrusted, String hostColonPort) throws Exception {
        boolean certificateIsTrusted = true;
        if (hostColonPort == null || hostColonPort.isEmpty()) {
            throw new IllegalArgumentException("host:port must be a non empty string.");
        }
        CertificateUtil certUtil = VIDERSEPlugin.getDefault().createCertificateUtil();
        try {
            List<CertificateUtil.CertificateInfo> certInfoList = certUtil.getCertificateInfo(hostColonPort);
            for (CertificateUtil.CertificateInfo certInfo : certInfoList) {
                if (certInfo.IS_TRUSTED || !promptIfUntrusted) continue;
                InstallCertificateDialog dialog = new InstallCertificateDialog(parent, certUtil, certInfo);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        InstallCertificateDialog.this.open();
                    }
                });
                if (dialog.isInstallSuccessful()) continue;
                certificateIsTrusted = false;
            }
        }
        catch (Exception e) {
            logger.error("Exception while trying to get certificates for " + hostColonPort, (Throwable)e);
            certificateIsTrusted = false;
        }
        if (certUtil.isTrustStoreModified()) {
            try {
                certUtil.writeTrustStoreToFile(InstallCertificateDialog.getTrustStorePath(), true);
            }
            catch (Exception e) {
                logger.error("Exception while trying to persist trust store", (Throwable)e);
            }
        }
        return certificateIsTrusted;
    }

    private boolean isInstallSuccessful() {
        return this.isInstallSuccessful;
    }

    public InstallCertificateDialog(Shell parentShell, CertificateUtil certificateUtil, CertificateUtil.CertificateInfo certificateInfo) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.setShellStyle(67584);
        this.certificateUtil = certificateUtil;
        this.certificateInfo = certificateInfo;
    }

    public void create() {
        super.create();
        this.setTitle("Untrusted certificate");
        this.setMessage("The certificate presented by this host is untrusted.  Select \"Install Certificate\" to install the certificate into a workspace local trust store.", 2);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(null);
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblHost = new Label(composite, 0);
        lblHost.setText("Host");
        this.txtHost = new Text(composite, 2056);
        this.txtHost.setText("Host");
        this.txtHost.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblIssuedTo = new Label(composite, 0);
        lblIssuedTo.setText("Issued To");
        this.txtIssuedTo = new Text(composite, 2056);
        this.txtIssuedTo.setText("Issued To");
        this.txtIssuedTo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblIssuedBy = new Label(composite, 0);
        lblIssuedBy.setText("Issued By");
        this.txtIssuedBy = new Text(composite, 2056);
        this.txtIssuedBy.setText("Issued By");
        this.txtIssuedBy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblValidFromto = new Label(composite, 0);
        lblValidFromto.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblValidFromto.setText("Valid after/until");
        this.txtValidFromto = new Text(composite, 2056);
        this.txtValidFromto.setText("Valid From-To");
        this.txtValidFromto.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblSerialNumber = new Label(composite, 0);
        lblSerialNumber.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSerialNumber.setText("Serial Number");
        this.txtSerialNumber = new Text(composite, 2056);
        this.txtSerialNumber.setText("Serial Number");
        this.txtSerialNumber.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblMdThumbprint = new Label(composite, 256);
        lblMdThumbprint.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblMdThumbprint.setText("MD5 Thumbprint");
        this.txtMdthumbprint = new Text(composite, 2056);
        this.txtMdthumbprint.setText("MD5Thumbprint");
        this.txtMdthumbprint.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblShaThumbprint = new Label(composite, 0);
        lblShaThumbprint.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblShaThumbprint.setText("SHA1 Thumbprint");
        this.txtShaThumbprint = new Text(composite, 2056);
        this.txtShaThumbprint.setText("SHA1 Thumbprint");
        this.txtShaThumbprint.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        String hostName = String.valueOf(this.certificateInfo.getHost()) + ":" + this.certificateInfo.getPort();
        this.txtHost.setText(hostName);
        this.txtIssuedTo.setText(this.certificateInfo.CERTIFICATE.getSubjectX500Principal().getName());
        this.txtIssuedBy.setText(this.certificateInfo.CERTIFICATE.getIssuerX500Principal().getName());
        this.txtValidFromto.setText(String.valueOf(DATE_FORMAT.format(this.certificateInfo.CERTIFICATE.getNotBefore())) + " - " + DATE_FORMAT.format(this.certificateInfo.CERTIFICATE.getNotAfter()));
        this.txtSerialNumber.setText(this.certificateInfo.CERTIFICATE.getSerialNumber().toString(16));
        try {
            this.txtMdthumbprint.setText(this.certificateInfo.getThumbprint("MD5"));
            this.txtShaThumbprint.setText(this.certificateInfo.getThumbprint("SHA1"));
        }
        catch (Exception e) {
            String lookInLogMessage = "ERROR: see logs in dir '" + PlatformLoggingController.getInstance().getLogDirPath() + "'.";
            this.txtMdthumbprint.setText(lookInLogMessage);
            this.txtShaThumbprint.setText(lookInLogMessage);
            logger.error("Exception trying to format thumbprints for host " + hostName, (Throwable)e);
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button installButton = this.createButton(parent, 0, "Install Certificate", true);
        installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallCertificateDialog.this.installCertificate();
            }
        });
        installButton.setToolTipText("Installs this certificate into a local trust store in your workspace (" + InstallCertificateDialog.getTrustStorePath() + ").  This certificate will then be trusted by all Eclipse plugins, but not necessarily externally spawned tools.");
        Button cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallCertificateDialog.this.cancel();
            }
        });
        cancelButton.setToolTipText("Do NOT install this certificate into the workspace trust store.");
    }

    private void cancel() {
        logger.info("User canceled certificate install.");
    }

    private void installCertificate() {
        logger.info("Installing certificate...");
        try {
            this.certificateUtil.addCertificateToKeyStore(this.certificateInfo, this.certificateInfo.generateAlias());
            this.isInstallSuccessful = true;
        }
        catch (Exception e) {
            logger.error("Exception trying to add cerficate to trust store", (Throwable)e);
        }
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }
}

