/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.dialogs;

import com.vmware.vide.rse.subsystems.ResourcesSubSystem;
import com.vmware.vide.rse.util.RSEHelper;
import com.vmware.vim25.HostService;
import com.vmware.vim25.HostServiceInfo;
import com.vmware.vim25.HostServicePolicy;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.mo.HostServiceSystem;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.OptionManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SshConfiguration
extends Dialog {
    private static final String TSM_SSH = "TSM-SSH";
    private static final String SSH = "SSH";
    private static final String SSHD = "sshd";
    private static final int COMMAND_START = 1;
    private static final int COMMAND_STOP = 2;
    private static final int COMMAND_RESTART = 3;
    private IHost host;
    private HostSystem hostSystem;
    private HostServiceSystem serviceSystem;
    private HostService sshService;
    private String errorMessage;
    private Label statusLabel;
    private Button autoButton;
    private Button onButton;
    private Button offButton;
    private Button startButton;
    private Button stopButton;
    private Button restartButton;
    private HostServicePolicy initPolicy;

    public SshConfiguration(Shell parentShell, IHost host) {
        super(parentShell);
        this.host = host;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("SSH configuration");
        this.errorMessage = "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0, true, false));
        group.setText("Status");
        this.statusLabel = new Label((Composite)group, 0);
        this.statusLabel.setText("Retrieving SSH service information from the target system. Please wait...    ");
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0, true, false));
        group.setText("Startup Policy");
        this.autoButton = new Button((Composite)group, 16);
        this.autoButton.setText("Start automatically");
        this.onButton = new Button((Composite)group, 16);
        this.onButton.setText("Start and stop with host");
        this.offButton = new Button((Composite)group, 16);
        this.offButton.setText("Start and stop manually");
        group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(3, true));
        group.setLayoutData((Object)new GridData(4, 0, true, false));
        group.setText("Service Commands");
        this.startButton = new Button((Composite)group, 8);
        GridData data = new GridData();
        data.widthHint = 80;
        this.startButton.setLayoutData((Object)data);
        this.startButton.setText("Start");
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SshConfiguration.this.serviceCommands(1);
            }
        });
        this.stopButton = new Button((Composite)group, 8);
        this.stopButton.setLayoutData((Object)data);
        this.stopButton.setText("Stop");
        this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SshConfiguration.this.serviceCommands(2);
            }
        });
        this.restartButton = new Button((Composite)group, 8);
        this.restartButton.setLayoutData((Object)data);
        this.restartButton.setText("Restart");
        this.restartButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SshConfiguration.this.serviceCommands(3);
            }
        });
        this.initializeServiceInfo();
        return composite;
    }

    protected void okPressed() {
        HostServicePolicy currentPolicy = null;
        if (this.autoButton.getSelection()) {
            currentPolicy = HostServicePolicy.automatic;
        } else if (this.onButton.getSelection()) {
            currentPolicy = HostServicePolicy.on;
        } else if (this.offButton.getSelection()) {
            currentPolicy = HostServicePolicy.off;
        }
        if (this.initPolicy != null && currentPolicy != null && !this.initPolicy.equals((Object)currentPolicy)) {
            final String newPolicy = currentPolicy.toString();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SshConfiguration.this.serviceSystem != null && SshConfiguration.this.sshService != null) {
                            SshConfiguration.this.serviceSystem.updateServicePolicy(SshConfiguration.this.sshService.getKey(), newPolicy);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        super.okPressed();
    }

    private void serviceCommands(int mode) {
        final Control control = this.getDialogArea();
        control.setCursor(new Cursor((Device)control.getDisplay(), 1));
        this.disableControls();
        class CommandJob
        extends Job {
            private final /* synthetic */ int val$mode;

            public CommandJob(String name, int n) {
                this.val$mode = n;
                super(name);
            }

            public IStatus run(IProgressMonitor monitor) {
                SshConfiguration.this.errorMessage = "";
                try {
                    if (this.val$mode == 1) {
                        if (SshConfiguration.this.sshService.getKey().equalsIgnoreCase(SshConfiguration.TSM_SSH)) {
                            SshConfiguration.this.disableTSMTimeout();
                        }
                        SshConfiguration.this.serviceSystem.startService(SshConfiguration.this.sshService.getKey());
                    } else if (this.val$mode == 2) {
                        SshConfiguration.this.serviceSystem.stopService(SshConfiguration.this.sshService.getKey());
                    } else if (this.val$mode == 3) {
                        if (SshConfiguration.this.sshService.getKey().equalsIgnoreCase(SshConfiguration.TSM_SSH)) {
                            SshConfiguration.this.disableTSMTimeout();
                        }
                        SshConfiguration.this.serviceSystem.restartService(SshConfiguration.this.sshService.getKey());
                    }
                    SshConfiguration.this.serviceSystem.refreshServices();
                    HostServiceInfo serviceInfo = SshConfiguration.this.serviceSystem.getServiceInfo();
                    HostService[] services = serviceInfo.getService();
                    int i = 0;
                    while (i < services.length) {
                        if (services[i].getKey().equalsIgnoreCase(SshConfiguration.TSM_SSH) || services[i].getKey().equalsIgnoreCase(SshConfiguration.SSHD) || services[i].getKey().equalsIgnoreCase(SshConfiguration.SSH)) {
                            SshConfiguration.this.sshService = services[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    SshConfiguration.this.errorMessage = e.getLocalizedMessage();
                    if (SshConfiguration.this.errorMessage == null || SshConfiguration.this.errorMessage.isEmpty()) {
                        SshConfiguration.this.errorMessage = e.toString();
                    }
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }
        CommandJob job = new CommandJob("Service Commands...", mode);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!control.isDisposed()) {
                    control.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            control.setCursor(null);
                            SshConfiguration.this.updateControls();
                        }
                    });
                }
            }
        });
        job.schedule();
    }

    private void initializeServiceInfo() {
        this.disableControls();
        class InitJob
        extends Job {
            InitJob(String name) {
                super(name);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResourcesSubSystem rss = RSEHelper.getResourcesSubSystem(SshConfiguration.this.host);
                    if (!rss.isConnected()) {
                        rss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                    }
                    SshConfiguration.this.hostSystem = rss.getHostSystem();
                    SshConfiguration.this.serviceSystem = SshConfiguration.this.hostSystem.getHostServiceSystem();
                    HostServiceInfo serviceInfo = SshConfiguration.this.serviceSystem.getServiceInfo();
                    HostService[] services = serviceInfo.getService();
                    int i = 0;
                    while (i < services.length) {
                        if (services[i].getKey().equalsIgnoreCase(SshConfiguration.TSM_SSH) || services[i].getKey().equalsIgnoreCase(SshConfiguration.SSHD) || services[i].getKey().equalsIgnoreCase(SshConfiguration.SSH)) {
                            SshConfiguration.this.sshService = services[i];
                            SshConfiguration.this.initPolicy = HostServicePolicy.valueOf((String)SshConfiguration.this.sshService.getPolicy());
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    SshConfiguration.this.errorMessage = e.getLocalizedMessage();
                    if (SshConfiguration.this.errorMessage == null || SshConfiguration.this.errorMessage.isEmpty()) {
                        SshConfiguration.this.errorMessage = e.toString();
                    }
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }
        InitJob job = new InitJob("Initializing SSH Service Info...");
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!SshConfiguration.this.getParentShell().isDisposed()) {
                    SshConfiguration.this.getParentShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SshConfiguration.this.updateControls();
                        }
                    });
                }
            }
        });
        job.schedule();
    }

    private void updateControls() {
        if (this.sshService == null) {
            if (this.errorMessage.isEmpty()) {
                this.statusLabel.setText(" No SSH service is found. This function supported only with ESXi 4.1 or higher");
            } else {
                this.statusLabel.setText(" " + this.errorMessage);
            }
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.sshService.isRunning() ? " Running" : " Stopped");
            if (this.sshService.isRunning() && this.sshService.getKey().equalsIgnoreCase(SSHD)) {
                buffer.append("   (Please make sure that root login is enabled)");
            }
            this.statusLabel.setText(buffer.toString());
        }
        if (this.sshService != null) {
            HostServicePolicy policy = HostServicePolicy.valueOf((String)this.sshService.getPolicy());
            if (policy == HostServicePolicy.automatic) {
                this.autoButton.setSelection(true);
                this.autoButton.setFocus();
                this.onButton.setSelection(false);
                this.offButton.setSelection(false);
            } else if (policy == HostServicePolicy.on) {
                this.onButton.setSelection(true);
                this.onButton.setFocus();
                this.autoButton.setSelection(false);
                this.offButton.setSelection(false);
            } else if (policy == HostServicePolicy.off) {
                this.offButton.setSelection(true);
                this.offButton.setFocus();
                this.autoButton.setSelection(false);
                this.onButton.setSelection(false);
            }
            if (this.sshService.isRunning()) {
                this.startButton.setEnabled(false);
                this.stopButton.setEnabled(true);
                this.restartButton.setEnabled(true);
            } else {
                this.startButton.setEnabled(true);
                this.stopButton.setEnabled(false);
                this.restartButton.setEnabled(false);
            }
        }
        Button okButton = this.getButton(0);
        if (this.sshService == null) {
            okButton.setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    private void disableTSMTimeout() throws Exception {
        OptionManager optManager = this.hostSystem.getOptionManager();
        OptionValue[] opts = null;
        try {
            opts = optManager.queryOptions("UserVars.TSMTimeOut");
        }
        catch (InvalidName invalidName) {}
        if (opts == null) {
            try {
                opts = optManager.queryOptions("UserVars.ESXiShellTimeOut");
            }
            catch (InvalidName invalidName) {}
        }
        if (opts == null) {
            this.errorMessage = "Warning: failed to disable timeout on the remote shell.";
            return;
        }
        Long timeout = (Long)opts[0].getValue();
        if (timeout > 0L) {
            opts[0].setValue((Object)new Long(0L));
            optManager.updateOptions(opts);
        }
    }

    private void disableControls() {
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.restartButton.setEnabled(false);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            this.getButton(0).setEnabled(false);
        }
    }
}

