/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.views;

import com.vmware.vide.rse.VIDERSEPlugin;
import com.vmware.vide.rse.api.impl.RemoteProcess;
import com.vmware.vide.rse.util.RSEHelper;
import com.vmware.vim25.DiagnosticManagerLogDescriptor;
import com.vmware.vim25.DiagnosticManagerLogHeader;
import com.vmware.vim25.InvalidArgument;
import com.vmware.vim25.mo.DiagnosticManager;
import com.vmware.vim25.mo.ServiceInstance;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.console.ConsolePluginImages;
import org.eclipse.ui.part.ViewPart;

public class SyslogMonitorView
extends ViewPart {
    private Combo logCombo;
    private TextViewer logViewer;
    private IHost host;
    private final Map<Integer, String> logkeyMap = new HashMap<Integer, String>();
    private int currentIndex;
    private boolean isSwitched;
    private boolean isScrollLocked;
    private LogCollector logCollector;
    private Action lockScroll;
    private Action clearLog;
    private Action markLog;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.logCombo = new Combo(composite, 12);
        this.logCombo.setLayoutData((Object)new GridData(768));
        this.logCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Combo && SyslogMonitorView.this.currentIndex != SyslogMonitorView.this.logCombo.getSelectionIndex()) {
                    SyslogMonitorView.this.currentIndex = SyslogMonitorView.this.logCombo.getSelectionIndex();
                    SyslogMonitorView.this.isSwitched = true;
                }
            }
        });
        this.logViewer = new TextViewer(composite, 776);
        this.logViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.logViewer.setDocument((IDocument)new Document());
        this.createToolBarActions();
    }

    private void createToolBarActions() {
        this.markLog = new MarkLogAction();
        this.markLog.setEnabled(false);
        this.clearLog = new ClearLogAction();
        this.clearLog.setEnabled(false);
        this.lockScroll = new LockScrollAction();
        this.lockScroll.setEnabled(false);
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IAction)this.markLog);
        manager.add((IAction)this.clearLog);
        manager.add((IAction)this.lockScroll);
    }

    public void setFocus() {
        if (this.logViewer != null) {
            this.logViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        if (this.logCollector != null) {
            this.logCollector.stopLogCollector();
        }
        super.dispose();
    }

    public void start(IHost host) {
        this.host = host;
        this.setPartName(host.getAliasName());
        if (this.logCollector == null || !this.logCollector.isAlive()) {
            this.logCollector = new LogCollector();
            this.logCollector.start();
        }
    }

    private class ClearLogAction
    extends Action {
        public ClearLogAction() {
            super("Clear Log", ConsolePluginImages.getImageDescriptor((String)"IMG_ELCL_CLEAR"));
            this.setToolTipText("Clear log display");
        }

        public void run() {
            if (SyslogMonitorView.this.logViewer != null && !SyslogMonitorView.this.logViewer.getControl().isDisposed() && SyslogMonitorView.this.logViewer.getControl() != null && !SyslogMonitorView.this.logViewer.getControl().isDisposed()) {
                SyslogMonitorView.this.logViewer.setDocument((IDocument)new Document());
            }
        }
    }

    private class LockScrollAction
    extends Action {
        public LockScrollAction() {
            super("Lock Scroll", 2);
            this.setImageDescriptor(ConsolePluginImages.getImageDescriptor((String)"IMG_ELCL_LOCK"));
            this.setToolTipText("Lock scroll bar");
        }

        public void run() {
            SyslogMonitorView.this.isScrollLocked = this.isChecked();
        }
    }

    private class LogCollector
    extends Thread {
        private boolean isActive;
        private static final int ONETIME_READ = 500;

        private LogCollector() {
        }

        @Override
        public void run() {
            DiagnosticManager manager = null;
            try {
                ServiceInstance si = RSEHelper.getServiceInstance(SyslogMonitorView.this.host);
                manager = si.getDiagnosticManager();
                this.initLogInfo(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)SyslogMonitorView.this.getSite().getShell(), (String)"Error", (String)("Error when getting log informaiton from " + SyslogMonitorView.this.host.getAliasName()));
                    }
                });
                return;
            }
            this.isActive = true;
            int start = 1;
            String logkey = (String)SyslogMonitorView.this.logkeyMap.get(new Integer(SyslogMonitorView.this.currentIndex));
            while (this.isActive) {
                if (SyslogMonitorView.this.isSwitched) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            SyslogMonitorView.this.logViewer.setDocument((IDocument)new Document());
                            SyslogMonitorView.this.isSwitched = false;
                        }
                    });
                    start = 1;
                    logkey = (String)SyslogMonitorView.this.logkeyMap.get(new Integer(SyslogMonitorView.this.currentIndex));
                }
                try {
                    DiagnosticManagerLogHeader header = manager.browseDiagnosticLog(null, logkey, start, 500);
                    String[] lines = header.getLineText();
                    if (lines != null && lines.length > 0) {
                        final StringBuffer buffer = new StringBuffer(lines.length * 100);
                        String[] stringArray = lines;
                        int n = lines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            buffer.append(String.valueOf(line) + "\n");
                            ++n2;
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (SyslogMonitorView.this.logViewer.getControl() != null && !SyslogMonitorView.this.logViewer.getControl().isDisposed()) {
                                    SyslogMonitorView.this.logViewer.getTextWidget().append(buffer.toString());
                                    if (!SyslogMonitorView.this.isScrollLocked) {
                                        int lines = SyslogMonitorView.this.logViewer.getDocument().getNumberOfLines();
                                        SyslogMonitorView.this.logViewer.setTopIndex(lines - 1);
                                    }
                                }
                            }
                        });
                    } else if (start - 1 > header.getLineEnd()) {
                        if (SyslogMonitorView.this.host.getSystemType().getId().equals("vide.rse.systemtype.esx")) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (SyslogMonitorView.this.logViewer.getControl() != null && !SyslogMonitorView.this.logViewer.getControl().isDisposed()) {
                                        SyslogMonitorView.this.logViewer.setDocument((IDocument)new Document());
                                    }
                                }
                            });
                        }
                        start = 1;
                        continue;
                    }
                    start = header.getLineEnd() + 1;
                    if (lines != null && lines.length >= 500) continue;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                catch (InvalidArgument e) {
                    if (SyslogMonitorView.this.host.getSystemType().getId().equals("vide.rse.systemtype.vc")) {
                        try {
                            this.initLogInfo(manager);
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (SyslogMonitorView.this.logViewer.getControl() != null && !SyslogMonitorView.this.logViewer.getControl().isDisposed()) {
                                        SyslogMonitorView.this.logViewer.setDocument((IDocument)new Document());
                                    }
                                }
                            });
                            start = 1;
                            logkey = (String)SyslogMonitorView.this.logkeyMap.get(new Integer(SyslogMonitorView.this.currentIndex));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openError((Shell)SyslogMonitorView.this.getSite().getShell(), (String)"Error", (String)("Error when getting log informaiton from " + SyslogMonitorView.this.host.getAliasName()));
                                }
                            });
                            this.isActive = false;
                        }
                        continue;
                    }
                    e.printStackTrace();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)SyslogMonitorView.this.getSite().getShell(), (String)"Error", (String)("Error when collecting log data from " + SyslogMonitorView.this.host.getAliasName()));
                        }
                    });
                    this.isActive = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)SyslogMonitorView.this.getSite().getShell(), (String)"Error", (String)("Error when collecting log data from " + SyslogMonitorView.this.host.getAliasName()));
                        }
                    });
                    this.isActive = false;
                }
            }
        }

        public void stopLogCollector() {
            this.isActive = false;
            this.interrupt();
        }

        private void initLogInfo(DiagnosticManager manager) throws Exception {
            final DiagnosticManagerLogDescriptor[] logs = manager.queryDescriptions(null);
            if (logs == null || logs.length <= 0) {
                throw new Exception("No log entry is found on " + SyslogMonitorView.this.host.getAliasName());
            }
            final boolean hasMarkLog = RSEHelper.isESX50OrHigher(SyslogMonitorView.this.host);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (SyslogMonitorView.this.logCombo.isDisposed()) {
                        return;
                    }
                    if (SyslogMonitorView.this.host.getSystemType().getId().equals("vide.rse.systemtype.esx")) {
                        SyslogMonitorView.this.markLog.setEnabled(hasMarkLog);
                    }
                    SyslogMonitorView.this.clearLog.setEnabled(true);
                    SyslogMonitorView.this.lockScroll.setEnabled(true);
                    SyslogMonitorView.this.logCombo.removeAll();
                    SyslogMonitorView.this.logkeyMap.clear();
                    DiagnosticManagerLogDescriptor[] diagnosticManagerLogDescriptorArray = logs;
                    int n = logs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DiagnosticManagerLogDescriptor log = diagnosticManagerLogDescriptorArray[n2];
                        String entry = MessageFormat.format("{0} [ {1} ]", log.getInfo().getLabel(), log.getFileName());
                        SyslogMonitorView.this.logCombo.add(entry);
                        SyslogMonitorView.this.logkeyMap.put(new Integer(SyslogMonitorView.this.logCombo.indexOf(entry)), log.getKey());
                        if (log.getKey().contains("vmkernel")) {
                            SyslogMonitorView.this.logCombo.setText(entry);
                        }
                        ++n2;
                    }
                    if (SyslogMonitorView.this.logCombo.getText().isEmpty()) {
                        SyslogMonitorView.this.logCombo.select(0);
                    }
                    SyslogMonitorView.this.currentIndex = SyslogMonitorView.this.logCombo.getSelectionIndex();
                }
            });
        }
    }

    private class MarkLogAction
    extends Action {
        public MarkLogAction() {
            super("Mark Log", VIDERSEPlugin.getDefault().getImageDescriptor("action_marklog"));
            this.setToolTipText("Add your message to all syslogs");
        }

        public void run() {
            InputDialog dialog = new InputDialog(SyslogMonitorView.this.getViewSite().getShell(), "Add your message", "Add your own log message to all syslogs", null, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.isEmpty()) {
                        return "";
                    }
                    return null;
                }
            });
            if (dialog.open() == 0) {
                final String message = dialog.getValue().trim();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)SyslogMonitorView.this.host);
                            if (!fss.isConnected()) {
                                fss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                            }
                            RemoteProcess proc = new RemoteProcess(SyslogMonitorView.this.host, "esxcli system syslog mark -s \"" + message + "\"");
                            SequenceInputStream is = new SequenceInputStream(proc.getInputStream(), proc.getErrorStream());
                            BufferedReader br = new BufferedReader(new InputStreamReader(is));
                            proc.run();
                            while (br.readLine() != null) {
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
        }
    }
}

