/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.VIDERSEPlugin;
import com.vmware.vide.rse.api.impl.RemoteProcess;
import com.vmware.vide.rse.subsystems.ResourcesSubSystem;
import com.vmware.vide.rse.util.RSEHelper;
import com.vmware.vim25.RestrictedVersion;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.Task;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class ESXUtil {
    static ILog logger = VIDERSEPlugin.getDefault().getLog();

    public static IStatus reboot(IHost host, IProgressMonitor monitor) {
        ResourcesSubSystem rss = RSEHelper.getResourcesSubSystem(host);
        try {
            try {
                HostSystem hostSystem = rss.getHostSystem();
                Task task = hostSystem.rebootHost(true);
                RSEHelper.waitForTask(task);
            }
            catch (RestrictedVersion e) {
                try {
                    ESXUtil.runCommand(host, "reboot", null, null, monitor);
                    logger.log((IStatus)new Status(2, "com.vmware.vide.rse", "Fall back to the reboot command.", (Throwable)e));
                }
                catch (Exception e1) {
                    Status status = new Status(4, "com.vmware.vide.rse", "Failed to reboot " + host.getAliasName(), (Throwable)e1);
                    monitor.done();
                    return status;
                }
                monitor.done();
            }
            catch (Exception e) {
                Status status = new Status(4, "com.vmware.vide.rse", "Failed to reboot " + host.getAliasName(), (Throwable)e);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private static int runCommand(IHost host, String command, List<String> out, List<String> err, IProgressMonitor monitor) throws Exception {
        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)host);
        if (!fss.isConnected()) {
            fss.connect(monitor, false);
        }
        RemoteProcess proc = new RemoteProcess(host, command);
        proc.run();
        OutputReader eThread = new OutputReader(proc.getErrorStream(), err);
        OutputReader oThread = new OutputReader(proc.getInputStream(), out);
        eThread.start();
        oThread.start();
        int retval = -1;
        try {
            retval = proc.waitFor();
            eThread.join();
            oThread.join();
        }
        finally {
            if (eThread.isAlive()) {
                eThread.interrupt();
            }
            if (oThread.isAlive()) {
                oThread.interrupt();
            }
        }
        return retval;
    }

    static class OutputReader
    extends Thread {
        List<String> lines;
        InputStream is;

        OutputReader(InputStream is, List<String> lines) {
            this.is = is;
            this.lines = lines;
        }

        @Override
        public void run() {
            block13: {
                BufferedReader br = null;
                try {
                    try {
                        String line;
                        br = new BufferedReader(new InputStreamReader(this.is));
                        while ((line = br.readLine()) != null) {
                            if (this.lines == null) continue;
                            this.lines.add(line);
                        }
                    }
                    catch (IOException e) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.rse", null, (Throwable)e));
                        if (br == null) break block13;
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            logger.log((IStatus)new Status(4, "com.vmware.vide.rse", null, (Throwable)e2));
                        }
                    }
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            logger.log((IStatus)new Status(4, "com.vmware.vide.rse", null, (Throwable)e));
                        }
                    }
                }
            }
        }
    }
}

