/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.RSEResources;
import com.vmware.vide.rse.api.impl.RemoteProcess;
import com.vmware.vide.rse.ui.wizard.InstallWizard;
import com.vmware.vide.rse.util.RSEHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class InstallProgressPage
extends WizardPage
implements Listener {
    public static final int REQUIRE_NONE = 0;
    public static final int REQUIRE_REBOOT_TARGET = 1;
    public static final int REQUIRE_RESTART_AGENT = 2;
    private Button installButton;
    private Text displayText;
    private IHost[] hostList;
    private final List<IHost> goodInstall = new ArrayList<IHost>();
    private final List<IHost> badInstall = new ArrayList<IHost>();
    private final List<IHost> rebootTarget = new ArrayList<IHost>();
    private final List<IHost> restartHostd = new ArrayList<IHost>();
    private boolean installComplete;

    public InstallProgressPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription("Installing package on given hosts");
        this.installComplete = false;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite header = new Composite(composite, 0);
        header.setLayout((Layout)new GridLayout(2, false));
        header.setLayoutData((Object)new GridData(768));
        Label label = new Label(header, 0);
        label.setText("Please click on \"Install\" button to install the package on selected hosts.");
        label.setLayoutData((Object)new GridData(768));
        this.installButton = new Button(header, 8);
        this.installButton.setText("Install");
        this.installButton.setLayoutData((Object)new GridData(768));
        this.installButton.addListener(13, (Listener)this);
        new Label(composite, 0);
        this.displayText = new Text(composite, 2570);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.displayText.setLayoutData((Object)data);
        this.setControl((Control)composite);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.installButton) {
            MessageBox userConfirmationbox = new MessageBox(this.getShell(), 288);
            userConfirmationbox.setMessage("You are about to install VIB package. \nYou cannot cancel this operation once it starts.  \nPress Ok to continue?. \n\nInstallation might take a while, please wait... ");
            userConfirmationbox.setText("VIB Installation");
            int userconfirmation = userConfirmationbox.open();
            if (userconfirmation != 32) {
                return;
            }
            String filename = ((InstallWizard)this.getWizard()).getPackageFile();
            this.hostList = ((InstallWizard)this.getWizard()).getSelectedHost();
            this.displayText.setText("");
            this.goodInstall.clear();
            this.badInstall.clear();
            this.rebootTarget.clear();
            this.restartHostd.clear();
            InstallJob job = new InstallJob("Installing package...", filename, this.hostList);
            try {
                try {
                    this.getContainer().run(true, true, (IRunnableWithProgress)job);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    this.installComplete = true;
                    this.getWizard().getContainer().updateButtons();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.installComplete = true;
                    this.getWizard().getContainer().updateButtons();
                }
            }
            finally {
                this.installComplete = true;
                this.getWizard().getContainer().updateButtons();
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.installComplete;
    }

    public IWizardPage getNextPage() {
        IWizardPage summary = super.getNextPage();
        Control control = summary.getControl();
        control.dispose();
        Composite parent = this.getControl().getParent();
        summary.createControl(parent);
        parent.layout();
        return summary;
    }

    public InstallReport[] getReports() {
        ArrayList<InstallReport> list = new ArrayList<InstallReport>();
        if (this.hostList == null) {
            return new InstallReport[0];
        }
        int i = 0;
        while (i < this.hostList.length) {
            InstallReport report = new InstallReport(this.hostList[i]);
            if (this.goodInstall.contains(this.hostList[i])) {
                report.setSuccess(true);
            } else if (this.badInstall.contains(this.hostList[i])) {
                report.setSuccess(false);
            }
            if (this.rebootTarget.contains(this.hostList[i])) {
                report.setRequirement(1);
            } else if (this.restartHostd.contains(this.hostList[i])) {
                report.setRequirement(2);
            } else {
                report.setRequirement(0);
            }
            list.add(report);
            ++i;
        }
        return list.toArray(new InstallReport[list.size()]);
    }

    class InstallJob
    implements IRunnableWithProgress {
        private final String fileName;
        private final IHost[] hosts;
        private static final String indent = "   ";
        private static final int VIB_INSTALL = 1;
        private static final int RPM_INSTALL = 2;
        private static final int OFFLINE_BUNDLE_INSTALL = 3;
        private final int mode;

        public InstallJob(String name, String fileName, IHost[] hosts) {
            this.fileName = fileName;
            this.hosts = hosts;
            this.mode = this.checkInstallPackage(fileName);
        }

        public void run(IProgressMonitor monitor) {
            if (this.hosts.length > 0) {
                monitor.beginTask("", this.hosts.length);
            }
            int i = 0;
            while (i < this.hosts.length) {
                block9: {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        try {
                            this.appendText("***** Installing " + this.fileName.substring(this.fileName.lastIndexOf(File.separatorChar) + 1) + " on " + this.hosts[i].getAliasName() + " *****\n");
                            this.deployPackage(this.hosts[i], this.fileName, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            InstallProgressPage.this.goodInstall.add(this.hosts[i]);
                        }
                        catch (Exception e) {
                            String msg = e.getLocalizedMessage();
                            if (msg != null && !msg.isEmpty()) {
                                this.appendText(indent + e.getLocalizedMessage());
                            }
                            InstallProgressPage.this.badInstall.add(this.hosts[i]);
                            this.appendText("\n\n");
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        this.appendText("\n\n");
                        throw throwable;
                    }
                    this.appendText("\n\n");
                }
                ++i;
            }
            monitor.done();
        }

        private void deployPackage(final IHost host, String fileName, IProgressMonitor monitor) throws Exception {
            try {
                monitor.beginTask("", 100);
                if (this.mode == 2 && RSEHelper.isVisor(host)) {
                    this.appendText("   RPM files cannot be installed on ESXi systems.");
                    throw new Exception();
                }
                if (!(this.mode != 1 && this.mode != 3 || host.getSystemType().getId().equals("vide.rse.systemtype.esx"))) {
                    this.appendText("   VIB files are only supported on ESX system.");
                    throw new Exception();
                }
                String copiedFile = this.remoteCopy(host, fileName, RSEResources.Remote_TMP_dir, monitor);
                if (copiedFile == null || copiedFile.isEmpty()) {
                    this.appendText("   Failed to copy " + fileName);
                    throw new Exception();
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.worked(50);
                StringBuffer installCommand = new StringBuffer();
                if (this.mode == 2) {
                    installCommand.append(RSEResources.RPMCommand);
                    installCommand.append(" ");
                    installCommand.append(copiedFile);
                } else if (this.mode == 1 || this.mode == 3) {
                    if (RSEHelper.isESX50OrHigher(host)) {
                        installCommand.append(RSEResources.Visor_PYTHONPATH);
                        installCommand.append(";");
                        installCommand.append(NLS.bind((String)RSEResources.ESXCLICommand, (Object)this.getEsxcliOption(this.mode), (Object)copiedFile));
                    } else {
                        if (RSEHelper.isVisor(host)) {
                            installCommand.append(RSEResources.Visor_PYTHONPATH);
                            installCommand.append(";");
                        }
                        installCommand.append(NLS.bind((String)RSEResources.ESXUPDATECommand, (Object)this.getEsxupdateOption(this.mode), (Object)copiedFile));
                    }
                } else {
                    this.appendText(indent + fileName + " is not supported.\n");
                    throw new Exception();
                }
                int errorCode = this.remoteCommand(host, installCommand.toString(), monitor);
                if (errorCode != 0) {
                    if (this.mode == 1 && (errorCode == 80 || errorCode == 81)) {
                        if (errorCode == 80) {
                            InstallProgressPage.this.rebootTarget.add(host);
                        } else if (errorCode == 81) {
                            InstallProgressPage.this.restartHostd.add(host);
                        }
                        return;
                    }
                    throw new Exception("");
                }
                if (RSEHelper.isESX50OrHigher(host)) {
                    final String rebootMessage = RSEHelper.isESX50(host) ? "needs to be rebooted" : "Reboot Required: true";
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (InstallProgressPage.this.displayText.getText().contains(rebootMessage)) {
                                InstallProgressPage.this.rebootTarget.add(host);
                            }
                        }
                    });
                }
            }
            finally {
                monitor.done();
            }
        }

        private String remoteCopy(IHost host, String srcFile, String dstFolder, IProgressMonitor monitor) throws Exception {
            IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)host);
            if (!fss.isConnected()) {
                fss.connect(monitor, false);
                if (!fss.isConnected()) {
                    this.appendText("Could not reconnect.");
                    throw new Exception();
                }
                this.appendText("Reconnected successfully.\n");
            }
            String fileName = srcFile.substring(srcFile.lastIndexOf(File.separatorChar));
            IRemoteFile dstFile = fss.getRemoteFileObject(String.valueOf(dstFolder) + fileName, monitor);
            fss.upload(srcFile, dstFile, null, monitor);
            return dstFile.getCanonicalPath();
        }

        private int remoteCommand(IHost host, String command, IProgressMonitor monitor) throws Exception {
            String line;
            IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)host);
            if (!fss.isConnected()) {
                fss.connect(monitor, false);
            }
            RemoteProcess proc = new RemoteProcess(host, command);
            SequenceInputStream is = new SequenceInputStream(proc.getInputStream(), proc.getErrorStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            proc.run();
            while ((line = br.readLine()) != null) {
                this.appendText(indent + line + "\n");
            }
            return proc.waitFor();
        }

        private int checkInstallPackage(String fileName) {
            String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
            if (extension != null) {
                if (extension.equalsIgnoreCase("rpm")) {
                    return 2;
                }
                if (extension.equalsIgnoreCase("vib")) {
                    return 1;
                }
                if (extension.equalsIgnoreCase("zip")) {
                    return 3;
                }
            }
            return 0;
        }

        private void appendText(final String text) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    InstallProgressPage.this.displayText.append(text);
                }
            });
        }

        private String getEsxcliOption(int mode) {
            if (mode == 1) {
                return RSEResources.ESXCLI_VIB_OPTION;
            }
            return RSEResources.ESXCLI_OFFLINE_BUNDLE_OPTION;
        }

        private String getEsxupdateOption(int mode) {
            if (mode == 1) {
                return RSEResources.ESXUPDATE_VIB_OPTION;
            }
            return RSEResources.ESXUPDATE_OFFLINE_BUNDLE_OPTION;
        }
    }

    class InstallReport {
        private final IHost host;
        private boolean success;
        private int requirement;

        InstallReport(IHost host) {
            this.host = host;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public IHost getHost() {
            return this.host;
        }

        public void setRequirement(int action) {
            this.requirement = action;
        }

        public boolean isSuccessful() {
            return this.success;
        }

        public int getRequirement() {
            return this.requirement;
        }
    }
}

