/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.VIDERSEPlugin;
import com.vmware.vide.rse.api.impl.RemoteProcess;
import com.vmware.vide.rse.ui.wizard.PackageInstallOptionPage;
import com.vmware.vide.rse.ui.wizard.PackageInstallWizard;
import com.vmware.vide.rse.util.MyTreeContentProvider;
import com.vmware.vide.rse.util.MyTreeElement;
import com.vmware.vide.rse.util.RSEHelper;
import com.vmware.vide.utils.ui.ActionableEditField;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.IElementCollector;

public class PackageInstallDepotPage
extends WizardPage {
    private DepotField field;
    private TreeViewer treeViewer;
    private String depotLoc;
    private String selectionName;
    private int installType;

    protected PackageInstallDepotPage(String pageName) {
        super(pageName);
        this.setTitle("Depot Location");
        this.setDescription("Select depot or off-line bundle (a zip package)");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createDepotSelect(composite);
        Label label = new Label(composite, 0);
        label.setText("Packages available in depot or off-line bundle:");
        this.createTreeViewer(composite);
        this.setControl((Control)composite);
    }

    private void createDepotSelect(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Enter depot URL(http, https, ftp) or off-line bundle (*.zip) from server :");
        BrowseAction browse = new BrowseAction("B&rowse...", "Browse Remote File system");
        this.field = new DepotField(composite, "depot_location");
        this.field.init(null, true, (IAction[])new Action[]{browse}, VIDERSEPlugin.getDefault().getPreferenceStore());
        this.field.getCombo().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    e.detail = 0;
                }
            }
        });
        this.field.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String txt = PackageInstallDepotPage.this.field.getText();
                int type = ((PackageInstallWizard)PackageInstallDepotPage.this.getWizard()).getInstallType();
                if (!txt.equals(PackageInstallDepotPage.this.depotLoc) || PackageInstallDepotPage.this.installType != type) {
                    PackageInstallDepotPage.this.depotLoc = PackageInstallDepotPage.this.field.getText();
                    PackageInstallDepotPage.this.installType = type;
                    PackageInstallDepotPage.this.selectionName = null;
                    PackageInstallDepotPage.this.treeViewer.setInput((Object)new TreeRoot("Root"));
                    PackageInstallDepotPage.this.field.showErrorMarker();
                    PackageInstallDepotPage.this.getContainer().updateButtons();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void createTreeViewer(Composite composite) {
        this.treeViewer = new TreeViewer(composite, 0x10000800);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new MyTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String status;
                if (element instanceof VibPackageEntry && (status = ((VibPackageEntry)element).getStatus()) != null && !status.isEmpty()) {
                    String label = MessageFormat.format("{0} ({1})", super.getText(element), status);
                    return label;
                }
                return super.getText(element);
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                ISelection selection = event.getSelection();
                Object object = ((IStructuredSelection)selection).getFirstElement();
                if (object instanceof VibPackageEntry || object instanceof ProfileEntry) {
                    PackageInstallDepotPage.this.selectionName = object.toString();
                } else {
                    PackageInstallDepotPage.this.selectionName = null;
                }
                PackageInstallDepotPage.this.getContainer().updateButtons();
            }
        });
    }

    public IWizardPage getNextPage() {
        IWizardPage page = ((PackageInstallWizard)this.getWizard()).getOptionPage();
        ((PackageInstallOptionPage)page).updateOptions();
        return page;
    }

    public boolean canFlipToNextPage() {
        return this.selectionName != null && this.installType == ((PackageInstallWizard)this.getWizard()).getInstallType();
    }

    public String getDepot() {
        return this.depotLoc;
    }

    public String getDepotSelection() {
        return this.selectionName;
    }

    private class BrowseAction
    extends Action {
        public BrowseAction(String text, String tooltip) {
            this.setText(text);
            this.setToolTipText(tooltip);
        }

        public void run() {
            Object selected;
            IHost host = ((PackageInstallWizard)PackageInstallDepotPage.this.getWizard()).getHost();
            SystemRemoteFileDialog dialog = new SystemRemoteFileDialog(PackageInstallDepotPage.this.getShell(), "Select Off-line bundle", host);
            dialog.setDefaultSystemConnection(host, true);
            if (dialog.open() == 0 && (selected = dialog.getOutputObject()) instanceof IRemoteFile) {
                RemoteFile remoteFile = (RemoteFile)selected;
                PackageInstallDepotPage.this.depotLoc = remoteFile.getAbsolutePath();
                PackageInstallDepotPage.this.installType = ((PackageInstallWizard)PackageInstallDepotPage.this.getWizard()).getInstallType();
                PackageInstallDepotPage.this.selectionName = null;
                PackageInstallDepotPage.this.field.setText(PackageInstallDepotPage.this.depotLoc);
                PackageInstallDepotPage.this.treeViewer.setInput((Object)new TreeRoot("Root"));
                PackageInstallDepotPage.this.field.showErrorMarker();
                PackageInstallDepotPage.this.getContainer().updateButtons();
            }
        }
    }

    private class DepotField
    extends ActionableEditField {
        public DepotField(Composite parent, String id) {
            super(parent, id);
        }

        public void init(IAction comboAction, boolean editable, IAction[] usrActions, IPreferenceStore store) {
            Control[] controls;
            super.init(comboAction, editable, usrActions, store);
            Layout layout = this.row.getLayout();
            if (layout instanceof GridLayout) {
                ((GridLayout)layout).marginWidth = 0;
                ((GridLayout)layout).horizontalSpacing = 0;
                ((GridLayout)layout).marginHeight = 0;
                ((GridLayout)layout).marginBottom = 0;
                this.row.setLayout(layout);
            }
            this.row.setLayoutData((Object)new GridData(4, 0, true, false));
            Object object = this.comboBox.getLayoutData();
            if (object instanceof GridData) {
                GridData data = (GridData)object;
                data.grabExcessHorizontalSpace = true;
                data.horizontalAlignment = 4;
                data.widthHint = -1;
                this.comboBox.setLayoutData((Object)data);
            }
            if ((layout = this.actionsRow.getLayout()) instanceof GridLayout) {
                ((GridLayout)layout).marginLeft = 5;
                ((GridLayout)layout).marginWidth = 0;
                this.actionsRow.setLayout(layout);
            }
            PackageInstallDepotPage.this.initializeDialogUnits((Control)this.actionsRow);
            Control[] controlArray = controls = this.actionsRow.getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Button && "Browse...".equals(((Button)control).getText())) {
                    GridData data = new GridData();
                    data.widthHint = PackageInstallDepotPage.this.convertHorizontalDLUsToPixels(61);
                    control.setLayoutData((Object)data);
                }
                ++n2;
            }
        }

        public boolean isValid() {
            String name = this.comboBox.getText();
            if (!name.isEmpty()) {
                PackageInstallDepotPage.this.getContainer().updateButtons();
                try {
                    URL url = new URL(name);
                    String file = url.getFile();
                    return file.toLowerCase().endsWith("xml");
                }
                catch (MalformedURLException malformedURLException) {
                    return name.toLowerCase().endsWith("zip");
                }
            }
            return false;
        }
    }

    private class ProfileEntry
    extends MyTreeElement {
        public ProfileEntry(String name, MyTreeElement parent) {
            super(name, parent);
        }

        @Override
        public boolean isContainer() {
            return false;
        }
    }

    private class TreeRoot
    extends MyTreeElement {
        public TreeRoot(String name) {
            super(name, null);
        }

        @Override
        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            block24: {
                BufferedReader reader = null;
                monitor.beginTask("Collect VIB package list...", -1);
                try {
                    try {
                        String line;
                        IHost host = ((PackageInstallWizard)PackageInstallDepotPage.this.getWizard()).getHost();
                        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)host);
                        if (!fss.isConnected()) {
                            fss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                        }
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        boolean profileInstall = ((PackageInstallWizard)PackageInstallDepotPage.this.getWizard()).getInstallType() == 3;
                        StringBuffer command = new StringBuffer("esxcli software sources ");
                        if (profileInstall) {
                            command.append("profile list");
                        } else {
                            command.append("vib list");
                        }
                        command.append(" --depot ");
                        command.append(PackageInstallDepotPage.this.depotLoc);
                        RemoteProcess process = new RemoteProcess(host, command.toString());
                        reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        process.run();
                        int i = 0;
                        while ((line = reader.readLine()) != null) {
                            if (i >= 2) {
                                String[] tokens = line.split("\\s+");
                                if (profileInstall) {
                                    collector.add((Object)new ProfileEntry(tokens[0], this), monitor);
                                } else {
                                    VibPackageEntry entry = new VibPackageEntry(String.valueOf(tokens[0]) + ":" + tokens[1], this);
                                    if (tokens.length > 3) {
                                        entry.setStatus(tokens[tokens.length - 1]);
                                    }
                                    collector.add((Object)entry, monitor);
                                }
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        final String error = RSEHelper.getErrorMessage(e);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PackageInstallDepotPage.this.setErrorMessage(error);
                            }
                        });
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        monitor.done();
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    monitor.done();
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.done();
            }
        }
    }

    private class VibDataEntry
    extends MyTreeElement {
        public VibDataEntry(String name, MyTreeElement parent) {
            super(name, parent);
        }

        @Override
        public boolean isContainer() {
            return false;
        }
    }

    private class VibPackageEntry
    extends MyTreeElement {
        private String status;

        public VibPackageEntry(String name, MyTreeElement parent) {
            super(name, parent);
        }

        public void setStatus(String newStatus) {
            this.status = newStatus;
        }

        public String getStatus() {
            return this.status;
        }

        @Override
        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            block20: {
                BufferedReader reader = null;
                monitor.beginTask("Collect VIB package info...", -1);
                try {
                    try {
                        String line;
                        IHost host = ((PackageInstallWizard)PackageInstallDepotPage.this.getWizard()).getHost();
                        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)host);
                        if (!fss.isConnected()) {
                            fss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                        }
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        StringBuffer command = new StringBuffer("esxcli software sources vib get ");
                        command.append("--depot ");
                        command.append(PackageInstallDepotPage.this.depotLoc);
                        command.append(" --vibname ");
                        command.append(object.toString());
                        RemoteProcess process = new RemoteProcess(host, command.toString());
                        reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        process.run();
                        int i = 0;
                        while ((line = reader.readLine()) != null) {
                            if (i >= 2) {
                                if (!line.isEmpty()) {
                                    collector.add((Object)new VibDataEntry(line, this), monitor);
                                }
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        final String error = RSEHelper.getErrorMessage(e);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PackageInstallDepotPage.this.setErrorMessage(error);
                            }
                        });
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        monitor.done();
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    monitor.done();
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.done();
            }
        }
    }
}

