/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.api.impl.RemoteProcess;
import com.vmware.vide.rse.ui.wizard.PackageInstallWizard;
import com.vmware.vide.rse.util.RSEHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PackageInstallInstallPage
extends WizardPage {
    private Text displayText;
    private boolean installComplete = false;
    private boolean needToReboot = false;

    protected PackageInstallInstallPage(String pageName) {
        super(pageName);
        this.setTitle("Install Package");
        this.setDescription("Install a VIB package on the host");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createHeader(composite);
        this.displayText = new Text(composite, 2634);
        this.displayText.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        return this.installComplete;
    }

    private void createHeader(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.initializeDialogUnits((Control)composite);
        Label label = new Label(composite, 0);
        label.setText("Click \"Install\" button to start installation");
        label.setLayoutData((Object)new GridData(768));
        Button button = new Button(composite, 8);
        GridData data = new GridData(0x1000008, 0, false, false);
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        button.setLayoutData((Object)data);
        button.setText("&Install");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PackageInstallInstallPage.this.displayText.setText("");
                PackageInstallInstallPage.this.installComplete = false;
                try {
                    PackageInstallInstallPage.this.getContainer().run(true, true, (IRunnableWithProgress)new InstallJob());
                    PackageInstallInstallPage.this.installComplete = true;
                    PackageInstallInstallPage.this.needToReboot = PackageInstallInstallPage.this.displayText.getText().contains("needs to be rebooted");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PackageInstallInstallPage.this.getContainer().updateButtons();
            }
        });
    }

    public boolean rebootNeeded() {
        return this.installComplete && this.needToReboot;
    }

    private class InstallJob
    implements IRunnableWithProgress {
        private IHost host;
        private PackageInstallWizard wizard;
        private int type;
        private String vib;

        public InstallJob() {
            this.wizard = (PackageInstallWizard)PackageInstallInstallPage.this.getWizard();
            this.host = this.wizard.getHost();
            this.type = this.wizard.getInstallType();
            this.vib = this.wizard.getPackageFile();
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            block27: {
                BufferedReader reader = null;
                try {
                    try {
                        String line;
                        monitor.beginTask("", -1);
                        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
                        if (!fss.isConnected()) {
                            fss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                        }
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        StringBuffer command = new StringBuffer("esxcli software ");
                        if (this.type == 1) {
                            try {
                                new URL(this.vib);
                            }
                            catch (MalformedURLException malformedURLException) {
                                String remoteFile = this.upload(this.vib, monitor);
                                this.vib = "file://" + remoteFile;
                            }
                            command.append("vib install --viburl ");
                            command.append(this.vib);
                        } else if (this.type == 2 || this.type == 3) {
                            if (this.type == 2) {
                                command.append("vib");
                            } else {
                                command.append("profile");
                            }
                            command.append(" install --depot ");
                            command.append(this.wizard.getDepot());
                            if (this.type == 2) {
                                command.append(" --vibname ");
                            } else {
                                command.append(" --profile ");
                            }
                            command.append(this.wizard.getDepotSelection());
                        }
                        command.append(" ");
                        command.append(this.wizard.getOptionString());
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        RemoteProcess proc = new RemoteProcess(this.host, command.toString());
                        SequenceInputStream is = new SequenceInputStream(proc.getInputStream(), proc.getErrorStream());
                        reader = new BufferedReader(new InputStreamReader(is));
                        proc.run();
                        while ((line = reader.readLine()) != null) {
                            final String aLine = String.valueOf(line) + "\n";
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    PackageInstallInstallPage.this.displayText.append(aLine);
                                }
                            });
                            if (!monitor.isCanceled()) continue;
                            throw new OperationCanceledException();
                        }
                    }
                    catch (Exception e) {
                        final String error = RSEHelper.getErrorMessage(e);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PackageInstallInstallPage.this.setErrorMessage(error);
                            }
                        });
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {}
                        monitor.done();
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    monitor.done();
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                monitor.done();
            }
        }

        private String upload(String srcFile, IProgressMonitor monitor) throws Exception {
            IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
            String fileName = srcFile.substring(srcFile.lastIndexOf(File.separatorChar));
            IRemoteFile dstFile = fss.getRemoteFileObject("/tmp" + fileName, monitor);
            fss.upload(srcFile, dstFile, null, monitor);
            return dstFile.getCanonicalPath();
        }
    }
}

