/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.VIDERSEPlugin;
import com.vmware.vide.rse.ui.wizard.PackageInstallOptionPage;
import com.vmware.vide.utils.ui.ActionableEditField;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PackageInstallVIBPage
extends WizardPage {
    private VibLocationField field;

    protected PackageInstallVIBPage(String pageName) {
        super(pageName);
        this.setTitle("VIB Location");
        this.setDescription("Select a VIB package to install");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText("Specify local file or URL(http, https, ftp) for VIB (*.vib) package to install:");
        this.createComboField(composite);
        this.createButtons(composite);
        this.setControl((Control)composite);
    }

    private void createComboField(Composite composite) {
        this.field = new VibLocationField(composite, "vib_location");
        this.field.init(null, true, null, VIDERSEPlugin.getDefault().getPreferenceStore());
        this.field.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageInstallVIBPage.this.field.showErrorMarker();
                PackageInstallVIBPage.this.getContainer().updateButtons();
            }
        });
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.initializeDialogUnits((Control)composite);
        Button button = new Button(composite, 8);
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        button.setLayoutData((Object)data);
        button.setText("B&rowse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PackageInstallVIBPage.this.getShell());
                dialog.setText("Select a VIB package");
                dialog.setFilterExtensions(new String[]{"*.vib"});
                String file = dialog.open();
                if (file != null && !file.isEmpty()) {
                    PackageInstallVIBPage.this.field.setText(file);
                    PackageInstallVIBPage.this.field.showErrorMarker();
                    PackageInstallVIBPage.this.getContainer().updateButtons();
                }
            }
        });
        button = new Button(composite, 8);
        button.setLayoutData((Object)data);
        button.setText("&Projects...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] results;
                IFile file;
                String filePath;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PackageInstallVIBPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialog.setTitle("Select a VIB package");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection != null && selection.length > 0 && selection[0] instanceof IFile) {
                            return Status.OK_STATUS;
                        }
                        return new Status(4, "com.vmware.vide.rse", "Choose a file to install");
                    }
                });
                if (dialog.open() == 0 && (filePath = (file = (IFile)(results = dialog.getResult())[0]).getLocation().toOSString()) != null && !filePath.isEmpty()) {
                    PackageInstallVIBPage.this.field.setText(filePath);
                    PackageInstallVIBPage.this.field.showErrorMarker();
                    PackageInstallVIBPage.this.getContainer().updateButtons();
                }
            }
        });
    }

    public boolean canFlipToNextPage() {
        String name = this.field.getText();
        if (!name.isEmpty()) {
            try {
                URL url = new URL(name);
                String file = url.getFile();
                return file.toLowerCase().endsWith("vib");
            }
            catch (MalformedURLException malformedURLException) {
                File file = new File(name);
                return file.exists() && file.getName().toLowerCase().endsWith("vib");
            }
        }
        return false;
    }

    public IWizardPage getNextPage() {
        IWizardPage page = super.getNextPage();
        if (page instanceof PackageInstallOptionPage) {
            ((PackageInstallOptionPage)page).updateOptions();
        }
        this.field.updateHistory();
        return page;
    }

    public String getPackageFile() {
        return this.field.getText().trim();
    }

    private class VibLocationField
    extends ActionableEditField {
        public VibLocationField(Composite parent, String id) {
            super(parent, id);
        }

        public void init(IAction comboAction, boolean editable, IAction[] usrActions, IPreferenceStore store) {
            super.init(comboAction, editable, usrActions, store);
            Composite parent = this.getCombo().getParent();
            Layout layout = parent.getLayout();
            if (layout instanceof GridLayout) {
                ((GridLayout)layout).marginWidth = 0;
                ((GridLayout)layout).horizontalSpacing = 0;
                ((GridLayout)layout).marginHeight = 0;
                ((GridLayout)layout).marginBottom = 0;
                parent.setLayout(layout);
            }
            parent.setLayoutData((Object)new GridData(4, 0, true, false));
            Object object = this.getCombo().getLayoutData();
            if (object instanceof GridData) {
                GridData data = (GridData)object;
                data.grabExcessHorizontalSpace = true;
                data.horizontalAlignment = 4;
                data.horizontalSpan = 2;
                data.widthHint = -1;
                PackageInstallVIBPage.this.field.getCombo().setLayoutData((Object)data);
            }
        }

        public boolean isValid() {
            String name = this.comboBox.getText().trim();
            if (!name.isEmpty()) {
                PackageInstallVIBPage.this.getContainer().updateButtons();
                if (name.endsWith(".vib")) {
                    return true;
                }
            }
            return false;
        }

        public void updateHistory() {
            String item = this.comboBox.getText().trim();
            if (!item.isEmpty()) {
                super.updateHistory();
                this.comboBox.setText(item);
            }
        }
    }
}

