/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.ui.dialogs.PackageManagerDialog;
import com.vmware.vide.rse.ui.wizard.PackageRemoveMainPage;
import com.vmware.vide.rse.ui.wizard.PackageRemoveUninstallPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.core.model.IHost;

public class PackageRemoveWizard
extends Wizard {
    private final List<PackageManagerDialog.VibPackage> vibPackages;
    private IHost host;
    private PackageRemoveMainPage mainPage;
    private PackageRemoveUninstallPage uninstallPage;

    public PackageRemoveWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Uninstall Wizard");
        this.vibPackages = new ArrayList<PackageManagerDialog.VibPackage>();
    }

    public void init(IHost host, IStructuredSelection selection) {
        this.host = host;
        if (selection != null && !selection.isEmpty()) {
            for (Object object : selection) {
                if (!(object instanceof PackageManagerDialog.VibPackage)) continue;
                PackageManagerDialog.VibPackage pkg = (PackageManagerDialog.VibPackage)object;
                this.vibPackages.add(pkg);
            }
        }
    }

    public void addPages() {
        this.mainPage = new PackageRemoveMainPage("Option Page");
        this.addPage((IWizardPage)this.mainPage);
        this.uninstallPage = new PackageRemoveUninstallPage("Uninstall Page");
        this.addPage((IWizardPage)this.uninstallPage);
    }

    public boolean performFinish() {
        return true;
    }

    public String[] getPackageNames() {
        String[] names = new String[this.vibPackages.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = this.vibPackages.get(i).toString();
            ++i;
        }
        return names;
    }

    public List<PackageManagerDialog.VibPackage> getPackages() {
        return this.vibPackages;
    }

    public String getOptions() {
        return this.mainPage.getOptions();
    }

    public IHost getHost() {
        return this.host;
    }

    public boolean rebootNeeded() {
        return this.uninstallPage.rebootNeeded();
    }
}

