/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.rse.services.clientserver.PathUtility;

public class SshScpHelper {
    public static byte[] readRemoteFile(Session session, String srcFile, long size, IProgressMonitor monitor) throws Exception {
        if (size > Integer.MAX_VALUE) {
            throw new Exception("The size is too big to process");
        }
        Channel channel = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            String command = "scp -f " + PathUtility.enQuoteUnix((String)srcFile);
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            SshScpHelper.sendAck(out);
            if (SshScpHelper.checkAck(in) != 67) {
                throw new IOException("ReadRemoteFile() : Asking sink mode from remote failed.");
            }
            in.skip(5L);
            long filesize = 0L;
            while (true) {
                int b;
                if ((b = in.read()) < 0) {
                    throw new IOException("ReadRemoteFile() : Error during reading file size");
                }
                if (b == 32) break;
                filesize = filesize * 10L + (long)(b - 48);
            }
            byte[] filename = new byte[128];
            int i = 0;
            while (true) {
                in.read(filename, i, 1);
                if (filename[i] == 10) break;
                ++i;
            }
            SshScpHelper.sendAck(out);
            if (monitor != null) {
                monitor.beginTask("Reading file : " + srcFile, (int)filesize);
            }
            byte[] buffer = new byte[(int)(filesize > size ? size : filesize)];
            int offset = 0;
            while (offset < buffer.length) {
                int readSize = in.read(buffer, offset, buffer.length - offset);
                if (readSize < 0) {
                    throw new IOException("readRemoteFile() : Error during read remote file");
                }
                offset += readSize;
                if (monitor == null) continue;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.worked(readSize);
            }
            if (filesize <= size) {
                if (SshScpHelper.checkAck(in) != 0) {
                    System.out.println("readRemoteFile : Failed after downloading " + srcFile);
                }
                SshScpHelper.sendAck(out);
            }
            byte[] byArray = buffer;
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            System.out.print(String.valueOf(sb.toString()) + " : " + b);
        }
        return b;
    }

    private static void sendAck(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }
}

