/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.util;

import com.vmware.vide.rse.util.RSSContentProvider;
import com.vmware.vide.rse.util.RSSNewsItem;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IIntroXHTMLContentProvider;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class vIDERSSViewer
implements IIntroXHTMLContentProvider,
Observer {
    private static final String INTRO_SHOW_IN_BROWSER = "http://org.eclipse.ui.intro/runAction?pluginId=com.vmware.vide.ui.welcome&class=com.vmware.vide.ui.welcome.WelcomeAction&cmd=openWeb&url=";
    private static final String HREF_BULLET = "bullet";
    private IIntroContentProviderSite site;
    private boolean disposed;
    private String id;
    private FormToolkit toolkit;
    private Composite parent;
    private Image bulletImage;
    private List<RSSNewsItem> items;
    private FormText formText;
    private RSSContentProvider rssProvider;

    public void createContent(String id, PrintWriter out) {
        try {
            this.rssProvider.createContent(INTRO_SHOW_IN_BROWSER, out);
        }
        catch (IOException e) {
            out.append(String.valueOf(e.getMessage()) + e.getStackTrace());
        }
    }

    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        if (this.disposed) {
            return;
        }
        if (this.formText == null) {
            this.formText = toolkit.createFormText(parent, true);
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    vIDERSSViewer.this.doNavigate((String)e.getHref());
                }
            });
            this.bulletImage = this.createImage((IPath)new Path("images/topiclabel/arrow.gif"));
            if (this.bulletImage != null) {
                this.formText.setImage(HREF_BULLET, this.bulletImage);
            }
            this.parent = parent;
            this.toolkit = toolkit;
            this.id = id;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<form>");
        if (this.items == null) {
            buffer.append("<p>");
            buffer.append(Messages.RSS_Loading);
            buffer.append("</p>");
        } else if (this.items.size() > 0) {
            int i = 0;
            while (i < this.items.size()) {
                RSSNewsItem item = this.items.get(i);
                buffer.append("<li style=\"image\" value=\"");
                buffer.append(HREF_BULLET);
                buffer.append("\">");
                buffer.append("<a href=\"");
                buffer.append(item.url);
                buffer.append("\">");
                buffer.append(item.label);
                buffer.append("</a>");
                buffer.append("</li>");
                ++i;
            }
        } else {
            buffer.append("<p>");
            buffer.append(Messages.RSS_No_news);
            buffer.append("</p>");
        }
        buffer.append("</form>");
        this.formText.setText(buffer.toString(), true, false);
    }

    public void createContent(String id, Element parent) {
        this.rssProvider.createContent(id, INTRO_SHOW_IN_BROWSER, parent);
    }

    public void init(IIntroContentProviderSite site) {
        this.site = site;
        this.rssProvider = new RSSContentProvider();
        this.rssProvider.init(this);
    }

    private Image createImage(IPath path) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        try {
            url = FileLocator.toFileURL((URL)url);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            return desc.createImage();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void doNavigate(final String url) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IIntroURL introUrl = IntroURLFactory.createIntroURL((String)url);
                if (introUrl != null) {
                    introUrl.execute();
                    return;
                }
                vIDERSSViewer.this.openBrowser(url);
            }
        });
    }

    private void openBrowser(String href) {
        try {
            URL url = new URL(href);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void reflow(Control initiator) {
        Control c = initiator;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        c = initiator;
        while (c != null) {
            if (c instanceof Composite) {
                ((Composite)c).layout(true);
            }
            if (!((c = c.getParent()) instanceof ScrolledForm)) continue;
            ((ScrolledForm)c).reflow(true);
            break;
        }
        c = initiator;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    public void dispose() {
        if (this.bulletImage != null) {
            this.bulletImage.dispose();
            this.bulletImage = null;
        }
        this.disposed = true;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (this.disposed) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                vIDERSSViewer.this.items = vIDERSSViewer.this.rssProvider.getRSSItems();
                if (vIDERSSViewer.this.parent != null) {
                    vIDERSSViewer.this.createContent(vIDERSSViewer.this.id, vIDERSSViewer.this.parent, vIDERSSViewer.this.toolkit);
                    vIDERSSViewer.this.reflow((Control)vIDERSSViewer.this.formText);
                }
                vIDERSSViewer.this.site.reflow((IIntroContentProvider)vIDERSSViewer.this, true);
            }
        });
    }
}

