/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.export;

import java.io.IOException;
import java.io.Writer;

public class JsonMiniWriter {
    Writer writer;
    String indent = "    ";
    String EOL = "\n";
    String space = " ";
    int level = 0;
    State prevState = State.START;

    JsonMiniWriter(Writer writer) {
        this.writer = writer;
    }

    void flush() throws IOException {
        this.writer.flush();
    }

    private void printIndent() throws IOException {
        if (this.prevState == State.NAME) {
            return;
        }
        int i = 0;
        while (i < this.level) {
            this.writer.append(this.indent);
            ++i;
        }
    }

    void setIndent(String indent) {
        this.indent = indent;
    }

    private void printEOL() throws IOException {
        if (this.prevState == State.END_OBJECT || this.prevState == State.END_ARRAY || this.prevState == State.VALUE) {
            this.writer.append(',');
        }
        if (this.prevState != State.START && this.prevState != State.NAME) {
            this.writer.append(this.EOL);
        }
    }

    void setEOL(String eol) {
        this.EOL = eol;
    }

    void beginObject() throws IOException {
        this.printEOL();
        this.printIndent();
        this.writer.append('{');
        ++this.level;
        this.prevState = State.BEGIN_OBJECT;
    }

    void endObject() throws IOException {
        this.printEOL();
        --this.level;
        this.printIndent();
        this.writer.append('}');
        this.prevState = State.END_OBJECT;
    }

    void beginArray() throws IOException {
        this.printEOL();
        this.printIndent();
        this.writer.append('[');
        ++this.level;
        this.prevState = State.BEGIN_ARRAY;
    }

    void endArray() throws IOException {
        this.printEOL();
        --this.level;
        this.printIndent();
        this.writer.append(']');
        this.prevState = State.END_ARRAY;
    }

    void name(String name) throws IOException {
        this.printEOL();
        this.printIndent();
        this.writer.append('\"');
        this.writer.append(this.escape(name));
        this.writer.append("\":");
        this.writer.append(this.space);
        this.prevState = State.NAME;
    }

    void value(String value) throws IOException {
        this.printEOL();
        this.printIndent();
        this.writer.append('\"');
        this.writer.append(this.escape(value));
        this.writer.append('\"');
        this.prevState = State.VALUE;
    }

    String escape(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\"') {
                sb.append("\\\"");
            } else if (c == '\\') {
                sb.append("\\\\");
            } else if (c == '/') {
                sb.append("\\/");
            } else if (c == '\b') {
                sb.append("\\b");
            } else if (c == '\f') {
                sb.append("\\f");
            } else if (c == '\n') {
                sb.append("\\n");
            } else if (c == '\r') {
                sb.append("\\r");
            } else if (c == '\t') {
                sb.append("\\t");
            } else if (c <= '\u000f') {
                sb.append("\\u000");
                sb.append(Integer.toHexString(c));
            } else if (c <= '\u001f' || '\u007f' <= c && c <= '\u009f') {
                sb.append("\\u00");
                sb.append(Integer.toHexString(c));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    static enum State {
        START,
        NAME,
        VALUE,
        BEGIN_OBJECT,
        END_OBJECT,
        BEGIN_ARRAY,
        END_ARRAY;

    }
}

