/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.export;

import com.vmware.vide.vlogbrowser.core.export.ILogEntryAccessor;
import com.vmware.vide.vlogbrowser.core.export.ILogExport;
import com.vmware.vide.vlogbrowser.core.export.LogExportException;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogExportTxt
implements ILogExport {
    private static final Logger logger = LoggerFactory.getLogger(LogExportTxt.class);
    private Writer writer = null;
    private IProgressMonitor monitor = null;
    private boolean emitExtraLines = false;
    private boolean includeColumnHeader = true;
    private boolean needToOutputHeader = true;

    public void setIncludeColumnHeader(boolean includeColumnHeader) {
        this.includeColumnHeader = includeColumnHeader;
    }

    @Override
    public void start(OutputStream outputStream, IProgressMonitor monitor, boolean emitExtraLines) throws LogExportException {
        try {
            this.needToOutputHeader = true;
            this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this.monitor = monitor;
            this.emitExtraLines = emitExtraLines;
        }
        catch (Exception e) {
            String errorMessage = "Error while exporting log file to TXT format: " + e.getMessage();
            logger.error(errorMessage, (Throwable)e);
            throw new LogExportException(errorMessage, e);
        }
    }

    @Override
    public void end() throws LogExportException {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (Exception e) {
            String errorMessage = "Error while exporting log file to TXT format: " + e.getMessage();
            logger.error(errorMessage, (Throwable)e);
            throw new LogExportException(errorMessage, e);
        }
    }

    @Override
    public void export(ILogEntryAccessor logAccess) throws LogExportException {
        String[] columns = logAccess.getColumns();
        int entryCount = logAccess.getEntryCount();
        String delimiter = this.getDelimiter();
        try {
            StringBuilder line;
            this.monitor.beginTask("Exporting log entries to txt", entryCount);
            if (this.includeColumnHeader && this.needToOutputHeader) {
                String[] columnsToPrint;
                if (this.emitExtraLines) {
                    columnsToPrint = Arrays.copyOf(columns, columns.length + 1);
                    columnsToPrint[columns.length] = "ExtraLines";
                } else {
                    columnsToPrint = columns;
                }
                line = new StringBuilder(128);
                int i = 0;
                while (i < columnsToPrint.length) {
                    String field = columnsToPrint[i];
                    this.insertFieldIntoLine(line, field);
                    if (i != columnsToPrint.length - 1) {
                        line.append(delimiter);
                    } else {
                        line.append("\n");
                    }
                    ++i;
                }
                this.writer.write(line.toString());
                this.needToOutputHeader = false;
            }
            int entry = 0;
            while (entry < entryCount) {
                if (this.monitor.isCanceled()) {
                    this.monitor.done();
                    throw new LogExportException("Export operation cancelled");
                }
                this.monitor.worked(1);
                line = new StringBuilder(128);
                String[] values = logAccess.getEntryValues(entry);
                int i = 0;
                while (i < columns.length) {
                    String field = values[i];
                    this.insertFieldIntoLine(line, field);
                    if (!this.emitExtraLines) {
                        if (i != columns.length - 1) {
                            line.append(delimiter);
                        } else {
                            line.append("\n");
                        }
                    } else {
                        line.append(delimiter);
                    }
                    ++i;
                }
                if (this.emitExtraLines) {
                    String extraLines = logAccess.getExtraLines(entry);
                    this.insertFieldIntoLine(line, extraLines);
                    line.append("\n");
                }
                this.writer.write(line.toString());
                ++entry;
            }
        }
        catch (Exception e) {
            String errorMessage = "Error while exporting log file to TXT format: " + e.getMessage();
            logger.error(errorMessage, (Throwable)e);
            throw new LogExportException(errorMessage, e);
        }
    }

    protected void insertFieldIntoLine(StringBuilder line, String field) {
        line.append(field);
    }

    protected String getDelimiter() {
        return " | ";
    }
}

