/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.fileops;

import com.vmware.vide.vlogbrowser.core.model.LocationAndFilePattern;
import com.vmware.vide.vlogbrowser.core.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BundleInfoManager {
    public static final String BUNDLE_PATTERNS_FILE = "bundle-patterns.xml";
    private static final Logger logger = LoggerFactory.getLogger(BundleInfoManager.class);
    private Set<LocationAndFilePattern> lfpSet = null;
    private List<BundleInfo> bundleInfoList = new ArrayList<BundleInfo>();
    private static final BundleInfoManager INSTANCE = new BundleInfoManager();

    static {
        try {
            File logBundleTemplateXmlFile = Utils.getTemplateFile(INSTANCE.getClass(), BUNDLE_PATTERNS_FILE);
            if (logBundleTemplateXmlFile != null) {
                INSTANCE.load(new FileInputStream(logBundleTemplateXmlFile));
            } else {
                logger.error("Unable to locate {}", (Object)BUNDLE_PATTERNS_FILE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error trying to load bundle manager xml", (Throwable)e);
        }
    }

    public static BundleInfoManager getInstance() {
        return INSTANCE;
    }

    public Set<LocationAndFilePattern> getAllBundleLocations() {
        return this.lfpSet;
    }

    public List<BundleInfo> getBundleInfoList() {
        return this.bundleInfoList;
    }

    public void load(InputStream inputXmlStream) throws Exception {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dbf.setIgnoringComments(true);
            doc = db.parse(inputXmlStream);
            NodeList bundleNodes = doc.getElementsByTagName("bundle");
            int i = 0;
            while (i < bundleNodes.getLength()) {
                String system = null;
                String version = null;
                String fileExtensions = null;
                Node bundleNode = bundleNodes.item(i);
                if (bundleNode.getNodeType() == 1) {
                    Node n = bundleNode.getAttributes().getNamedItem("system");
                    if (n != null) {
                        system = n.getNodeValue();
                    }
                    if ((n = bundleNode.getAttributes().getNamedItem("version")) != null) {
                        version = n.getNodeValue();
                    }
                    if ((n = bundleNode.getAttributes().getNamedItem("extensions")) != null) {
                        fileExtensions = n.getNodeValue();
                    }
                    BundleInfo bundleInfo = new BundleInfo(system, version, fileExtensions);
                    NodeList bundleChildren = bundleNode.getChildNodes();
                    int c = 0;
                    while (c < bundleChildren.getLength()) {
                        Node bundleChild = bundleChildren.item(c);
                        if (bundleChild.getNodeType() == 1) {
                            String fileRegex;
                            String parentDir;
                            String nodeName = bundleChild.getNodeName();
                            boolean hasFile = "hasFile".equals(nodeName);
                            boolean notFile = "notFile".equals(nodeName);
                            if (hasFile || notFile) {
                                parentDir = bundleChild.getAttributes().getNamedItem("parentDir").getNodeValue();
                                fileRegex = bundleChild.getAttributes().getNamedItem("fileRegex").getNodeValue();
                                if (hasFile) {
                                    bundleInfo.addHasFile(parentDir, fileRegex);
                                } else if (notFile) {
                                    bundleInfo.addHasNotFile(parentDir, fileRegex);
                                }
                            } else if ("hostFilePathRegex".equals(nodeName)) {
                                parentDir = bundleChild.getAttributes().getNamedItem("parentDir").getNodeValue();
                                fileRegex = bundleChild.getAttributes().getNamedItem("fileRegex").getNodeValue();
                                int group = Integer.parseInt(bundleChild.getAttributes().getNamedItem("group").getNodeValue());
                                String valueRegex = bundleChild.getAttributes().getNamedItem("valueRegex").getNodeValue();
                                bundleInfo.setHostFilePathRegex(parentDir, fileRegex, group, valueRegex);
                            } else {
                                logger.warn("While parsing bundle-template XML, unknown element '{}'", (Object)nodeName);
                            }
                        }
                        ++c;
                    }
                    this.bundleInfoList.add(bundleInfo);
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error("While parsing bundle-template XML", (Throwable)e);
            throw e;
        }
        this.refreshLfpSet();
    }

    private void refreshLfpSet() {
        HashSet<LocationAndFilePattern> lfpSet = new HashSet<LocationAndFilePattern>();
        List<BundleInfo> bundleInfos = this.getBundleInfoList();
        for (BundleInfo bi : bundleInfos) {
            lfpSet.addAll(bi.getHasFileList());
            lfpSet.addAll(bi.getNotFileList());
            LocationAndFilePattern lfp = bi.getHostFilePathFile();
            if (lfp == null) continue;
            lfpSet.add(lfp);
        }
        this.lfpSet = lfpSet;
    }

    private BundleInfoManager() {
    }

    public static class BundleInfo {
        private static Map<String, LocationAndFilePattern> pathRegexToLocationAndFilePatternMap = new HashMap<String, LocationAndFilePattern>();
        private String systemType = null;
        private String version = null;
        private String[] fileExtensions = null;
        private List<LocationAndFilePattern> hasFileList = new ArrayList<LocationAndFilePattern>();
        private List<LocationAndFilePattern> notFileList = new ArrayList<LocationAndFilePattern>();
        private LocationAndFilePattern hostFilePathFile = null;
        private String hostFilePathValueRegex = null;
        private int hostFilePathRegexGroup = -1;

        public BundleInfo(String systemType, String version, String fileExtensions) {
            this.systemType = systemType;
            this.version = version;
            if (fileExtensions != null) {
                this.fileExtensions = fileExtensions.split("[,|;:]");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LocationAndFilePattern getLfp(String parentDir, String regex, boolean createIfNotExisting) {
            LocationAndFilePattern lfp = null;
            String key = String.valueOf(parentDir) + regex;
            Map<String, LocationAndFilePattern> map = pathRegexToLocationAndFilePatternMap;
            synchronized (map) {
                lfp = pathRegexToLocationAndFilePatternMap.get(key);
                if (createIfNotExisting && lfp == null) {
                    lfp = new LocationAndFilePattern(parentDir, regex);
                    pathRegexToLocationAndFilePatternMap.put(key, lfp);
                }
            }
            return lfp;
        }

        public void addHasFile(String parentDir, String regex) {
            this.hasFileList.add(BundleInfo.getLfp(parentDir, regex, true));
        }

        public void addHasNotFile(String parentDir, String regex) {
            this.notFileList.add(BundleInfo.getLfp(parentDir, regex, true));
        }

        public List<LocationAndFilePattern> getHasFileList() {
            return this.hasFileList;
        }

        public List<LocationAndFilePattern> getNotFileList() {
            return this.notFileList;
        }

        public void setHostFilePathRegex(String parentDir, String fileRegex, int group, String valueRegex) {
            this.hostFilePathFile = BundleInfo.getLfp(parentDir, fileRegex, true);
            this.hostFilePathRegexGroup = group;
            this.hostFilePathValueRegex = valueRegex;
        }

        public LocationAndFilePattern getHostFilePathFile() {
            return this.hostFilePathFile;
        }

        public String getHostFilePathValueRegex() {
            return this.hostFilePathValueRegex;
        }

        public int getHostFilePathRegexGroup() {
            return this.hostFilePathRegexGroup;
        }

        public String getSystemType() {
            return this.systemType;
        }

        public String getVersion() {
            return this.version;
        }

        public String[] getFileExtensions() {
            return this.fileExtensions;
        }
    }
}

