/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model;

import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.model.LogItemSerializator;
import com.vmware.vide.vlogbrowser.core.model.util.ISerializator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class LogItemBufferedFile
extends RandomAccessFile {
    private long writeBase = 0L;
    private long readBase = -1L;
    private int lastIndex = -1;
    private static final int NUM_ELEMENTS = 100;
    private ISerializator<LogItem> serializator = new LogItemSerializator(null);
    private ByteBuffer buffer = ByteBuffer.allocate(this.serializator.getElementLength() * 100);

    public LogItemBufferedFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int base;
        if (this.isWriteMode() && this.buffer.position() != 0) {
            this.flushBuffer();
        }
        if (this.readBase != (long)(base = this.lastIndex / 100 * 100)) {
            super.seek(this.getOffset(base));
            super.read(this.buffer.array());
            this.readBase = base;
        }
        int pos = this.lastIndex % 100;
        this.buffer.position((int)this.getOffset(pos));
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.lastIndex = (int)(pos / (long)this.serializator.getElementLength());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.isWriteMode()) {
            this.buffer.clear();
            this.readBase = -1L;
        }
        if (!this.buffer.hasRemaining()) {
            this.flushBuffer();
        }
        int pos = this.lastIndex % 100;
        this.buffer.position((int)this.getOffset(pos));
        this.buffer.put(b, off, len);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        super.setLength(newLength);
        if (newLength == 0L) {
            this.buffer.clear();
            this.readBase = -1L;
            this.writeBase = 0L;
        }
    }

    private long getOffset(int index) {
        return index * this.serializator.getElementLength();
    }

    private boolean isWriteMode() {
        return this.readBase == -1L;
    }

    private void flushBuffer() throws IOException {
        super.seek(this.writeBase);
        super.write(this.buffer.array(), 0, this.buffer.position());
        this.writeBase += (long)this.buffer.position();
        this.buffer.clear();
    }
}

