/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model;

import com.vmware.vide.vlogbrowser.core.model.LogDate;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.model.util.ISerializator;
import com.vmware.vide.vlogbrowser.core.parser.LogDateFormat;
import java.nio.ByteBuffer;
import java.util.Date;

public class LogItemSerializator
implements ISerializator<LogItem> {
    private static final int LOG_ITEM_BYTES = 42;
    private ByteBuffer buffer = ByteBuffer.allocate(42);
    private LogDateFormat ldFormat;

    public LogItemSerializator(LogDateFormat format) {
        this.ldFormat = format;
    }

    @Override
    public byte[] serialize(LogItem logItem) {
        this.buffer.clear();
        this.buffer.put(this.booleanToByte(logItem.isAlwaysMatched()));
        this.buffer.put(this.booleanToByte(logItem.isProperlyFormed()));
        this.buffer.putInt(logItem.getGroupId());
        this.buffer.putLong(logItem.getFileOffset());
        this.buffer.putInt(logItem.getReadLength());
        this.buffer.putLong(logItem.getDate().getTime());
        this.buffer.putInt(logItem.getLogFileNum());
        this.buffer.putLong(logItem.getLogIndexNum());
        int numRollovers = 0;
        Date d = logItem.getLogDate();
        if (d instanceof LogDate) {
            LogDate ld = (LogDate)d;
            numRollovers = ld.getNumRollovers();
        }
        this.buffer.putInt(numRollovers);
        return this.buffer.array();
    }

    @Override
    public LogItem deserialize(byte[] arr) {
        ByteBuffer buffer = ByteBuffer.wrap(arr);
        boolean alwaysMatched = this.byteToBoolean(buffer.get());
        boolean properlyFormed = this.byteToBoolean(buffer.get());
        int groupId = buffer.getInt();
        long fileOffset = buffer.getLong();
        int readLength = buffer.getInt();
        long time = buffer.getLong();
        int logFileNum = buffer.getInt();
        long logIndexNum = buffer.getLong();
        int numRollover = buffer.getInt();
        LogItem logItem = new LogItem(properlyFormed, fileOffset, readLength, new LogDate(time, this.ldFormat, numRollover), logIndexNum, logFileNum);
        logItem.setAlwaysMatched(alwaysMatched);
        logItem.setGroupId(groupId);
        return logItem;
    }

    private byte booleanToByte(boolean value) {
        if (value) {
            return 1;
        }
        return 0;
    }

    private boolean byteToBoolean(byte value) {
        return value != 0;
    }

    @Override
    public int getElementLength() {
        return 42;
    }
}

