/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model.util;

import com.vmware.vide.vlogbrowser.core.model.util.ISerializable;
import com.vmware.vide.vlogbrowser.core.model.util.PersistentList;
import java.io.RandomAccessFile;

class SerializablePersistentList<T extends ISerializable<?>>
extends PersistentList<T> {
    private Class<T> classT;
    private int elementLenght = -1;

    SerializablePersistentList(RandomAccessFile file, Class<T> classT) {
        super(file);
        this.classT = classT;
    }

    @Override
    protected byte[] getBytes(T element) {
        return element.toByteArray();
    }

    @Override
    protected T getElement(byte[] arr) {
        ISerializable element = null;
        try {
            element = (ISerializable)this.classT.newInstance();
            if (arr != null && arr.length > 0) {
                element.setContent(arr);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return (T)element;
    }

    @Override
    protected int getElementLength() {
        Object element;
        if (this.elementLenght == -1 && (element = this.getElement(null)) != null) {
            this.elementLenght = element.lenght();
        }
        return this.elementLenght;
    }
}

