/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.utils.local.ArchiveUtils;
import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import com.vmware.vide.vlogbrowser.core.fileops.LogFileUtils;
import com.vmware.vide.vlogbrowser.core.model.FilterItem;
import com.vmware.vide.vlogbrowser.core.model.LogFilter;
import com.vmware.vide.vlogbrowser.core.model.LogSystemType;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import com.vmware.vide.vlogbrowser.core.parser.LogFormatException;
import com.vmware.vide.vlogbrowser.core.parser.XmlDocUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigParser {
    private File configFile;
    private DocumentBuilderFactory docBldrFactory;
    private DocumentBuilder docBldr;
    private Document configDoc;
    private LogSystemType fSystemType;

    public static String[] splitSourceID(String srcID) {
        if (srcID == null) {
            return null;
        }
        String[] srcIDparts = srcID.split(";");
        if (srcIDparts.length == 3) {
            return srcIDparts;
        }
        String[] returnValue = new String[3];
        returnValue[0] = srcIDparts[0];
        String archiveFilePath = null;
        if (srcIDparts.length > 2) {
            archiveFilePath = srcIDparts[srcIDparts.length - 2];
        }
        String parentDir = srcIDparts[srcIDparts.length - 1];
        if (srcID.endsWith(";") && ArchiveUtils.isSupportedArchiveFilename((String)parentDir)) {
            archiveFilePath = parentDir;
            parentDir = "";
        }
        returnValue[1] = archiveFilePath;
        returnValue[2] = parentDir;
        return returnValue;
    }

    public ConfigParser(InputStream inputStream) throws Exception {
        this(null, inputStream, true);
    }

    public ConfigParser(InputStream inputStream, boolean requireID) throws Exception {
        this(null, inputStream, requireID);
    }

    public ConfigParser(File configFile, InputStream inputStream) throws Exception {
        this(configFile, inputStream, true);
    }

    public ConfigParser(File configFile, InputStream inputStream, boolean requireID) throws Exception {
        this.configFile = configFile;
        this.docBldrFactory = DocumentBuilderFactory.newInstance();
        try {
            this.docBldr = this.docBldrFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            LogBrowserPlugin.log(e);
        }
        try {
            this.configDoc = this.docBldr.parse(inputStream);
        }
        catch (SAXException e) {
            if (e instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)e;
                int line = spe.getLineNumber();
                int column = spe.getColumnNumber();
                throw new LogFormatException("LogFormat configuration could not be parsed. The configuration must be properly formatted XML.", line, column, e);
            }
            throw new LogFormatException("LogFormat configuration could not be parsed. The configuration must be properly formatted XML.", e);
        }
        catch (IOException e) {
            throw new LogFormatException("LogFormat configuration could not be read.", e);
        }
        catch (IllegalArgumentException e) {
            throw new LogFormatException("LogFormat configuration must not be null", e);
        }
        if (requireID) {
            try {
                this.getUniqueID();
            }
            catch (Exception exception) {
                this.updateUniqueID();
            }
        }
    }

    public LogFormat getLogFormat() throws LogFormatException {
        LogFormat logFormat = null;
        XPath xpath = XPathFactory.newInstance().newXPath();
        int numLogFormats = 0;
        try {
            numLogFormats = Integer.parseInt(xpath.evaluate("count(/root/LogFormat)", this.configDoc));
            if (numLogFormats == 0) {
                throw new LogFormatException("No LogFormat nodes found in XML tree.");
            }
        }
        catch (Exception e) {
            throw new LogFormatException("Could not parse XML LogFormat configuration file  successfully to determine number of LogFormat nodes." + e.getMessage());
        }
        try {
            String logFormatName = xpath.evaluate("/root/LogFormat[1]/Name/text()", this.configDoc);
            logFormat = new LogFormat(logFormatName);
            int formatIndex = 1;
            int numFields = this.getFields(xpath, formatIndex, logFormatName, logFormat);
            if (numFields == 0) {
                throw new LogFormatException("There should be at least one Field defined in " + logFormatName);
            }
            int numColumns = this.getColumns(xpath, formatIndex, logFormatName, logFormat);
            if (numColumns == 0) {
                throw new LogFormatException("There should be at least one Column defined in " + logFormatName);
            }
            int numFilenames = this.getKnownSystypes(xpath, formatIndex, logFormatName, logFormat);
            if (numFilenames == 0) {
                throw new LogFormatException("There should be at least one KnownFilename defined in " + logFormatName);
            }
            logFormat.setDateDelta(this.getDateDelta());
            this.setSizeLimit(logFormat);
        }
        catch (LogFormatException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LogFormatException("Could not parse LogFormat file.", e);
        }
        return logFormat;
    }

    public LogSystemType getSystemType() {
        if (this.fSystemType == null) {
            Element format = (Element)this.configDoc.getElementsByTagName("LogFormat").item(0);
            Element sysTypeElement = (Element)format.getElementsByTagName("SystemType").item(0);
            String liveLog = sysTypeElement.getAttribute("live-log");
            String regex = sysTypeElement.getAttribute("file");
            String dir = sysTypeElement.getAttribute("location");
            String system = sysTypeElement.getAttribute("system");
            String sysVer = sysTypeElement.getAttribute("version");
            String descending = sysTypeElement.getAttribute("number-descending");
            String sortStr = sysTypeElement.getAttribute("sort");
            LogSystemType.SortMethod sort = LogSystemType.SortMethod.Filenum;
            if (sortStr.equals("filename")) {
                sort = LogSystemType.SortMethod.Filename;
            }
            if (sortStr.equals("time")) {
                sort = LogSystemType.SortMethod.Time;
            }
            boolean isDescending = descending != null && (descending.equalsIgnoreCase("true") || descending.equalsIgnoreCase("yes"));
            this.fSystemType = new LogSystemType(system, sysVer, dir, regex, liveLog, isDescending, sort);
        }
        return this.fSystemType;
    }

    private int getFields(XPath xpath, int logFormatIndex, String logFormatName, LogFormat logFormatObj) throws Exception {
        int numFields = Integer.parseInt(xpath.evaluate("count(/root/LogFormat[" + Integer.toString(logFormatIndex) + "]/Fields/Field)", this.configDoc));
        String logFormatNum = Integer.toString(logFormatIndex);
        int j = 1;
        while (j <= numFields) {
            String fieldNum = Integer.toString(j);
            String name = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Fields/Field[" + fieldNum + "]/Name/text()", this.configDoc);
            String lowerBound = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Fields/Field[" + fieldNum + "]/LowerBound/text()", this.configDoc);
            String upperBound = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Fields/Field[" + fieldNum + "]/UpperBound/text()", this.configDoc);
            String regexMatch = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Fields/Field[" + fieldNum + "]/RegexMatch/text()", this.configDoc);
            String regexCaptureGroup = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Fields/Field[" + fieldNum + "]/RegexCaptureGroup/text()", this.configDoc);
            logFormatObj.addField(name, lowerBound, upperBound, regexMatch, regexCaptureGroup);
            ++j;
        }
        return numFields;
    }

    private int getColumns(XPath xpath, int logFormatIndex, String logFormatName, LogFormat logFormatObj) throws Exception {
        int numColumns = Integer.parseInt(xpath.evaluate("count(/root/LogFormat[" + Integer.toString(logFormatIndex) + "]/Columns/Column)", this.configDoc));
        String logFormatNum = Integer.toString(logFormatIndex);
        int j = 1;
        while (j <= numColumns) {
            String columnNum = Integer.toString(j);
            String columnName = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Columns/Column[" + columnNum + "]/Name/text()", this.configDoc);
            String isDefault = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Columns/Column[" + columnNum + "]/Default/text()", this.configDoc);
            String widthWeight = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Columns/Column[" + columnNum + "]/WidthWeight/text()", this.configDoc);
            String columnType = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Columns/Column[" + columnNum + "]/ColumnType/text()", this.configDoc);
            String dateFormat = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Columns/Column[" + columnNum + "]/DateFormat/text()", this.configDoc);
            String fieldGlue = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Columns/Column[" + columnNum + "]/FieldGlue/text()", this.configDoc);
            logFormatObj.addColumn(columnName, isDefault, widthWeight, columnType, dateFormat, fieldGlue);
            int numFieldsInColumn = Integer.parseInt(xpath.evaluate("count(/root/LogFormat[" + Integer.toString(logFormatIndex) + "]/Columns/Column[" + Integer.toString(j) + "]/AssignFields/FieldName)", this.configDoc));
            if (numFieldsInColumn == 0 && !columnType.equals(LogFormat.ColumnType.LOGINDEX.toString())) {
                throw new Exception(" There should be at least one Field assigned to Column " + columnName);
            }
            int k = 1;
            while (k <= numFieldsInColumn) {
                String fieldName = xpath.evaluate("/root/LogFormat[" + logFormatNum + "]/Columns/Column[" + columnNum + "]/AssignFields/FieldName[" + Integer.toString(k) + "]/text()", this.configDoc);
                logFormatObj.addFieldToColumn(fieldName, columnName);
                ++k;
            }
            ++j;
        }
        return numColumns;
    }

    private int getKnownSystypes(XPath xpath, int logFormatIndex, String logFormatName, LogFormat logFormatObj) throws Exception {
        int numFilenames = Integer.parseInt(xpath.evaluate("count(/root/LogFormat[" + Integer.toString(logFormatIndex) + "]/SystemType)", this.configDoc));
        return numFilenames;
    }

    public String getLogFilePath() throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String logFilePath = null;
        try {
            logFilePath = xpath.evaluate("/root/InputLogFile/text()", this.configDoc);
            if (logFilePath == null || logFilePath.length() == 0) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new Exception(" Log file name is missing from the configuration.");
        }
        return logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        XmlDocUtils.replaceXmlElement(this.configDoc, "InputLogFile", logFilePath);
    }

    public String getXmlFromDocument() {
        return XmlDocUtils.getXmlStringFromDocument(this.configDoc);
    }

    public String[] getSourceIDs() throws Exception {
        return XmlDocUtils.getElements(this.configDoc, "/root/SourceLogFiles/Source", "ID");
    }

    public SourceInfo[] getSourceInfos() throws Exception {
        String[] sourceIDs = this.getSourceIDs();
        SourceInfo[] infos = new SourceInfo[sourceIDs.length];
        int i = 0;
        while (i < sourceIDs.length) {
            infos[i] = new SourceInfo(sourceIDs[i]);
            ++i;
        }
        return infos;
    }

    public String[] getFileRegExesInSrc(String id) throws Exception {
        return XmlDocUtils.getElements(this.configDoc, "/root/SourceLogFiles/Source[ID='" + id + "']/FileRegEx", "");
    }

    public String getConfigFilePath() {
        return this.configFile.getAbsolutePath();
    }

    public String getConfigFileName() {
        return this.configFile.getName();
    }

    public String updateUniqueID() throws Exception {
        XmlDocUtils.replaceXmlElement(this.configDoc, "logx_ID", Double.toHexString(Math.random()));
        return XmlDocUtils.getElement(this.configDoc, "/root/logx_ID");
    }

    public String getUniqueID() throws Exception {
        return XmlDocUtils.getElement(this.configDoc, "/root/logx_ID");
    }

    public void updateDateDelta(long dateDelta) throws Exception {
        XmlDocUtils.replaceXmlElement(this.configDoc, "DateDelta", Long.toString(dateDelta));
    }

    public long getDateDelta() {
        try {
            String myStr = XmlDocUtils.getElement(this.configDoc, "/root/DateDelta");
            return Long.parseLong(myStr);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public void setSizeLimit(LogFormat fmt) {
        try {
            String myStr = XmlDocUtils.getElement(this.configDoc, "/root/LogFormat/SizeLimit");
            if (myStr != null && !myStr.isEmpty()) {
                fmt.setSizeLimitMB(Integer.parseInt(myStr));
            }
        }
        catch (Exception exception) {}
    }

    public String getLogFormatName() throws Exception {
        return XmlDocUtils.getElement(this.configDoc, "/root/LogFormat/Name");
    }

    public String getCategory() throws Exception {
        return XmlDocUtils.getElement(this.configDoc, "/root/LogFormat/Category");
    }

    public boolean getOkFromSupportBundle() throws Exception {
        String result = XmlDocUtils.getElementIfExist(this.configDoc, "/root/LogFormat/OkFromSupportBundle");
        if (result == null || result.length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(result);
    }

    public void addSrcLogFileNode(String srcHostname, String parentDir, String archivePath, String[] fileRegExArr) throws Exception {
        archivePath = archivePath != null && archivePath.length() > 0 ? ";" + archivePath : "";
        String idStr = String.valueOf(srcHostname) + archivePath + ";" + parentDir;
        XPath xpath = XPathFactory.newInstance().newXPath();
        Object sourceNodeObj = null;
        try {
            sourceNodeObj = xpath.evaluate("/root/SourceLogFiles/Source[ID='" + idStr + "']", this.configDoc, XPathConstants.NODE);
        }
        catch (Exception exception) {
            throw new Exception("There was an XML parsing problem while locating " + idStr);
        }
        Element sourceElmt = null;
        if (sourceNodeObj == null) {
            Element idElmt = this.configDoc.createElement("ID");
            idElmt.appendChild(this.configDoc.createTextNode(idStr));
            sourceElmt = this.configDoc.createElement("Source");
            sourceElmt.appendChild(idElmt);
        } else {
            sourceElmt = (Element)sourceNodeObj;
        }
        String[] stringArray = fileRegExArr;
        int n = fileRegExArr.length;
        int n2 = 0;
        while (n2 < n) {
            String fileREStr = stringArray[n2];
            String testStr = null;
            try {
                String mySearchStr = "/root/SourceLogFiles/Source[ID='" + idStr + "' and FileRegEx='" + fileREStr + "']" + "/FileRegEx[text()='" + fileREStr + "']/text()";
                testStr = xpath.evaluate(mySearchStr, this.configDoc);
            }
            catch (Exception exception) {
                throw new Exception("There was an XML parsing problem while locating " + testStr);
            }
            if (testStr == null || testStr.trim().length() == 0) {
                Element fileREElmt = this.configDoc.createElement("FileRegEx");
                fileREElmt.appendChild(this.configDoc.createTextNode(fileREStr));
                sourceElmt.appendChild(fileREElmt);
            }
            ++n2;
        }
        Node rootNode = this.configDoc.getFirstChild();
        Node sourceLogFilesElmt = null;
        NodeList nodeList = rootNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeName().equals("SourceLogFiles")) {
                sourceLogFilesElmt = (Element)nodeList.item(i);
                break;
            }
            ++i;
        }
        if (sourceLogFilesElmt == null) {
            sourceLogFilesElmt = this.configDoc.createElement("SourceLogFiles");
            rootNode.appendChild(sourceLogFilesElmt);
        }
        sourceLogFilesElmt.appendChild(sourceElmt);
    }

    public void addArchiveSrcLogElement(String srcHostChoice, String archivePath) throws Exception {
        String parentDir = this.fSystemType.getDir();
        String[] regExArr = new String[]{this.fSystemType.getFileRegex()};
        this.addSrcLogFileNode(srcHostChoice, parentDir, archivePath, regExArr);
    }

    public void addRemoteSrcLogElement(String srcHostChoice) throws Exception {
        String parentDir = this.fSystemType.getDir();
        String[] regExArr = new String[]{this.fSystemType.getFileRegex()};
        this.addSrcLogFileNode(srcHostChoice, parentDir, "", regExArr);
    }

    public void addLocalSrcLogElements(String logFilePaths) throws Exception {
        if (logFilePaths == null || logFilePaths.length() == 0) {
            return;
        }
        String[] logFileArr = logFilePaths.split(";");
        if (logFileArr.length == 0) {
            return;
        }
        String parentDir = LogFileUtils.getParentDir(logFileArr[0]);
        ArrayList<String> logFileList = new ArrayList<String>();
        String[] stringArray = logFileArr;
        int n = logFileArr.length;
        int n2 = 0;
        while (n2 < n) {
            String logFilePath = stringArray[n2];
            logFileList.add(String.valueOf(LogFileUtils.getFileName(logFilePath)) + "$");
            ++n2;
        }
        this.addSrcLogFileNode("localhost", parentDir, "", logFileList.toArray(new String[logFileList.size()]));
    }

    public void addLogFilterNode(LogFilter logFilter) throws Exception {
        Element filtersElmt = this.getFiltersElement();
        if (filtersElmt == null) {
            filtersElmt = this.configDoc.createElement("Filters");
            Node rootNode = this.configDoc.getFirstChild();
            rootNode.appendChild(filtersElmt);
        }
        this.deleteLogFilter(logFilter.getName(), filtersElmt);
        this.buildLogFilterNode(logFilter, filtersElmt);
    }

    private Element getFiltersElement() {
        Node rootNode = this.configDoc.getFirstChild();
        Element filtersElmt = null;
        NodeList nodeList = rootNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeName().equals("Filters")) {
                filtersElmt = (Element)nodeList.item(i);
                break;
            }
            ++i;
        }
        return filtersElmt;
    }

    private void deleteLogFilter(String lfName, Element filtersElmt) {
        Node filter = null;
        boolean found = false;
        NodeList filtersChildren = filtersElmt.getChildNodes();
        int i = 0;
        while (i < filtersChildren.getLength()) {
            if (filtersChildren.item(i).getNodeName().equals("Filter")) {
                filter = filtersChildren.item(i);
                NodeList filterChildren = filter.getChildNodes();
                int j = 0;
                while (j < filterChildren.getLength()) {
                    Node cdataName;
                    Node filterChild = filterChildren.item(j);
                    if (filterChild.getNodeName().equals("Name") && (cdataName = filterChild.getFirstChild()) != null && cdataName.getNodeType() == 4 && cdataName.getTextContent().equals(lfName)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            if (found) break;
            ++i;
        }
        if (found) {
            filtersElmt.removeChild(filter);
        }
    }

    public void deleteLogFilter(String logFilterName) {
        Element filtersElmt = this.getFiltersElement();
        if (filtersElmt == null) {
            return;
        }
        this.deleteLogFilter(logFilterName, filtersElmt);
    }

    private void buildLogFilterNode(LogFilter logFilter, Element filtersElmt) throws Exception {
        Element filterElmt = this.configDoc.createElement("Filter");
        Element filterNameElmt = this.configDoc.createElement("Name");
        filterNameElmt.appendChild(this.configDoc.createCDATASection(logFilter.getName()));
        filterElmt.appendChild(filterNameElmt);
        Element filterRowsElmt = this.configDoc.createElement("FilterRows");
        int rowIdx = 0;
        while (rowIdx < logFilter.getNumRows()) {
            Element filterRowElmt = this.configDoc.createElement("FilterRow");
            Element filterItemsElmt = this.configDoc.createElement("FilterItems");
            int colIdx = 0;
            while (colIdx < logFilter.getNumColumns(rowIdx)) {
                FilterItem filterItem = logFilter.getFilterItem(rowIdx, colIdx);
                Element boolConnElmt = this.configDoc.createElement("BooleanConnector");
                boolConnElmt.appendChild(this.configDoc.createTextNode(filterItem.getBoolConnector().toString()));
                Element notElmt = this.configDoc.createElement("NOT");
                notElmt.appendChild(this.configDoc.createTextNode(filterItem.isNegateFlagSet() ? "True" : "False"));
                Element keywordElmt = this.configDoc.createElement("Keyword");
                keywordElmt.appendChild(this.configDoc.createCDATASection(filterItem.getKeyword()));
                Element regExElmt = this.configDoc.createElement("RegEx");
                regExElmt.appendChild(this.configDoc.createTextNode(filterItem.isRegexFlagSet() ? "True" : "False"));
                Element filterItemElmt = this.configDoc.createElement("FilterItem");
                filterItemElmt.appendChild(boolConnElmt);
                filterItemElmt.appendChild(notElmt);
                filterItemElmt.appendChild(keywordElmt);
                filterItemElmt.appendChild(regExElmt);
                filterItemsElmt.appendChild(filterItemElmt);
                ++colIdx;
            }
            filterRowElmt.appendChild(filterItemsElmt);
            filterRowsElmt.appendChild(filterRowElmt);
            ++rowIdx;
        }
        filterElmt.appendChild(filterRowsElmt);
        Element numSurrLinesElmt = this.configDoc.createElement("NumSurroundingLines");
        numSurrLinesElmt.appendChild(this.configDoc.createTextNode(Integer.toString(logFilter.getNumSurroundingLines())));
        filterElmt.appendChild(numSurrLinesElmt);
        filtersElmt.appendChild(filterElmt);
    }

    public Map<String, LogFilter> getLogFilters() throws Exception {
        new HashMap();
        return ConfigParser.getLogFilters(this.configDoc);
    }

    public static Map<String, LogFilter> getLogFilters(InputStream configInputXmlStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        dbf.setIgnoringComments(true);
        Document configDoc = db.parse(configInputXmlStream);
        return ConfigParser.getLogFilters(configDoc);
    }

    public static Map<String, LogFilter> getLogFilters(Document configDoc) throws Exception {
        HashMap<String, LogFilter> namedLogFilters = new HashMap<String, LogFilter>();
        Node rootNode = configDoc.getFirstChild();
        Node filtersElmt = null;
        NodeList nodeList = rootNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeName().equals("Filters")) {
                filtersElmt = (Element)nodeList.item(i);
                break;
            }
            ++i;
        }
        if (filtersElmt == null) {
            return namedLogFilters;
        }
        NodeList filtersChildren = filtersElmt.getChildNodes();
        int i2 = 0;
        while (i2 < filtersChildren.getLength()) {
            if (filtersChildren.item(i2).getNodeName().equals("Filter")) {
                Node filter = filtersChildren.item(i2);
                LogFilter logFilter = ConfigParser.getLogFilterObj(filter);
                namedLogFilters.put(logFilter.getName(), logFilter);
            }
            ++i2;
        }
        return namedLogFilters;
    }

    private static LogFilter getLogFilterObj(Node filter) throws Exception {
        LogFilter logFilter = new LogFilter("", 0, 2);
        NodeList filterChildren = filter.getChildNodes();
        int j = 0;
        while (j < filterChildren.getLength()) {
            Node filterChild = filterChildren.item(j);
            if (filterChild.getNodeName().equals("Name")) {
                Node cdataName = filterChild.getFirstChild();
                if (cdataName != null && cdataName.getNodeType() == 4) {
                    logFilter.setName(cdataName.getTextContent());
                }
            } else if (filterChild.getNodeName().equals("FilterRows")) {
                Node filterRows = filterChild;
                ConfigParser.populateLogFilterRows(logFilter, filterRows);
            } else if (filterChild.getNodeName().equals("NumSurroundingLines")) {
                Node numSurrLines = filterChild;
                logFilter.setNumSurroundingLines(Integer.parseInt(numSurrLines.getTextContent()));
            }
            ++j;
        }
        return logFilter;
    }

    private static void populateLogFilterRows(LogFilter logFilter, Node filterRows) throws Exception {
        NodeList filterRowsChildren = filterRows.getChildNodes();
        int filterRowIndex = 0;
        int frsChildIndex = 0;
        while (frsChildIndex < filterRowsChildren.getLength()) {
            Node filterRowsChild = filterRowsChildren.item(frsChildIndex);
            if (filterRowsChild.getNodeName().equals("FilterRow")) {
                Node filterRow = filterRowsChild;
                NodeList filterRowChildren = filterRow.getChildNodes();
                int j = 0;
                while (j < filterRowChildren.getLength()) {
                    if (filterRowChildren.item(j).getNodeName().equals("FilterItems")) {
                        Node filterItems = filterRowChildren.item(j);
                        NodeList filterItemsChildren = filterItems.getChildNodes();
                        int filterItemIndex = 0;
                        int fisChildIdx = 0;
                        while (fisChildIdx < filterItemsChildren.getLength()) {
                            if (filterItemsChildren.item(fisChildIdx).getNodeName().equals("FilterItem")) {
                                Node filterItem = filterItemsChildren.item(fisChildIdx);
                                ConfigParser.populateLogFilterItems(logFilter, filterRowIndex, filterItemIndex, filterItem);
                                ++filterItemIndex;
                            }
                            ++fisChildIdx;
                        }
                    }
                    ++j;
                }
                ++filterRowIndex;
            }
            ++frsChildIndex;
        }
    }

    private static void populateLogFilterItems(LogFilter logFilter, int rowIndex, int filterItemIndex, Node filterItem) throws Exception {
        NodeList filterItemChildren = filterItem.getChildNodes();
        FilterItem fi = new FilterItem();
        int n = 0;
        while (n < filterItemChildren.getLength()) {
            Node cdataKeyword;
            Node filterDatum = filterItemChildren.item(n);
            if (filterDatum.getNodeName().equals("BooleanConnector")) {
                fi.setBoolConnector(filterDatum.getTextContent());
            }
            if (filterDatum.getNodeName().equals("NOT")) {
                fi.setNegateFlag(filterDatum.getTextContent().equals("True"));
            }
            if (filterDatum.getNodeName().equals("RegEx")) {
                fi.setRegexFlag(filterDatum.getTextContent().equals("True"));
            }
            if (filterDatum.getNodeName().equals("Keyword") && (cdataKeyword = filterDatum.getFirstChild()) != null && cdataKeyword.getNodeType() == 4) {
                fi.setKeyword(cdataKeyword.getTextContent());
            }
            ++n;
        }
        logFilter.setFilterItem(rowIndex, filterItemIndex, fi);
    }

    public Document getConfigDoc() {
        return this.configDoc;
    }

    public class SourceInfo {
        private String host = null;
        private String archiveFilepath = null;
        private String parentDir = null;

        public SourceInfo(String srcID) {
            String[] srcIDparts = ConfigParser.splitSourceID(srcID);
            if (srcIDparts != null) {
                this.host = srcIDparts[0];
                this.archiveFilepath = srcIDparts[1];
                this.parentDir = srcIDparts[2];
            }
        }

        public String getHost() {
            return this.host;
        }

        public String getArchiveFilepath() {
            return this.archiveFilepath;
        }

        public String getParentDir() {
            return this.parentDir;
        }
    }
}

