/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.parser.ILineReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class LineReader
implements ILineReader {
    private static final int REPLACEMENT_CHARACTER = 65533;
    private static final int MAX_CHARENCODE_BYTES = 11;
    private final FileInputStream fis;
    private final Charset cset;
    private final ByteBuffer bb = ByteBuffer.allocate(11);
    private ByteBuffer buf = ByteBuffer.allocate(11);
    private static final int EMPTY = -2;
    private int prevChar = -2;
    private int prevNum;

    private int readByte() throws IOException {
        if (this.buf.hasRemaining()) {
            return this.buf.get();
        }
        return this.fis.read();
    }

    private void putBack(byte[] bytes) {
        ByteBuffer newBuf = ByteBuffer.allocate(11);
        newBuf.put(bytes);
        newBuf.put(this.buf);
        this.buf = newBuf;
        this.buf.flip();
    }

    LineReader(FileInputStream fis, String charsetName) {
        this.fis = fis;
        this.cset = Charset.forName(charsetName);
        this.buf.flip();
    }

    private int readChar(char[] readIn) throws IOException {
        int b;
        int count = 0;
        while ((b = this.readByte()) != -1) {
            char ch;
            ++count;
            this.bb.put((byte)b);
            this.bb.flip();
            byte[] ba = new byte[this.bb.limit()];
            this.bb.get(ba);
            ByteBuffer src = ByteBuffer.wrap(ba);
            CharBuffer dst = this.cset.decode(src);
            if (dst.limit() == 1 || dst.limit() == 2) {
                ch = dst.charAt(dst.limit() - 1);
                if (ch == '\ufffd') {
                    if (this.bb.position() == this.bb.capacity()) {
                        this.bb.position(1);
                        byte[] remain = new byte[this.bb.remaining()];
                        this.bb.get(remain);
                        this.putBack(remain);
                        this.bb.position(0);
                        readIn[0] = 65533;
                        return 1;
                    }
                    this.bb.position(this.bb.limit());
                    this.bb.limit(this.bb.capacity());
                    continue;
                }
                this.bb.position(0);
                readIn[0] = ch;
                return count;
            }
            ch = dst.charAt(1);
            this.bb.position(0);
            byte[] b1 = new byte[]{ba[ba.length - 1]};
            this.putBack(b1);
            readIn[0] = ch;
            return count - 1;
        }
        if (this.bb.position() != 0) {
            readIn[0] = 65533;
            int ret = this.bb.position();
            this.bb.position(0);
            return ret;
        }
        return -1;
    }

    private int readSingleChar(char[] readIn) throws IOException {
        if (this.prevChar != -2) {
            readIn[0] = (char)this.prevChar;
            this.prevChar = -2;
            return this.prevNum;
        }
        return this.readChar(readIn);
    }

    private void putBackChar(int num, char ch) {
        if (this.prevChar != -2) {
            throw new BufferOverflowException();
        }
        this.prevNum = num;
        this.prevChar = ch;
    }

    @Override
    public int readLine(StringBuilder sb) throws IOException {
        int num;
        int lineLen = 0;
        char[] readIn = new char[1];
        boolean eof = true;
        while ((num = this.readSingleChar(readIn)) != -1) {
            lineLen += num;
            eof = false;
            if (readIn[0] == '\n' || readIn[0] == '\r') {
                int extra = this.readChar(readIn);
                if (extra == -1) break;
                if (readIn[0] == '\n' || readIn[0] == '\r') {
                    lineLen += extra;
                    break;
                }
                this.putBackChar(extra, readIn[0]);
                break;
            }
            sb.append(readIn[0]);
        }
        if (eof) {
            return -1;
        }
        return lineLen;
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }
}

