/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import com.vmware.vide.vlogbrowser.core.fileops.BaseLogWorker;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.model.util.IFilteredList;
import com.vmware.vide.vlogbrowser.core.parser.ILineReader;
import com.vmware.vide.vlogbrowser.core.parser.IParserFileListener;
import com.vmware.vide.vlogbrowser.core.parser.LineReaderFactory;
import com.vmware.vide.vlogbrowser.core.parser.LogDateFormat;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import com.vmware.vide.vlogbrowser.core.parser.ParserEvent;
import com.vmware.vide.vlogbrowser.core.parser.RAFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogParser {
    private int logItemIndex;
    private List<IParserFileListener> listeners = new ArrayList<IParserFileListener>();
    private static final Logger logger = LoggerFactory.getLogger(LogParser.class);

    private void readLogFile(LogFormat logFormat, int logFileNumber, String targetFilePath, RAFile raFile, IFilteredList<LogItem> filterList, IProgressMonitor monitor) throws IOException {
        int lineLength;
        String charEncode = logFormat.getCharEncode();
        File targetFile = new File(targetFilePath);
        ILineReader reader = LineReaderFactory.createLineReader(new FileInputStream(targetFile), charEncode);
        Date srcFileTimestamp = raFile.getSrcFileTimestamp();
        LogDateFormat format = logFormat.getDateFormat();
        LogDateFormat dateFormat = new LogDateFormat(format, srcFileTimestamp, raFile.getTargetFileName());
        long fileSize = targetFile.length();
        monitor.beginTask("", (int)fileSize);
        LogItem lastLogItem = null;
        long fileOffset = 0L;
        StringBuilder lineBuf = new StringBuilder();
        monitor.subTask(targetFile.getName());
        while ((lineLength = reader.readLine(lineBuf)) != -1) {
            LogItem logItem = logFormat.initialParse(lineBuf.toString().trim(), lastLogItem, fileOffset, lineLength, logFileNumber, this.logItemIndex, dateFormat);
            fileOffset += (long)lineLength;
            lineBuf.setLength(0);
            if (logItem != null) {
                ++this.logItemIndex;
                filterList.add(logItem);
                lastLogItem = logItem;
            } else if (lastLogItem != null) {
                int index = (int)lastLogItem.getLogIndexNum() - 1;
                filterList.set(index, lastLogItem);
            }
            if (monitor.isCanceled()) break;
        }
        reader.close();
        monitor.done();
    }

    public void loadFromFiles(LogFormat logFormat, BaseLogWorker logWorker, IProgressMonitor monitor) throws Exception {
        List<RAFile> raFiles = logFormat.getRandAccFileList();
        int nFiles = raFiles.size();
        if (raFiles == null || nFiles == 0) {
            return;
        }
        RAFile lastRaFile = logFormat.getRandAccFile(nFiles - 1);
        logFormat.updateDate(lastRaFile.getSrcFileTimestamp());
        IFilteredList<LogItem> filterList = logWorker.getFilterList();
        filterList.clear();
        this.logItemIndex = 1;
        monitor.beginTask("Starting parser...", nFiles);
        int currentFile = 0;
        while (currentFile < nFiles) {
            int logFileNumber = currentFile;
            RAFile raFile = logFormat.getRandAccFile(currentFile);
            String targetFilePath = raFile.getTargetFilePath(true);
            try {
                monitor.setTaskName("Parsing " + (currentFile + 1) + " of " + nFiles);
                raFile.open();
                this.readLogFile(logFormat, logFileNumber, targetFilePath, raFile, filterList, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                logger.debug("adding log file " + logFileNumber);
                this.fireDoneEvent(new ParserEvent(currentFile, nFiles, raFile.getTargetFileName()));
            }
            catch (Exception ex) {
                logger.error("Error adding file " + logFileNumber, (Throwable)ex);
            }
            ++currentFile;
        }
        monitor.done();
    }

    public static boolean isLoggingEvents() {
        String logEventsKey = String.valueOf(LogBrowserPlugin.getDefault().getBundle().getSymbolicName()) + "/log/parseEvents";
        String debugOption = Platform.getDebugOption((String)logEventsKey);
        return Boolean.parseBoolean(debugOption);
    }

    public void addListener(IParserFileListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IParserFileListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireDoneEvent(ParserEvent evt) {
        for (IParserFileListener listener : this.listeners) {
            listener.done(evt);
        }
    }
}

