/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.parser.RAFile;
import com.vmware.vide.vlogbrowser.core.parser.XmlDocUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestFile {
    private File mfstFile;
    private List<RAFile> raFiles;
    private Document xmlDocument;
    public static final String MANIFEST_TEMPLATE = "manifest.xml";

    public ManifestFile(String parentDir, String configFilename, boolean overwriteManifest) throws Exception {
        this.mfstFile = new File(parentDir, MANIFEST_TEMPLATE);
        if (overwriteManifest || !ManifestFile.isLegalManifest(this.mfstFile)) {
            this.initNewManifestFile(configFilename);
        } else {
            this.xmlDocument = XmlDocUtils.parseXmlFromFile(this.mfstFile);
        }
        this.raFiles = new ArrayList<RAFile>();
        this.loadFileList();
    }

    public void initNewManifestFile(String configFilename) throws Exception {
        this.mfstFile.delete();
        this.mfstFile.createNewFile();
        this.createNewManifest(configFilename);
    }

    public static boolean isLegalManifest(File testFile) {
        Document manifestDoc;
        block3: {
            try {
                manifestDoc = XmlDocUtils.parseXmlFromFile(testFile);
                String configFileValue = XmlDocUtils.getElement(manifestDoc, "/root/ConfigFile");
                if (configFileValue != null && configFileValue.trim().length() != 0) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        XmlDocUtils.getElement(manifestDoc, "/root/StagedLogFiles");
        return true;
    }

    public boolean isValidFileList() {
        for (RAFile raFile : this.raFiles) {
            try {
                raFile.open();
                raFile.close();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void createNewManifest(String configFilename) throws Exception {
        File templateFile = this.getManifestTemplate();
        this.xmlDocument = XmlDocUtils.parseXmlFromFile(templateFile);
        XmlDocUtils.replaceXmlElement(this.xmlDocument, "ConfigFile", configFilename);
        this.flushToDisk();
    }

    public void flushToDisk() throws IOException {
        String xmlContents = XmlDocUtils.getXmlStringFromDocument(this.xmlDocument);
        BufferedWriter bufferedOut = new BufferedWriter(new FileWriter(this.mfstFile.getCanonicalFile()));
        bufferedOut.write(xmlContents);
        bufferedOut.close();
    }

    public void loadFileList() {
        try {
            String[] fileIDArr = null;
            fileIDArr = XmlDocUtils.getElements(this.xmlDocument, "/root/StagedLogFiles/File", "SeqNum");
            if (fileIDArr == null || fileIDArr.length == 0) {
                return;
            }
            SimpleDateFormat stdDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            int i = 0;
            while (i < fileIDArr.length) {
                String pathPrefix = "/root/StagedLogFiles/File[SeqNum='" + fileIDArr[i] + "']/";
                String srcHostname = XmlDocUtils.getElement(this.xmlDocument, String.valueOf(pathPrefix) + "SrcHostname[1]");
                String srcFilePath = XmlDocUtils.getElement(this.xmlDocument, String.valueOf(pathPrefix) + "SrcFilePath[1]");
                String targetFilePath = XmlDocUtils.getElement(this.xmlDocument, String.valueOf(pathPrefix) + "TargetFilePath[1]");
                String date = XmlDocUtils.getElement(this.xmlDocument, String.valueOf(pathPrefix) + "Date[1]");
                String size = XmlDocUtils.getElement(this.xmlDocument, String.valueOf(pathPrefix) + "Size[1]");
                RAFile raFile = new RAFile();
                raFile.setSrcFileHost(srcHostname);
                raFile.setSrcFilePath(srcFilePath);
                raFile.setSrcFileTimestamp(stdDateFormat.parse(date));
                raFile.setSizeInBytes(Integer.parseInt(size));
                raFile.setTargetFilePath(targetFilePath);
                this.raFiles.add(raFile);
                ++i;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addManifestFileNode(String seqNum, String srcHostname, String srcFilePath, String targetFilePath, String date, String size) throws Exception {
        Element seqNumElmt = this.xmlDocument.createElement("SeqNum");
        seqNumElmt.appendChild(this.xmlDocument.createTextNode(seqNum));
        Element hostnameElmt = this.xmlDocument.createElement("SrcHostname");
        hostnameElmt.appendChild(this.xmlDocument.createTextNode(srcHostname));
        Element srcFilePathElmt = this.xmlDocument.createElement("SrcFilePath");
        srcFilePathElmt.appendChild(this.xmlDocument.createTextNode(srcFilePath));
        Element tgtFilePathElmt = this.xmlDocument.createElement("TargetFilePath");
        tgtFilePathElmt.appendChild(this.xmlDocument.createTextNode(targetFilePath));
        Element dateElmt = this.xmlDocument.createElement("Date");
        dateElmt.appendChild(this.xmlDocument.createTextNode(date));
        Element sizeElmt = this.xmlDocument.createElement("Size");
        sizeElmt.appendChild(this.xmlDocument.createTextNode(size));
        Element fileElmt = this.xmlDocument.createElement("File");
        fileElmt.appendChild(seqNumElmt);
        fileElmt.appendChild(hostnameElmt);
        fileElmt.appendChild(srcFilePathElmt);
        fileElmt.appendChild(tgtFilePathElmt);
        fileElmt.appendChild(dateElmt);
        fileElmt.appendChild(sizeElmt);
        Node rootNode = this.xmlDocument.getFirstChild();
        Node stagedLFElement = null;
        NodeList nodeList = rootNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeName().equals("StagedLogFiles")) {
                stagedLFElement = (Element)nodeList.item(i);
                break;
            }
            ++i;
        }
        if (stagedLFElement == null) {
            stagedLFElement = this.xmlDocument.createElement("StagedLogFiles");
            rootNode.appendChild(stagedLFElement);
        }
        stagedLFElement.appendChild(fileElmt);
    }

    public void addRAFiles(List<RAFile> moreRAFiles) throws Exception {
        if (moreRAFiles == null || moreRAFiles.size() == 0) {
            return;
        }
        SimpleDateFormat stdDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (RAFile raFile : moreRAFiles) {
            String tfp = raFile.getTargetFilePath(false);
            if (tfp == null) {
                tfp = "";
            }
            this.addManifestFileNode(Integer.toString(this.raFiles.size()), raFile.getSrcFileHost(), raFile.getSrcFilePath(), tfp, stdDateFormat.format(raFile.getSrcFileTimestamp()), Integer.toString(raFile.getSizeInBytes()));
            this.raFiles.add(raFile);
        }
        this.flushToDisk();
    }

    public Document getDocument() {
        return this.xmlDocument;
    }

    public List<RAFile> getFileList() {
        return this.raFiles;
    }

    public File getFile() {
        return this.mfstFile;
    }

    public File getManifestTemplate() {
        return this.getXMLTemplateFile(MANIFEST_TEMPLATE);
    }

    private File getXMLTemplateFile(String fileName) {
        try {
            File file;
            URL path = FileLocator.toFileURL((URL)this.getClass().getResource("/templates/" + fileName));
            if (path != null && path.getFile() != null && (file = new File(path.getFile())).exists()) {
                return file;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

