/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.fileops.LogFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RAFile
implements Comparable<RAFile> {
    private String targetFilePath;
    private File file;
    private RandomAccessFile rafile;
    private String nextLine;
    private String srcFilePath;
    private String srcFileHost;
    private char srcSeparator;
    private String srcArchivePath;
    private Date srcFileTimestamp;
    private int sizeInBytes;
    private boolean isArchive;
    private boolean seqNumInvertedForSort = false;
    private boolean isCanceled;

    public RAFile() {
    }

    public RAFile(String targetFilePath) throws Exception {
        this();
        this.targetFilePath = targetFilePath;
        this.file = new File(this.targetFilePath);
        this.rafile = new RandomAccessFile(this.file, "r");
    }

    public String getNextLine() throws IOException {
        return this.nextLine;
    }

    public void resetFilePointer() throws IOException {
        this.rafile.seek(0L);
    }

    public int loadNextLine() throws IOException {
        long initialPosition = this.rafile.getFilePointer();
        this.nextLine = this.rafile.readLine();
        if (this.nextLine != null) {
            return new Long(this.rafile.getFilePointer() - initialPosition).intValue();
        }
        return 0;
    }

    public int readBytes(byte[] buff, long offset) throws IOException {
        this.rafile.seek(offset);
        return this.rafile.read(buff, 0, buff.length);
    }

    public int readChars(char[] buff, long offset) throws IOException {
        byte[] myByteBuff = new byte[buff.length];
        int bytesRead = this.readBytes(myByteBuff, offset);
        int i = 0;
        while (i < buff.length) {
            buff[i] = (char)myByteBuff[i];
            ++i;
        }
        return bytesRead;
    }

    public long getCurrentPointer() throws IOException {
        return this.rafile.getFilePointer();
    }

    public void close() throws IOException {
        if (this.rafile != null) {
            this.rafile.close();
        }
    }

    public synchronized void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
        this.notifyAll();
    }

    public synchronized void setTargetFilePath(String targetFilePath) {
        this.targetFilePath = targetFilePath;
        this.notifyAll();
    }

    public synchronized String getTargetFilePath(boolean waitUntilReady) {
        if (!waitUntilReady && this.targetFilePath == null) {
            return null;
        }
        if (this.targetFilePath == null && !this.isCanceled) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.targetFilePath;
    }

    public String getTargetFileName() {
        return LogFileUtils.getFileName(this.getTargetFilePath(true));
    }

    public void setSrcFilePath(String srcFilePath) {
        this.srcFilePath = srcFilePath;
    }

    public String getSrcFilePath() {
        return this.srcFilePath;
    }

    public String getSrcFileName(boolean trimFileExtension) {
        if (trimFileExtension) {
            return LogFileUtils.getFileNameWithoutExt(this.srcFilePath);
        }
        int index = this.srcFilePath.lastIndexOf(this.srcSeparator);
        return this.srcFilePath.substring(index + 1);
    }

    public void setSrcFileHost(String srcFileHost) {
        this.srcFileHost = srcFileHost;
    }

    public String getSrcFileHost() {
        return this.srcFileHost;
    }

    public void setSrcFileTimestamp(Date srcFileTimestamp) {
        this.srcFileTimestamp = srcFileTimestamp;
    }

    public Date getSrcFileTimestamp() {
        return this.srcFileTimestamp;
    }

    public void setSizeInBytes(int size) {
        this.sizeInBytes = size;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSeqNumInvertedForSort(boolean seqNumInvertedForSort) {
        this.seqNumInvertedForSort = seqNumInvertedForSort;
    }

    public boolean isSeqNumInvertedForSort() {
        return this.seqNumInvertedForSort;
    }

    public void setSrcArchivePath(String srcArchivePath) {
        this.srcArchivePath = srcArchivePath;
    }

    public String getSrcArchivePath() {
        return this.srcArchivePath;
    }

    @Override
    public int compareTo(RAFile otherRAFile) {
        int compareResult = this.getFileSeqNum().compareTo(otherRAFile.getFileSeqNum());
        if (this.seqNumInvertedForSort) {
            compareResult = -compareResult;
        }
        if (!(compareResult != 0 && this.getSrcFileName(true).equals(otherRAFile.getSrcFileName(true)) || (compareResult = this.srcFileTimestamp.compareTo(otherRAFile.getSrcFileTimestamp())) != 0)) {
            compareResult = this.getSrcFileName(false).compareTo(otherRAFile.getSrcFileName(false));
        }
        return compareResult;
    }

    public void setArchive(boolean isArchive) {
        this.isArchive = isArchive;
    }

    public boolean isArchive() {
        return this.isArchive;
    }

    public String toString() {
        SimpleDateFormat stdDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String dateStr = stdDateFormat.format(this.srcFileTimestamp);
        return String.valueOf(this.srcFileHost) + "|" + this.srcFilePath + "|" + this.targetFilePath + "|" + dateStr + "|" + this.sizeInBytes;
    }

    public String toDisplayString() {
        SimpleDateFormat stdDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String dateStr = stdDateFormat.format(this.srcFileTimestamp);
        return String.valueOf(this.srcFileHost) + "; " + this.srcFilePath + "  " + dateStr + "  " + this.sizeInBytes;
    }

    public String toShortDisplayString() {
        return String.valueOf(this.srcFileHost) + " " + this.srcFilePath;
    }

    public void open() throws IOException {
        if (this.rafile != null) {
            this.rafile.close();
        }
        this.file = new File(this.targetFilePath);
        this.rafile = new RandomAccessFile(this.file, "r");
    }

    public Integer getFileSeqNum() {
        String fileName = this.getSrcFileName(false);
        String seqNumStr = LogFileUtils.getLastSubStringByRegEx(fileName, "\\d+", 0);
        Integer seqNum = new Integer(Integer.MIN_VALUE);
        try {
            seqNum = Integer.parseInt(seqNumStr);
        }
        catch (Exception exception) {}
        return seqNum;
    }

    public void setSrcSeparator(char c) {
        this.srcSeparator = c;
    }
}

