/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlDocUtils {
    public static void replaceXmlElement(Document myDoc, String elementName, String newValue) {
        Node rootNode = myDoc.getFirstChild();
        NodeList removeList = myDoc.getElementsByTagName(elementName);
        int removeLimit = removeList.getLength();
        int i = 0;
        while (i < removeLimit) {
            rootNode.removeChild(removeList.item(i));
            ++i;
        }
        Element replacementElement = myDoc.createElement(elementName);
        replacementElement.appendChild(myDoc.createTextNode(newValue));
        rootNode.appendChild(replacementElement);
    }

    public static Document parseXmlFromFile(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream fis = null;
        fis = new FileInputStream(xmlFile);
        Document xmlDoc = XmlDocUtils.readXmlFromInputStream(fis);
        fis.close();
        return xmlDoc;
    }

    public static Document readXmlFromInputStream(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBldrFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBldr = docBldrFactory.newDocumentBuilder();
        Document doc = docBldr.parse(inputStream);
        return doc;
    }

    public static String getXmlStringFromDocument(Document myDoc) {
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource domSource = new DOMSource(myDoc);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("standalone", "yes");
            transformer.transform(domSource, result);
            return writer.getBuffer().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getElement(Document myDoc, String pathAndName) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String elementValue = null;
        try {
            elementValue = xpath.evaluate(String.valueOf(pathAndName) + "/text()", myDoc);
        }
        catch (Exception exception) {
            throw new Exception("There was an XML parsing problem while locating " + pathAndName);
        }
        if (elementValue == null || elementValue.length() == 0) {
            throw new Exception(String.valueOf(pathAndName) + " is missing from the XML configuration.");
        }
        return elementValue;
    }

    public static String getElementIfExist(Document myDoc, String pathAndName) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String elementValue = null;
        try {
            elementValue = xpath.evaluate(String.valueOf(pathAndName) + "/text()", myDoc);
        }
        catch (Exception exception) {
            throw new Exception("There was an XML parsing problem while locating " + pathAndName);
        }
        return elementValue;
    }

    public static String[] getElements(Document myDoc, String parentElementPath, String optionalChildElement) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        int numNodes = Integer.parseInt(xpath.evaluate("count(" + parentElementPath + ")", myDoc));
        String[] returnArr = new String[numNodes];
        String extraPath = optionalChildElement == null ? "" : String.valueOf(optionalChildElement) + "/";
        int i = 1;
        while (i <= numNodes) {
            String nodeNumStr = Integer.toString(i);
            returnArr[i - 1] = xpath.evaluate(String.valueOf(parentElementPath) + "[" + nodeNumStr + "]/" + extraPath + "text()", myDoc);
            ++i;
        }
        return returnArr;
    }
}

