/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.runners;

import com.vmware.vide.vlogbrowser.core.model.LogFilter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BaseLogFilterRunner
implements Runnable {
    protected LogFilter logFilter;
    protected IProgressMonitor monitor;

    public BaseLogFilterRunner(LogFilter logFilter) {
        this.logFilter = logFilter;
        this.monitor = new NullProgressMonitor();
    }

    public void updateFilter(IProgressMonitor monitor) throws Exception {
    }

    public void showError(String message) {
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void run() {
        String filterMsg = "";
        try {
            if (!this.logFilter.isFilterEnabled()) {
                filterMsg = "Unfiltering...";
            } else {
                filterMsg = "Filtering ";
                filterMsg = !this.logFilter.isJustAKeyword() ? String.valueOf(filterMsg) + "on a filter expression named '" + this.logFilter.getName() + "'" : String.valueOf(filterMsg) + "on keyword '" + this.logFilter.getFirstKeyword() + "'";
                int additionalFilterLines = this.logFilter.getNumSurroundingLines();
                if (additionalFilterLines > 0) {
                    filterMsg = String.valueOf(filterMsg) + " with " + additionalFilterLines + " surrounding line" + (additionalFilterLines == 1 ? "" : "s");
                }
            }
            this.updateFilter(this.monitor);
        }
        catch (Exception e) {
            this.showError("While trying to perform filter operation '" + filterMsg + "' an error occurred: " + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    public void checkCancellation(IProgressMonitor monitor) throws InterruptedException {
    }
}

