/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.wbis;

import com.vmware.vide.wbis.Activator;
import com.vmware.vide.wbis.ExtensionManager;
import com.vmware.vide.wbis.VMwareEditorDescription;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.osgi.framework.Bundle;

public class DashboardContributionItem
extends ContributionItem {
    ILog logger = Activator.getDefault().getLog();

    public DashboardContributionItem() {
    }

    public DashboardContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = Activator.getDefault().getBundle().getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals("com.vmware.vide.dashboard")) {
                VMwareEditorDescription desc = this.getDashboardEditorDescription();
                if (desc == null) {
                    this.logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", "Could not find the editor description."));
                    return;
                }
                MenuItem item = new MenuItem(menu, 0, index);
                item.setText(desc.getName());
                final Bundle dashboardBundle = bundle;
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        try {
                            Class clazz = dashboardBundle.loadClass("com.vmware.vide.dashboard.PortalManager");
                            Method methodGetInstance = clazz.getMethod("getInstance", null);
                            Object portalManager = methodGetInstance.invoke(null, null);
                            Method methodOpen = clazz.getMethod("open", null);
                            methodOpen.invoke(portalManager, null);
                        }
                        catch (ClassNotFoundException e) {
                            DashboardContributionItem.this.logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
                        }
                        catch (SecurityException e) {
                            DashboardContributionItem.this.logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
                        }
                        catch (NoSuchMethodException e) {
                            DashboardContributionItem.this.logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
                        }
                        catch (IllegalArgumentException e) {
                            DashboardContributionItem.this.logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
                        }
                        catch (IllegalAccessException e) {
                            DashboardContributionItem.this.logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
                        }
                        catch (InvocationTargetException e) {
                            DashboardContributionItem.this.logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
                        }
                    }
                });
            }
            ++n2;
        }
    }

    private VMwareEditorDescription getDashboardEditorDescription() {
        List<VMwareEditorDescription> descriptions = ExtensionManager.INSTANCE.getVMwareEditors();
        for (VMwareEditorDescription desc : descriptions) {
            if (desc.getId() == null || !desc.getId().equals("com.vmware.vide.dashboard.editor")) continue;
            return desc;
        }
        return null;
    }
}

