/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.wbis;

import com.vmware.vide.wbis.VMwareEditorDescription;
import com.vmware.vide.wbis.VMwareNewWizardDescription;
import com.vmware.vide.wbis.VMwarePopupMenusDescription;
import com.vmware.vide.wbis.VMwareViewDescription;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public enum ExtensionManager {
    INSTANCE;


    public List<VMwareViewDescription> getVMwareViews() {
        ArrayList<VMwareViewDescription> viewDescriptions = new ArrayList<VMwareViewDescription>();
        List<IExtension> extensions = this.getVMwareExtensions("org.eclipse.ui.views");
        for (IExtension ext : extensions) {
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String elementName = element.getName();
                if (elementName.equals("view")) {
                    String iconPath = element.getAttribute("icon");
                    String id = element.getAttribute("id");
                    String name = element.getAttribute("name");
                    ImageDescriptor imgDesc = null;
                    Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)element.getContributor());
                    if (iconPath != null && bundle != null) {
                        imgDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle.getSymbolicName(), (String)iconPath);
                    }
                    viewDescriptions.add(new VMwareViewDescription(id, name, imgDesc));
                }
                ++n2;
            }
        }
        return viewDescriptions;
    }

    private List<IExtension> getVMwareExtensions(String pointId) {
        ArrayList<IExtension> results = new ArrayList<IExtension>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(pointId).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IContributor contrib = ext.getContributor();
            if (ext.isValid() && this.isVMwareContributor(contrib)) {
                results.add(ext);
            }
            ++n2;
        }
        return results;
    }

    private boolean isVMwareContributor(IContributor contrib) {
        String name = contrib.getName();
        return name.startsWith("com.vmware.") || name.startsWith("com.vsphere.");
    }

    public List<VMwareNewWizardDescription> getVMwareNewWizards() {
        ArrayList<VMwareNewWizardDescription> descriptions = new ArrayList<VMwareNewWizardDescription>();
        List<IExtension> extensions = this.getVMwareExtensions("org.eclipse.ui.newWizards");
        for (IExtension ext : extensions) {
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String elementName = element.getName();
                if (elementName.equals("wizard")) {
                    String iconPath = element.getAttribute("icon");
                    String id = element.getAttribute("id");
                    String name = element.getAttribute("name");
                    String clazz = element.getAttribute("class");
                    ImageDescriptor imgDesc = null;
                    Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)element.getContributor());
                    if (iconPath != null && bundle != null) {
                        imgDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle.getSymbolicName(), (String)iconPath);
                    }
                    descriptions.add(new VMwareNewWizardDescription(id, name, imgDesc, clazz));
                }
                ++n2;
            }
        }
        return descriptions;
    }

    public List<VMwarePopupMenusDescription> getVMwarePopupMenus() {
        ArrayList<VMwarePopupMenusDescription> descriptions = new ArrayList<VMwarePopupMenusDescription>();
        List<IExtension> extensions = this.getVMwareExtensions("org.eclipse.ui.popupMenus");
        for (IExtension ext : extensions) {
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("objectContribution") || element.getName().equals("viewerContribution")) {
                    boolean adaptable = Boolean.parseBoolean(element.getAttribute("adaptable"));
                    String objectClass = element.getAttribute("objectClass");
                    String nameFilter = element.getAttribute("nameFilter");
                    String targetId = element.getAttribute("targetID");
                    IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("action");
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement action = iConfigurationElementArray2[n4];
                        String label = action.getAttribute("label");
                        String clazz = action.getAttribute("class");
                        String id = action.getAttribute("id");
                        String enables = action.getAttribute("enablesFor");
                        String iconPath = action.getAttribute("icon");
                        String style = action.getAttribute("style");
                        ImageDescriptor imgDesc = null;
                        Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)element.getContributor());
                        if (bundle != null && iconPath != null) {
                            imgDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle.getSymbolicName(), (String)iconPath);
                        }
                        descriptions.add(new VMwarePopupMenusDescription(id, label, style, imgDesc, clazz, objectClass, targetId, nameFilter, adaptable, enables, bundle));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return descriptions;
    }

    public List<VMwareEditorDescription> getVMwareEditors() {
        ArrayList<VMwareEditorDescription> descriptions = new ArrayList<VMwareEditorDescription>();
        List<IExtension> extensions = this.getVMwareExtensions("org.eclipse.ui.editors");
        for (IExtension ext : extensions) {
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String elementName = element.getName();
                if (elementName.equals("editor")) {
                    String iconPath = element.getAttribute("icon");
                    String id = element.getAttribute("id");
                    String name = element.getAttribute("name");
                    String exts = element.getAttribute("extensions");
                    String filenames = element.getAttribute("filenames");
                    String clazz = element.getAttribute("class");
                    ImageDescriptor imgDesc = null;
                    Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)element.getContributor());
                    if (iconPath != null && bundle != null) {
                        imgDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle.getSymbolicName(), (String)iconPath);
                    }
                    descriptions.add(new VMwareEditorDescription(id, name, imgDesc, clazz, exts, filenames));
                }
                ++n2;
            }
        }
        return descriptions;
    }
}

