/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.wbis;

import com.vmware.vide.wbis.ExtensionManager;
import com.vmware.vide.wbis.ImageUtil;
import com.vmware.vide.wbis.VMwareNewWizardDescription;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizardsContributionItem
extends ContributionItem {
    public NewWizardsContributionItem() {
    }

    public NewWizardsContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 64, index);
        item.setText("New...");
        Menu subMenu = new Menu(menu);
        item.setMenu(subMenu);
        this.createSubMenuItems(subMenu);
    }

    void createSubMenuItems(Menu menu) {
        List<VMwareNewWizardDescription> wizards = ExtensionManager.INSTANCE.getVMwareNewWizards();
        for (final VMwareNewWizardDescription desc : wizards) {
            final MenuItem item = new MenuItem(menu, 0);
            item.setText(desc.getName());
            item.setImage(ImageUtil.createMenuIconImage(desc.getImageDescriptor()));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWizardDescriptor wd = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(desc.getId());
                    if (wd != null) {
                        NewWizardShortcutAction action = new NewWizardShortcutAction(window, wd);
                        action.run();
                    }
                }
            });
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    item.getImage().dispose();
                }
            });
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

