/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.files.cifs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jcifs.UniAddress;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.services.files.cifs.Activator;
import org.eclipse.rse.internal.services.files.cifs.CIFSHostFile;
import org.eclipse.rse.internal.services.files.cifs.CIFSServiceResources;
import org.eclipse.rse.internal.services.files.cifs.ICIFSService;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.messages.SystemElementNotFoundException;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.clientserver.messages.SystemRemoteSecurityException;
import org.eclipse.rse.services.clientserver.messages.SystemUnsupportedOperationException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;
import org.eclipse.rse.services.files.RemoteFileIOException;

public class CIFSService
extends AbstractFileService
implements ICIFSService,
IFilePermissionsService {
    private transient String userHome;
    private transient String hostname;
    private transient String userId;
    private transient String password;
    private boolean connected;
    private String baseUrl;
    private String prevParentDir;
    private Map<String, CIFSHostFile> prevFiles = new HashMap<String, CIFSHostFile>();
    private long prevTimestamp;
    private static final int BUFFER_SIZE = 4096;
    private static long CACHE_TIMEOUT = 1000L;

    public void upload(InputStream in, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        try {
            try {
                remoteParent = this.fixDir(remoteParent);
                SmbFile file = this.getSmbFile(remoteParent, remoteFile);
                this.copyStream(in, file.getOutputStream(), remoteFile, file.length(), monitor);
                this.clearCache(remoteParent);
            }
            catch (SmbException e) {
                throw new RemoteFileIOException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new RemoteFileIOException((Exception)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void upload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        try {
            this.upload(new FileInputStream(localFile), remoteParent, remoteFile, isBinary, hostEncoding, monitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SystemElementNotFoundException(localFile.getAbsolutePath(), "upload");
        }
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        try {
            SmbFile file = this.getSmbFile(this.fixDir(remoteParent), remoteFile);
            InputStream inputStream = file.getInputStream();
            return inputStream;
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        finally {
            monitor.done();
        }
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        try {
            remoteParent = this.fixDir(remoteParent);
            SmbFile file = this.getSmbFile(remoteParent, remoteFile);
            this.clearCache(remoteParent);
            OutputStream outputStream = file.getOutputStream();
            return outputStream;
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        finally {
            monitor.done();
        }
    }

    public void download(String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        try {
            try {
                if (!localFile.exists()) {
                    File localParentFile = localFile.getParentFile();
                    if (!localParentFile.exists()) {
                        localParentFile.mkdirs();
                    }
                    localFile.createNewFile();
                }
                remoteParent = this.fixDir(remoteParent);
                SmbFile file = this.getSmbFile(remoteParent, remoteFile);
                this.copyStream(file.getInputStream(), new FileOutputStream(localFile), remoteFile, file.length(), monitor);
            }
            catch (SmbException e) {
                throw new RemoteFileIOException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new RemoteFileIOException((Exception)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public String getDescription() {
        return CIFSServiceResources.CIFS_File_Service_Description;
    }

    public String getName() {
        return CIFSServiceResources.CIFS_File_Service_Name;
    }

    public IHostFile getFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileInternal(remoteParent, fileName, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CIFSHostFile getFileInternal(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        Object result;
        if (monitor != null && monitor.isCanceled()) {
            throw new SystemOperationCancelledException();
        }
        remoteParent = this.fixDir(remoteParent);
        Map<String, CIFSHostFile> map = this.prevFiles;
        synchronized (map) {
            long diff;
            if ((this.prevParentDir == null ? remoteParent == null : this.prevParentDir.equals(remoteParent)) && (result = this.prevFiles.get(fileName)) != null && (diff = System.currentTimeMillis() - this.prevTimestamp) < CACHE_TIMEOUT) {
                return (CIFSHostFile)result;
            }
        }
        CIFSHostFile file = null;
        try {
            result = this.prevFiles;
            synchronized (result) {
                this.cacheFiles(remoteParent);
                CIFSHostFile o = this.prevFiles.get(fileName);
                if (o != null) {
                    return o;
                }
            }
            if (file == null && !"*".equals(fileName)) {
                file = new CIFSHostFile(remoteParent, new SmbFile(this.getUrl(remoteParent, fileName)));
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return file;
    }

    private String fixDir(String dir) {
        String result = dir;
        if (!dir.endsWith("/")) {
            result = String.valueOf(result) + "/";
        }
        return result;
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) throws SystemMessageException {
        ArrayList<CIFSHostFile> result = new ArrayList<CIFSHostFile>();
        try {
            SmbFile[] fArr;
            SmbFile files = new SmbFile(this.getUrl());
            SmbFile[] smbFileArray = fArr = files.listFiles();
            int n = fArr.length;
            int n2 = 0;
            while (n2 < n) {
                SmbFile f = smbFileArray[n2];
                result.add(new CIFSHostFile(null, f));
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return result.toArray(new IHostFile[0]);
    }

    public IHostFile getUserHome() {
        if (this.userHome != null) {
            int lastSlash = this.userHome.lastIndexOf(47);
            String name = this.userHome.substring(lastSlash + 1);
            String parent = lastSlash > 0 ? this.userHome.substring(0, lastSlash + 1) : (lastSlash == 0 ? "/" : "");
            try {
                return this.getFile(parent, name, null);
            }
            catch (SystemMessageException systemMessageException) {}
        }
        return null;
    }

    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        try {
            remoteParent = this.fixDir(remoteParent);
            SmbFile file = this.getSmbFile(remoteParent, fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            this.clearCache(remoteParent);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return this.getFile(remoteParent, fileName, monitor);
    }

    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        try {
            remoteParent = this.fixDir(remoteParent);
            SmbFile file = this.getSmbFile(remoteParent, folderName);
            if (!file.exists()) {
                file.mkdir();
            }
            this.clearCache(remoteParent);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return this.getFile(remoteParent, folderName, monitor);
    }

    public void delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        monitor.beginTask(String.valueOf(CIFSServiceResources.CIFS_File_Service_Deleting_Task) + " " + fileName, -1);
        try {
            try {
                SmbFile file = this.getSmbFile(remoteParent, fileName);
                file.delete();
                this.clearCache(remoteParent);
            }
            catch (Exception e) {
                throw new RemoteFileIOException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        this.move(remoteParent, oldName, remoteParent, newName, monitor);
    }

    public void rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) throws SystemMessageException {
        this.rename(remoteParent, oldName, newName, monitor);
        oldFile.renameTo(newName);
    }

    public void move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        try {
            srcParent = this.fixDir(srcParent);
            tgtParent = this.fixDir(tgtParent);
            SmbFile src = this.getSmbFile(srcParent, srcName);
            SmbFile tgt = this.getSmbFile(tgtParent, tgtName);
            src.renameTo(tgt);
            this.clearCache(srcParent);
            this.clearCache(tgtParent);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
    }

    public void copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        try {
            try {
                srcParent = this.fixDir(srcParent);
                tgtParent = this.fixDir(tgtParent);
                SmbFile src = this.getSmbFile(srcParent, srcName);
                SmbFile tgt = this.getSmbFile(tgtParent, tgtName);
                this.copyStream(src.getInputStream(), tgt.getOutputStream(), tgtName, src.length(), monitor);
                this.clearCache(srcParent);
                this.clearCache(tgtParent);
            }
            catch (SmbException e) {
                throw new RemoteFileIOException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new RemoteFileIOException((Exception)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
        int i = 0;
        while (i < srcNames.length) {
            this.copy(srcParents[i], srcNames[i], tgtParent, srcNames[i], monitor);
            ++i;
        }
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public void setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        throw new SystemUnsupportedOperationException(Activator.getContext().getBundle().getSymbolicName(), "setLastModified");
    }

    public void setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        try {
            parent = this.fixDir(parent);
            this.clearCache(parent);
            SmbFile file = this.getSmbFile(parent, name);
            if (readOnly) {
                file.setReadOnly();
            } else {
                file.setReadWrite();
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
    }

    public IHostFilePermissions getFilePermissions(IHostFile file, IProgressMonitor monitor) throws SystemMessageException {
        if (file instanceof IHostFilePermissionsContainer) {
            return ((IHostFilePermissionsContainer)file).getPermissions();
        }
        return null;
    }

    public void setFilePermissions(IHostFile file, IHostFilePermissions permissions, IProgressMonitor monitor) throws SystemMessageException {
        throw new SystemUnsupportedOperationException(Activator.getContext().getBundle().getSymbolicName(), "setFilePermissions");
    }

    public int getCapabilities(IHostFile file) {
        return 39;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null && monitor.isCanceled()) {
            throw new SystemOperationCancelledException();
        }
        parentPath = this.fixDir(parentPath);
        ArrayList<CIFSHostFile> results = new ArrayList<CIFSHostFile>();
        try {
            if (fileFilter == null) {
                fileFilter = "*";
            }
            NamePatternMatcher filematcher = null;
            if (fileFilter.endsWith(",")) {
                String[] types = fileFilter.split(",");
                filematcher = new FileTypeMatcher(types, true);
            } else {
                filematcher = new NamePatternMatcher(fileFilter, true, true);
            }
            Map<String, CIFSHostFile> map = this.prevFiles;
            synchronized (map) {
                this.cacheFiles(parentPath);
                for (CIFSHostFile f : this.prevFiles.values()) {
                    String name = f.getName();
                    if (!this.isRightType(fileType, f) || name.equals(".") || name.equals("..")) continue;
                    if (f.isDirectory() && fileType != 2) {
                        results.add(f);
                        continue;
                    }
                    if (!filematcher.matches(name)) continue;
                    results.add(f);
                }
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() {
        this.connected = false;
        this.clearCache(null);
    }

    public void connect() throws SystemRemoteSecurityException {
        try {
            NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(this.hostname, this.userId, this.password);
            UniAddress domain = UniAddress.getByName((String)this.hostname);
            SmbSession.logon((UniAddress)domain, (NtlmPasswordAuthentication)auth);
            this.userHome = "C$/Users/" + this.userId;
            this.baseUrl = "smb://" + this.userId + ":" + this.password + "@" + this.hostname;
            this.connected = true;
            this.clearCache(null);
        }
        catch (Exception e) {
            throw new SystemRemoteSecurityException(Activator.getContext().getBundle().getSymbolicName(), "authentication", e);
        }
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFiles(String parentPath) throws SmbException, MalformedURLException {
        Map<String, CIFSHostFile> map = this.prevFiles;
        synchronized (map) {
            SmbFile[] fArr;
            this.prevFiles.clear();
            this.prevTimestamp = System.currentTimeMillis();
            this.prevParentDir = parentPath;
            SmbFile files = new SmbFile(this.getUrl(parentPath));
            SmbFile[] smbFileArray = fArr = files.listFiles();
            int n = fArr.length;
            int n2 = 0;
            while (n2 < n) {
                SmbFile f = smbFileArray[n2];
                CIFSHostFile file = new CIFSHostFile(parentPath, f);
                this.prevFiles.put(file.getName(), file);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache(String parentPath) {
        Map<String, CIFSHostFile> map = this.prevFiles;
        synchronized (map) {
            if (parentPath == null || parentPath.equals(this.prevFiles)) {
                this.prevFiles.clear();
            }
        }
    }

    private String getUrl() {
        return this.baseUrl;
    }

    private String getUrl(String parentPath) {
        return String.valueOf(this.getUrl()) + "/" + parentPath;
    }

    private String getUrl(String parentPath, String fileName) {
        return String.valueOf(this.getUrl(parentPath)) + "/" + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmbFile getSmbFile(String parentDir, String fileName) {
        SmbFile f = null;
        Map<String, CIFSHostFile> map = this.prevFiles;
        synchronized (map) {
            CIFSHostFile hostFile;
            if ((this.prevParentDir == null ? parentDir == null : this.prevParentDir.equals(parentDir)) && (hostFile = this.prevFiles.get(fileName)) != null) {
                f = hostFile.getSMBFile();
            }
        }
        if (f == null) {
            try {
                f = new SmbFile(this.getUrl(parentDir, fileName));
            }
            catch (Exception exception) {}
        }
        return f;
    }

    private void copyStream(InputStream in, OutputStream out, String fileName, long fileLength, IProgressMonitor monitor) throws IOException, SystemOperationCancelledException {
        try {
            int n;
            byte[] b = new byte[4096];
            int i = 0;
            int inc = 409600;
            monitor.beginTask(fileName, (int)fileLength);
            while ((n = in.read(b)) > 0) {
                out.write(b, 0, n);
                if ((i += n) % inc == 0) {
                    monitor.worked(inc);
                }
                if (!monitor.isCanceled()) continue;
                throw new SystemOperationCancelledException();
            }
            out.close();
            in.close();
        }
        finally {
            monitor.done();
        }
    }
}

