/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor;

import com.vmware.vide.vxmleditor.multipageeditor.XMLPageEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class XMLRemoveListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                if (delta.getKind() != 2) {
                    return true;
                }
                final IResource resource = delta.getResource();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        List<XMLPageEditor> vXMLEditors = XMLRemoveListener.this.getAllOpenvXMLEditors();
                        int i = 0;
                        while (i < vXMLEditors.size()) {
                            if (vXMLEditors.get(i).getFileName().equals(resource.getFullPath().toOSString())) {
                                page.closeEditor((IEditorPart)vXMLEditors.get(i), false);
                                break;
                            }
                            ++i;
                        }
                    }
                });
                return true;
            }
        };
        try {
            rootDelta.accept(visitor);
        }
        catch (CoreException coreException) {}
    }

    public List<XMLPageEditor> getAllOpenvXMLEditors() {
        ArrayList<XMLPageEditor> openXMLEditorList = new ArrayList<XMLPageEditor>();
        IWorkbenchWindow[] myWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < myWindows.length) {
            IWorkbenchPage myPage = myWindows[i].getActivePage();
            IEditorReference[] myRefs = myPage.getEditorReferences();
            int j = 0;
            while (j < myRefs.length) {
                IEditorPart myPart = myRefs[j].getEditor(false);
                if (myPart instanceof XMLPageEditor) {
                    openXMLEditorList.add((XMLPageEditor)myPart);
                }
                ++j;
            }
            ++i;
        }
        return openXMLEditorList;
    }
}

