/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.editors;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class MarkingErrorHandler
implements ErrorHandler {
    public IResource file;
    public String editorContents;
    private int charstart;
    private int charend;

    public MarkingErrorHandler(IResource f, String editorcontents) {
        this.file = f;
        this.editorContents = editorcontents;
        this.charstart = 0;
        this.charend = 0;
    }

    @Override
    public void error(SAXParseException exception) {
        try {
            this.handleError(exception, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
        try {
            this.handleError(exception, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void warning(SAXParseException exception) {
    }

    public void getLineCharOffsets(int linenumber, int columnNumber) {
        try {
            int offset = 0;
            int i = 0;
            while (i < linenumber - 1) {
                offset = this.editorContents.indexOf(10, offset + 1);
                ++i;
            }
            int endofLineIndex = this.editorContents.indexOf(10, offset + 1);
            if (endofLineIndex < 0) {
                endofLineIndex = this.editorContents.length();
            }
            String finalLine = this.editorContents.substring(offset, endofLineIndex);
            int j = 1;
            while (j < finalLine.length()) {
                if (finalLine.charAt(j) != ' ') {
                    this.charstart = offset + j;
                    break;
                }
                ++j;
            }
            this.charend = offset + finalLine.length();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleError(SAXParseException e, boolean isFatal) {
        int lineNumber = e.getLineNumber();
        int columnNumber = e.getColumnNumber();
        HashMap<String, Object> map = new HashMap<String, Object>();
        MarkerUtilities.setLineNumber(map, (int)(lineNumber + 1));
        this.getLineCharOffsets(lineNumber, columnNumber);
        if (this.charstart == -1) {
            return;
        }
        MarkerUtilities.setCharStart(map, (int)this.charend);
        MarkerUtilities.setCharEnd(map, (int)this.charstart);
        MarkerUtilities.setMessage(map, (String)e.getMessage());
        map.put("message", e.getMessage());
        map.put("location", this.file.getFullPath().toString());
        map.put("severity", new Integer(2));
        try {
            MarkerUtilities.createMarker((IResource)this.file, map, (String)"org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException ee) {
            ee.printStackTrace();
        }
    }
}

