/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.model;

import com.vmware.vide.vxmleditor.Activator;
import com.vmware.vide.vxmleditor.Schema;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Node;

public class XMLData {
    public static final String BOOLEAN_TRUE = "true";
    public static final String BOOLEAN_FALSE = "false";
    protected static final String GROUP_ELEMENT = "group";
    protected XMLData parent;
    protected Schema.Elem schemaelement;
    protected Node xmlnode;
    protected ImageDescriptor imagedesc;
    protected Image image;
    protected boolean isremovable;

    public XMLData(XMLData parent, Schema.Elem element, Node node) {
        this.parent = parent;
        this.schemaelement = element;
        this.xmlnode = node;
        this.imagedesc = this.xmlnode != null ? this.getImageDescriptor(this.xmlnode) : null;
        this.image = this.imagedesc != null ? this.imagedesc.createImage() : null;
        this.isremovable = true;
    }

    public XMLData(XMLData parent, Schema schema, Node node) {
        this(parent, XMLData.getSchemaElement(parent, schema, node), node);
    }

    public Schema getSchema() {
        return this.parent.getSchema();
    }

    public Node getNode() {
        return this.xmlnode;
    }

    public String getText() {
        return this.xmlnode != null ? this.xmlnode.getNodeName() : "";
    }

    public Object getParentNode() {
        return this.xmlnode.getParentNode();
    }

    public Schema.Elem getSchemaElement() {
        return this.schemaelement;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imagedesc;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isBoolean() {
        return this.schemaelement != null && this.schemaelement.getType() != null ? this.schemaelement.getType().isBoolean : false;
    }

    public boolean isEnum() {
        return this.schemaelement != null && this.schemaelement.getType() != null ? this.schemaelement.getType().isEnum : false;
    }

    public boolean isRemovable() {
        return this.isremovable;
    }

    public void setRemovable(boolean removable) {
        this.isremovable = removable;
    }

    public String[] getEnumValues() {
        Schema.Type type;
        if (this.isEnum() && (type = this.schemaelement.getType()) != null && type.values != null) {
            return type.values.toArray(new String[type.values.size()]);
        }
        return new String[0];
    }

    public boolean getBooleanValue() {
        if (this.isBoolean()) {
            return this.getBooleanValue(this.xmlnode.getNodeValue());
        }
        return false;
    }

    protected Schema.Elem[] getSchemaChildrenElements() {
        Schema.Type type;
        if (this.schemaelement != null && (type = this.schemaelement.getType()) != null && type.elems != null) {
            return type.elems.toArray(new Schema.Elem[type.elems.size()]);
        }
        return null;
    }

    protected static Schema.Elem getSchemaElement(XMLData parent, Schema schema, Node node) {
        if (schema != null) {
            Schema.Elem[] elements;
            Schema.Elem[] elemArray = elements = parent != null ? parent.getSchemaChildrenElements() : null;
            if (elements == null) {
                elements = schema.getRootElements();
            }
            if (elements != null) {
                return XMLData.getElement(node.getNodeName(), elements);
            }
        }
        return null;
    }

    protected static Schema.Elem getElement(String elemname, Schema.Elem[] elements) {
        Schema.Elem[] elemArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Schema.Elem elem;
            Schema.Type grouptype;
            Schema.Elem element = elemArray[n2];
            if (element.getName().equals(elemname)) {
                return element;
            }
            if (element.getTagType() != null && element.getTagType().equals(GROUP_ELEMENT) && (grouptype = element.getType()) != null && (elem = XMLData.getElement(elemname, grouptype.elems.toArray(new Schema.Elem[grouptype.elems.size()]))) != null) {
                return elem;
            }
            ++n2;
        }
        return null;
    }

    public final boolean getBooleanValue(String value) {
        if (value == null) {
            return false;
        }
        if (value.equals(BOOLEAN_TRUE)) {
            return true;
        }
        if (value.equals(BOOLEAN_FALSE)) {
            return false;
        }
        try {
            return Integer.getInteger(value) == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private ImageDescriptor getImageDescriptor(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return Activator.getDefault().getImageDescriptor("element_obj.gif");
            }
            case 2: {
                return Activator.getDefault().getImageDescriptor("attribute_obj.gif");
            }
            case 4: {
                return Activator.getDefault().getImageDescriptor("cdatasection.gif");
            }
            case 5: 
            case 6: {
                return Activator.getDefault().getImageDescriptor("entity.gif");
            }
            case 7: {
                return Activator.getDefault().getImageDescriptor("proinst_obj.gif");
            }
            case 8: {
                return Activator.getDefault().getImageDescriptor("comment_obj.gif");
            }
            case 10: {
                return Activator.getDefault().getImageDescriptor("doctype.gif");
            }
            case 12: {
                return Activator.getDefault().getImageDescriptor("notation.gif");
            }
        }
        return Activator.getDefault().getImageDescriptor("text.gif");
    }
}

