/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.model;

import com.vmware.vide.vxmleditor.Schema;
import com.vmware.vide.vxmleditor.editors.XMLEditor;
import com.vmware.vide.vxmleditor.editors.myEntityResolver;
import com.vmware.vide.vxmleditor.model.IXMLDataModelListener;
import com.vmware.vide.vxmleditor.model.XMLNode;
import com.vmware.vide.vxmleditor.model.XMLRootData;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLDataModel {
    private Schema schema;
    private File schemafile;
    private XMLRootData xmldata;
    private XMLEditor baseeditor;
    private IEditorInput editorinput;
    private List<IXMLDataModelListener> listeners;
    private boolean isupdated;

    public XMLDataModel(File schemafile) {
        if (schemafile != null) {
            this.schemafile = schemafile;
            this.schema = this.getSchema(schemafile);
        }
        this.listeners = new ArrayList<IXMLDataModelListener>();
    }

    private Schema getSchema(File file) {
        try {
            Schema schema = new Schema();
            schema.parseXml(file);
            return schema;
        }
        catch (SAXException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void addModelListener(IXMLDataModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeModelListener(IXMLDataModelListener listener) {
        this.listeners.remove(listener);
    }

    public void fireModelChanged(int type, Object data) {
        if (type == 2 || type == 4 || type == 5) {
            this.isupdated = true;
        } else if (type == 3 || type == 1) {
            this.isupdated = false;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).modelChanged(type, data);
            ++i;
        }
    }

    public boolean isDataChanged() {
        return this.isupdated;
    }

    public XMLNode[] getElements() {
        if (this.xmldata != null) {
            return this.xmldata.getChildren(true);
        }
        return new XMLNode[0];
    }

    public void setInput(XMLEditor editor, IEditorInput input, File schemafile) {
        IDocument textdocument;
        if (editor == null || input == null) {
            return;
        }
        this.editorinput = input;
        this.baseeditor = editor;
        if (schemafile != null && this.schemafile != schemafile) {
            this.schemafile = schemafile;
            this.schema = this.getSchema(schemafile);
            if (this.baseeditor != null) {
                this.baseeditor.setXSDFile(schemafile.getAbsolutePath());
            }
        }
        if ((textdocument = editor.getDocumentProvider().getDocument((Object)input)) != null) {
            Document xmldocument = null;
            xmldocument = this.getDocument(textdocument.get(), XMLDataModel.getFile(input).getParent(), false);
            if (xmldocument != null) {
                this.xmldata = new XMLRootData(this, this.schema, (Node)xmldocument);
            }
        }
        this.fireModelChanged(1, this.xmldata);
    }

    public Document getDocument(String input, String schemaPath, boolean ignorecomment) {
        if (input != null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            String originalEnvValue = this.setEnvVariable(schemaPath);
            try {
                Document doc;
                DocumentBuilder db = dbf.newDocumentBuilder();
                if (ignorecomment) {
                    dbf.setIgnoringComments(true);
                }
                db.setEntityResolver(new myEntityResolver());
                ByteArrayInputStream inputstream = new ByteArrayInputStream(input.getBytes());
                Document document = doc = db.parse(inputstream);
                return document;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            finally {
                this.resetEnvVariable(originalEnvValue);
            }
        }
        return null;
    }

    private String setEnvVariable(String schemaPath) {
        String originalPath = System.getProperty("user.dir");
        System.setProperty("user.dir", schemaPath);
        return originalPath;
    }

    private void resetEnvVariable(String originalValue) {
        System.setProperty("user.dir", originalValue);
    }

    public void updateBaseDocuemnt() {
        if (this.baseeditor != null && this.editorinput != null && this.xmldata != null) {
            String doctext = this.xmldata.getDocumentText();
            this.baseeditor.getDocumentProvider().getDocument((Object)this.editorinput).set(doctext);
        }
    }

    public void doSave() {
        this.updateBaseDocuemnt();
        this.fireModelChanged(3, null);
    }

    public XMLNode[] getNodes(String nodestring) {
        if (this.xmldata != null) {
            return this.xmldata.getNodesFromFullNodeText(nodestring);
        }
        return new XMLNode[0];
    }

    public static File getFile(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return fileInput.getFile().getLocation().toFile();
        }
        if (input instanceof IStorageEditorInput) {
            IStorageEditorInput storageFileInput = (IStorageEditorInput)input;
            try {
                return storageFileInput.getStorage().getFullPath().toFile();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

