/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.multipageeditor;

import com.vmware.vide.vxmleditor.Activator;
import com.vmware.vide.vxmleditor.Schema;
import com.vmware.vide.vxmleditor.model.XMLAttribute;
import com.vmware.vide.vxmleditor.model.XMLDataModel;
import com.vmware.vide.vxmleditor.model.XMLNode;
import com.vmware.vide.vxmleditor.multipageeditor.XMLTreeBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class XMLDetailsBlock
implements IDetailsPage {
    public static final String DEF_TITLE = "Properties";
    private static final ILog logger = Activator.getDefault().getLog();
    private IManagedForm mform;
    private FormToolkit toolkit;
    private final XMLNode xmldata;
    private final XMLTreeBlock parent;
    private final ArrayList<UIBlock> uiblocks;
    private final String title;
    private final String description;

    public XMLDetailsBlock(XMLTreeBlock block, XMLNode data, String title, String description) {
        this.parent = block;
        this.xmldata = data;
        this.title = title;
        this.description = description;
        this.uiblocks = new ArrayList();
    }

    public XMLDataModel getDataModel() {
        return this.parent.getDataModel();
    }

    private String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.xmldata != null) {
            return String.valueOf(this.xmldata.getText()) + " " + DEF_TITLE;
        }
        return DEF_TITLE;
    }

    public void initialize(IManagedForm mform) {
        this.mform = mform;
    }

    public void createContents(Composite parent) {
        this.toolkit = this.mform.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 2;
        layout.rightMargin = 2;
        parent.setLayout((Layout)layout);
        Section section = this.toolkit.createSection(parent, 128);
        section.marginWidth = 10;
        section.setText(this.getTitle());
        section.setDescription(this.description != null ? this.description : "");
        TableWrapData desclayout = new TableWrapData(128, 16);
        desclayout.grabHorizontal = true;
        section.setLayoutData((Object)desclayout);
        this.toolkit.createCompositeSeparator((Composite)section);
        Composite composite = this.createUIBlocks(section);
        if (composite != null) {
            section.setClient((Control)composite);
        }
    }

    private Composite createUIBlocks(Section section) {
        Composite composite;
        block5: {
            composite = this.toolkit.createComposite((Composite)section);
            GridLayout glayout = new GridLayout();
            glayout.marginHeight = this.toolkit.getBorderStyle() == 2048 ? 0 : 2;
            glayout.marginWidth = glayout.marginHeight;
            glayout.numColumns = 2;
            composite.setLayout((Layout)glayout);
            if (this.xmldata.isBoolean() || this.xmldata.isEnum() || this.xmldata.hasText()) {
                this.uiblocks.add(new UIBlock(composite));
            }
            if (this.xmldata.getAttributes().size() <= 0) break block5;
            List<Schema.Elem> attrsInSchema = this.xmldata.getSchemaAttributes();
            if (attrsInSchema != null) {
                Map<String, XMLAttribute> attrs = this.xmldata.getAttributes();
                for (Schema.Elem e : attrsInSchema) {
                    XMLAttribute attr = attrs.get(e.getName());
                    this.uiblocks.add(new UIBlock(composite, attr));
                }
            } else {
                Map<String, XMLAttribute> attrs = this.xmldata.getAttributes();
                for (XMLAttribute attr : attrs.values()) {
                    this.uiblocks.add(new UIBlock(composite, attr));
                }
            }
        }
        return composite;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        this.updateMessage();
    }

    public void dispose() {
    }

    public boolean isDirty() {
        return this.parent.getDesignPage().isDirty();
    }

    public void commit(boolean onSave) {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void setFocus() {
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        for (UIBlock block : this.uiblocks) {
            block.refresh();
        }
    }

    private void updateMessage() {
        this.mform.getMessageManager().removeAllMessages();
        for (UIBlock block : this.uiblocks) {
            if (block.type != 1) continue;
            block.verifyText();
        }
    }

    public class UIBlock {
        private static final int TYPE_TEXT = 1;
        private static final int TYPE_CHECKBOX = 2;
        private static final int TYPE_COMBO = 3;
        private static final String KEY_REQUIRED = ".required";
        private static final String KEY_PATTERN = ".pattern";
        private static final String KEY_MAXLENGTH = ".maxLength";
        private static final int DEFAULT_MAX_TEXT_LENGTH = 255;
        private static final String NONE_COMBOTEXT = "None";
        private final int type;
        private final XMLAttribute attribute;
        private Text text;
        private ComboPart combo;
        private Button button;
        private String previoustextvalue;
        private Boolean previousbooleanvalue;
        private Label label;

        public UIBlock(Composite composite, XMLAttribute attr) {
            this.attribute = attr;
            this.type = this.getUIType();
            if (this.type == 1) {
                this.createLabelText(composite);
            } else if (this.type == 2) {
                this.createCheckboxButton(composite);
            } else if (this.type == 3) {
                this.createCombo(composite);
            }
        }

        public UIBlock(Composite composite) {
            this(composite, null);
        }

        public void refresh() {
            if (this.type == 1) {
                this.text.setText(this.getTextValue());
            } else if (this.type == 3) {
                this.combo.setText(this.getTextValue().isEmpty() ? NONE_COMBOTEXT : this.getTextValue());
            } else if (this.type == 2) {
                this.button.setSelection(this.getBooleanValue());
            }
        }

        public String getText() {
            return this.attribute != null ? this.attribute.getName() : XMLDetailsBlock.this.xmldata.getText();
        }

        public String getTextValue() {
            return this.attribute != null ? this.attribute.getValue() : XMLDetailsBlock.this.xmldata.getTextNodeValue();
        }

        public boolean getBooleanValue() {
            return this.attribute != null ? this.attribute.getBooleanValue() : XMLDetailsBlock.this.xmldata.getBooleanValue();
        }

        public String[] getComboValue() {
            String[] values;
            String[] stringArray = values = this.attribute != null ? this.attribute.getEnumValues() : XMLDetailsBlock.this.xmldata.getEnumValues();
            if (this.attribute != null && this.attribute.getSchemaElement().isRequired() || !XMLDetailsBlock.this.xmldata.getSchemaElement().isOptional()) {
                return values;
            }
            String[] valueswithnone = new String[values.length + 1];
            valueswithnone[0] = NONE_COMBOTEXT;
            int i = 0;
            while (i < values.length) {
                valueswithnone[i + 1] = values[i];
                ++i;
            }
            return valueswithnone;
        }

        public Object getData() {
            return this.attribute != null ? this.attribute : XMLDetailsBlock.this.xmldata;
        }

        private int getUIType() {
            if (this.attribute != null) {
                return this.attribute.isBoolean() ? 2 : (this.attribute.isEnum() ? 3 : 1);
            }
            return XMLDetailsBlock.this.xmldata.isBoolean() ? 2 : (XMLDetailsBlock.this.xmldata.isEnum() ? 3 : 1);
        }

        private void createLabelText(Composite composite) {
            Label strlabel = XMLDetailsBlock.this.toolkit.createLabel(composite, String.valueOf(this.getText()) + ":");
            strlabel.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
            this.label = strlabel;
            this.text = XMLDetailsBlock.this.toolkit.createText(composite, this.getTextValue(), 2048);
            GridData griddata = new GridData(4, 0, true, true);
            griddata.widthHint = 100;
            this.text.setLayoutData((Object)griddata);
            this.previoustextvalue = this.getTextValue();
            this.text.setText(this.previoustextvalue);
            this.verifyText();
            this.text.setData(this.getData());
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!UIBlock.this.previoustextvalue.equals(UIBlock.this.text.getText())) {
                        XMLDetailsBlock.this.xmldata.updated(UIBlock.this.text.getData(), UIBlock.this.text.getText());
                        UIBlock.this.previoustextvalue = UIBlock.this.text.getText();
                        XMLDetailsBlock.this.updateMessage();
                        XMLDetailsBlock.this.parent.getDesignPage().setDirty();
                        XMLDetailsBlock.this.parent.getDesignPage().firePropertyChange();
                    }
                }
            });
        }

        private void verifyText() {
            String maxLen;
            String pattern;
            IMessageManager mm = XMLDetailsBlock.this.mform.getMessageManager();
            if (this.isRequired()) {
                String key = String.valueOf(this.label.getText()) + KEY_REQUIRED;
                if (this.text.getText().isEmpty()) {
                    String msg = "The text is empty.";
                    mm.addMessage((Object)key, msg, null, 3, (Control)this.text);
                } else {
                    mm.removeMessage((Object)key, (Control)this.text);
                }
            }
            if ((pattern = this.getAttributeTypeProperty("xs:pattern")) != null) {
                String key = String.valueOf(this.label.getText()) + KEY_PATTERN;
                if (this.text.getText().matches(pattern)) {
                    mm.removeMessage((Object)key, (Control)this.text);
                } else {
                    String msg = String.format("The text [%s] does not match with the pattern [%s].", this.text.getText(), pattern);
                    mm.addMessage((Object)key, msg, null, 3, (Control)this.text);
                }
            }
            if ((maxLen = this.getAttributeTypeProperty("xs:maxLength")) != null) {
                String msg;
                int len;
                try {
                    len = Integer.parseInt(maxLen);
                }
                catch (NumberFormatException e) {
                    len = 255;
                    msg = String.format("Bad form [%s] for maxLength in the schema, use default maximum length [%d].", maxLen, len);
                    logger.log((IStatus)new Status(4, "com.vmware.vide.vxmleditor", msg, (Throwable)e));
                }
                if (maxLen != null) {
                    String key = String.valueOf(this.label.getText()) + KEY_MAXLENGTH;
                    if (this.text.getText().length() > len) {
                        msg = String.format("The text exceeds the maximum length [%s].", this.text.getText(), maxLen);
                        mm.addMessage((Object)key, msg, null, 3, (Control)this.text);
                    } else {
                        mm.removeMessage((Object)key, (Control)this.text);
                    }
                }
            }
        }

        private boolean isRequired() {
            if (this.attribute == null) {
                return false;
            }
            return this.attribute.getSchemaElement().isRequired();
        }

        private String getAttributeTypeProperty(String key) {
            if (this.attribute == null) {
                return null;
            }
            if (this.attribute.getSchemaElement().getType() == null) {
                return null;
            }
            return this.attribute.getSchemaElement().getType().properties.get(key);
        }

        private void createCheckboxButton(Composite composite) {
            this.button = XMLDetailsBlock.this.toolkit.createButton(composite, this.getText(), 32);
            GridData griddata = new GridData(4, 0x1000000, true, true);
            griddata.widthHint = 100;
            griddata.horizontalSpan = 2;
            this.button.setLayoutData((Object)griddata);
            this.button.setData(this.getData());
            this.previousbooleanvalue = this.getBooleanValue();
            this.button.setSelection(this.previousbooleanvalue.booleanValue());
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (UIBlock.this.previousbooleanvalue.booleanValue() != UIBlock.this.button.getSelection()) {
                        XMLDetailsBlock.this.xmldata.updated(UIBlock.this.button.getData(), UIBlock.this.button.getSelection() ? "true" : "false");
                        UIBlock.this.previousbooleanvalue = UIBlock.this.button.getSelection();
                        XMLDetailsBlock.this.parent.getDesignPage().setDirty();
                        XMLDetailsBlock.this.parent.getDesignPage().firePropertyChange();
                    }
                }
            });
        }

        private void createCombo(Composite composite) {
            Label strlabel = XMLDetailsBlock.this.toolkit.createLabel(composite, String.valueOf(this.getText()) + ":");
            strlabel.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
            this.combo = new ComboPart();
            this.combo.createControl(composite, XMLDetailsBlock.this.toolkit, 2056);
            GridData griddata = new GridData(4, 0, true, true);
            griddata.widthHint = 100;
            this.combo.getControl().setLayoutData((Object)griddata);
            this.combo.getControl().setData(this.getData());
            this.combo.setItems(this.getComboValue());
            this.previoustextvalue = this.getTextValue().isEmpty() ? this.combo.getItems()[0] : this.getTextValue();
            this.combo.setText(this.previoustextvalue);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!UIBlock.this.previoustextvalue.equals(UIBlock.this.combo.getSelection())) {
                        XMLDetailsBlock.this.xmldata.updated(UIBlock.this.combo.getControl().getData(), UIBlock.this.combo.getSelection().equals(UIBlock.NONE_COMBOTEXT) ? "" : UIBlock.this.combo.getSelection());
                        XMLDetailsBlock.this.parent.getDesignPage().setDirty();
                        XMLDetailsBlock.this.parent.getDesignPage().firePropertyChange();
                    }
                }
            });
        }

        public class ComboPart {
            protected Control combo;

            public void addSelectionListener(SelectionListener listener) {
                if (this.combo instanceof Combo) {
                    ((Combo)this.combo).addSelectionListener(listener);
                } else {
                    ((CCombo)this.combo).addSelectionListener(listener);
                }
            }

            public int indexOf(String item) {
                if (this.combo instanceof Combo) {
                    return ((Combo)this.combo).indexOf(item);
                }
                return ((CCombo)this.combo).indexOf(item);
            }

            public void addModifyListener(ModifyListener listener) {
                if (this.combo instanceof Combo) {
                    ((Combo)this.combo).addModifyListener(listener);
                } else {
                    ((CCombo)this.combo).addModifyListener(listener);
                }
            }

            public void createControl(Composite parent, FormToolkit toolkit, int style) {
                this.combo = toolkit.getBorderStyle() == 2048 ? new Combo(parent, style | 0x800) : new CCombo(parent, style | 0x800000);
                toolkit.adapt(this.combo, true, false);
            }

            public Control getControl() {
                return this.combo;
            }

            public int getSelectionIndex() {
                if (this.combo instanceof Combo) {
                    return ((Combo)this.combo).getSelectionIndex();
                }
                return ((CCombo)this.combo).getSelectionIndex();
            }

            public void add(String item, int index) {
                if (this.combo instanceof Combo) {
                    ((Combo)this.combo).add(item, index);
                } else {
                    ((CCombo)this.combo).add(item, index);
                }
            }

            public void add(String item) {
                if (this.combo instanceof Combo) {
                    ((Combo)this.combo).add(item);
                } else {
                    ((CCombo)this.combo).add(item);
                }
            }

            public void remove(int index) {
                if (index < 0 || index >= this.getItemCount()) {
                    return;
                }
                if (this.combo instanceof Combo) {
                    ((Combo)this.combo).remove(index);
                } else {
                    ((CCombo)this.combo).remove(index);
                }
            }

            public void select(int index) {
                if (this.combo instanceof Combo) {
                    ((Combo)this.combo).select(index);
                } else {
                    ((CCombo)this.combo).select(index);
                }
            }

            public String getSelection() {
                if (this.combo instanceof Combo) {
                    return ((Combo)this.combo).getText().trim();
                }
                return ((CCombo)this.combo).getText().trim();
            }

            public void setText(String text) {
                if (this.combo instanceof Combo) {
                    ((Combo)this.combo).setText(text);
                } else {
                    ((CCombo)this.combo).setText(text);
                }
            }

            public void setItems(String[] items) {
                if (this.combo instanceof Combo) {
                    ((Combo)this.combo).setItems(items);
                } else {
                    ((CCombo)this.combo).setItems(items);
                }
            }

            public void setEnabled(boolean enabled) {
                if (this.combo instanceof Combo) {
                    ((Combo)this.combo).setEnabled(enabled);
                } else {
                    ((CCombo)this.combo).setEnabled(enabled);
                }
            }

            public int getItemCount() {
                if (this.combo instanceof Combo) {
                    return ((Combo)this.combo).getItemCount();
                }
                return ((CCombo)this.combo).getItemCount();
            }

            public String[] getItems() {
                if (this.combo instanceof Combo) {
                    return ((Combo)this.combo).getItems();
                }
                return ((CCombo)this.combo).getItems();
            }

            public void setVisibleItemCount(int count) {
                if (this.combo instanceof Combo) {
                    ((Combo)this.combo).setVisibleItemCount(count);
                } else {
                    ((CCombo)this.combo).setVisibleItemCount(count);
                }
            }
        }
    }
}

