/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.multipageeditor;

import com.vmware.vide.vxmleditor.Activator;
import com.vmware.vide.vxmleditor.model.IXMLDataModelListener;
import com.vmware.vide.vxmleditor.model.XMLData;
import com.vmware.vide.vxmleditor.model.XMLDataModel;
import com.vmware.vide.vxmleditor.model.XMLLabelProvider;
import com.vmware.vide.vxmleditor.model.XMLNode;
import com.vmware.vide.vxmleditor.model.XMLTreeContentProvider;
import com.vmware.vide.vxmleditor.multipageeditor.XMLDesignPage;
import com.vmware.vide.vxmleditor.multipageeditor.XMLDetailsBlock;
import com.vmware.vide.vxmleditor.multipageeditor.XMLPageEditor;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class XMLTreeBlock
extends MasterDetailsBlock {
    public static final String DEF_TITLE = "XML Objects";
    public static final String DEF_DESCRIPTION = "The tree contains objects from the model whose details are editable on the right";
    public static final int DEF_TREE_EXPAND_LEVEL = 3;
    private final XMLDesignPage page;
    private final String title;
    private final String description;
    private TreeViewer treeviewer;
    private final Map<String, String> nodedescriptions;
    private final String detailspagetitle;
    private String previousnodestring;

    public XMLTreeBlock(XMLDesignPage page, String title, String description, String detailspagetitle, Map<String, String> nodedescriptions) {
        this.page = page;
        this.title = title;
        this.description = description;
        this.detailspagetitle = detailspagetitle;
        this.nodedescriptions = nodedescriptions;
    }

    public XMLTreeBlock(XMLDesignPage page) {
        this(page, DEF_TITLE, DEF_DESCRIPTION, "Properties", null);
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 128);
        section.setText(this.title);
        section.setDescription(this.description);
        section.marginWidth = 10;
        section.marginHeight = 5;
        toolkit.createCompositeSeparator((Composite)section);
        Composite composite = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        composite.setLayout((Layout)layout);
        Tree tree = toolkit.createTree(composite, 0);
        GridData griddata = new GridData(1808);
        griddata.heightHint = 20;
        griddata.widthHint = 100;
        tree.setLayoutData((Object)griddata);
        toolkit.paintBordersFor(composite);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.treeviewer = new TreeViewer(tree);
        this.treeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
                XMLNode data = XMLTreeBlock.this.getSelection();
                if (data != null) {
                    XMLTreeBlock.this.previousnodestring = XMLTreeBlock.this.getSelection().getFullNodeText();
                }
            }
        });
        MenuManager popups = new MenuManager("#PopupMenu");
        popups.setRemoveAllWhenShown(true);
        popups.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                XMLTreeBlock.this.addPopupMenus(manager, XMLTreeBlock.this.getSelection());
            }
        });
        Menu popupmenu = popups.createContextMenu(this.treeviewer.getControl());
        this.treeviewer.getControl().setMenu(popupmenu);
        this.treeviewer.setContentProvider((IContentProvider)new XMLTreeContentProvider());
        this.treeviewer.setLabelProvider((IBaseLabelProvider)new XMLLabelProvider());
        this.treeviewer.setInput(this.page.getXMLTreeInput());
        section.setClient((Control)composite);
        this.treeviewer.expandToLevel(3);
    }

    public TreeViewer getTreeViewer() {
        return this.treeviewer;
    }

    public XMLDesignPage getDesignPage() {
        return this.page;
    }

    public void firePropertyChange() {
        FormEditor editor = this.page.getEditor();
        if (editor instanceof XMLPageEditor) {
            ((XMLPageEditor)editor).firePropertyChange();
        }
    }

    public IXMLDataModelListener getXMLModelListener() {
        return new IXMLDataModelListener(){

            @Override
            public void modelChanged(int type, Object data) {
                if (type == 1) {
                    XMLTreeBlock.this.refresh();
                }
            }
        };
    }

    public String getDescription(XMLNode data) {
        if (this.nodedescriptions != null && !this.nodedescriptions.containsKey(data.getText())) {
            return this.nodedescriptions.get(data.getText());
        }
        return data.getDescriptionFromSchema();
    }

    public void refresh() {
        Object[] nodes;
        if (this.treeviewer == null) {
            return;
        }
        this.treeviewer.refresh();
        if (this.previousnodestring != null && (nodes = this.getDataModel().getNodes(this.previousnodestring)) != null && nodes.length > 0) {
            this.treeviewer.setExpandedElements(nodes);
            Object[] selection = new XMLNode[]{nodes[nodes.length - 1]};
            this.treeviewer.setSelection((ISelection)new StructuredSelection(selection), true);
        }
    }

    public XMLDataModel getDataModel() {
        return this.page.getDataModel();
    }

    private XMLNode getSelection() {
        TreeItem[] selections = this.treeviewer.getTree().getSelection();
        if (selections.length > 0 && selections[0].getData() instanceof XMLNode) {
            return (XMLNode)selections[0].getData();
        }
        return null;
    }

    private void addPopupMenus(IMenuManager manager, XMLNode data) {
        Object[] schemaelements;
        Object[] objectArray = schemaelements = data.getSchemaElements();
        int n = schemaelements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            manager.add((IAction)new AppendAction(data, element));
            ++n2;
        }
        if (data.isRemovable()) {
            manager.add((IAction)new DeleteAction(data));
        }
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        Action haction = new Action("Horizontal", 8){

            public void run() {
                XMLTreeBlock.this.sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        haction.setChecked(true);
        haction.setToolTipText("Horizontal orientation");
        haction.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("toolbar_horizontal.gif"));
        Action vaction = new Action("Vertical", 8){

            public void run() {
                XMLTreeBlock.this.sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        vaction.setChecked(false);
        vaction.setToolTipText("Vertical orientation");
        vaction.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("toolbar_vertical.gif"));
        form.getToolBarManager().add((IAction)haction);
        form.getToolBarManager().add((IAction)vaction);
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageProvider((IDetailsPageProvider)new DetailsPageProvider(this));
    }

    private class AppendAction
    extends Action {
        private static final String MENU_ADD = "Add ";
        private final XMLNode data;
        private final Object schemaelement;

        public AppendAction(XMLNode data, Object schemaelement) {
            this.setText(MENU_ADD + XMLNode.getSchemaName(schemaelement));
            this.setImageDescriptor(data.getImageDescriptor());
            this.data = data;
            this.schemaelement = schemaelement;
        }

        public void run() {
            this.data.appendChildNode(this.schemaelement);
            XMLTreeBlock.this.page.setDirty();
            XMLTreeBlock.this.treeviewer.refresh();
        }
    }

    private class DeleteAction
    extends Action {
        private static final String MENU_DELETE = "Delete";
        private final XMLNode data;

        public DeleteAction(XMLNode data) {
            this.setText(MENU_DELETE);
            this.data = data;
        }

        public void run() {
            XMLData parent = this.data.getParentData();
            if (parent instanceof XMLNode) {
                ((XMLNode)parent).removeChildNode(this.data);
                XMLTreeBlock.this.page.setDirty();
                XMLTreeBlock.this.treeviewer.refresh();
            }
        }
    }

    public class DetailsPageProvider
    implements IDetailsPageProvider {
        private final XMLTreeBlock treeblock;

        public DetailsPageProvider(XMLTreeBlock treeblock) {
            this.treeblock = treeblock;
        }

        public Object getPageKey(Object object) {
            return object;
        }

        public IDetailsPage getPage(Object key) {
            if (key instanceof XMLNode) {
                XMLNode xmldata = (XMLNode)key;
                XMLDetailsBlock page = new XMLDetailsBlock(this.treeblock, xmldata, XMLTreeBlock.this.detailspagetitle, this.treeblock.getDescription(xmldata));
                return page;
            }
            return null;
        }
    }
}

