/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.api.impl;

import com.vmware.vide.target.TargetPlugin;
import com.vmware.vide.target.api.ICommandOutputListener;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetChangedEvent;
import com.vmware.vide.target.api.ITargetListener;
import com.vmware.vide.target.api.ITargetManager;
import com.vmware.vide.target.api.ITargetManagerInitListener;
import com.vmware.vide.target.api.TargetType;
import com.vmware.vide.target.api.TargetTypeRegistry;
import com.vmware.vide.target.api.impl.Target;
import com.vmware.vide.target.api.impl.TargetChangedEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TargetManager
implements ITargetManager {
    private static final String TARGETS_XML = "targets.xml";
    private Map<String, ITarget> targets;
    private List<ITargetListener> listeners;
    private File targetsXml;
    private final TargetTypeRegistry targetTypeRegistry = new TargetTypeRegistry();

    private void loadAvailableTargetTypes() {
        ArrayList<TargetType> availableTargetTypes = new ArrayList<TargetType>();
        availableTargetTypes.add(new TargetType("esx", "Connection for VMware ESX/ESXi", true, null, true));
        availableTargetTypes.add(new TargetType("vc", "Connection for VMware vCenter for Windows", true, null, false));
        availableTargetTypes.add(new TargetType("vcva", "Connection for VMware vCenter for Linux", true, null, true));
        availableTargetTypes.add(new TargetType("linux", "Connection for Linux distributions", true, null, true));
        availableTargetTypes.add(new TargetType("ssh", "Connection for SSH access on any platform", true, null, true));
        List targetsFromExtensions = TargetTypeRegistry.getTargetsFromExtensions();
        for (TargetType t : targetsFromExtensions) {
            if (!t.isSshSupported() || !t.isFileSystemSupported()) continue;
            availableTargetTypes.add(t);
        }
        this.targetTypeRegistry.rebuildTargetList(availableTargetTypes);
    }

    public TargetType lookupTargetTypeById(String targetTypeId) {
        return this.targetTypeRegistry.lookupTargetTypeById(targetTypeId);
    }

    private void loadTargets() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(this.targetsXml);
        XPath xpath = XPathFactory.newInstance().newXPath();
        int count = Integer.parseInt(xpath.evaluate("count(/rse/target)", document));
        int i = 1;
        while (i <= count) {
            String index = Integer.toString(i);
            String path = "/rse/target[" + index + "]/";
            String host = xpath.evaluate(String.valueOf(path) + "host/text()", document);
            String name = xpath.evaluate(String.valueOf(path) + "name/text()", document);
            String type = xpath.evaluate(String.valueOf(path) + "type/text()", document);
            String description = xpath.evaluate(String.valueOf(path) + "description/text()", document);
            String user = xpath.evaluate(String.valueOf(path) + "user/text()", document);
            TargetType targetType = this.lookupTargetTypeById(type);
            Target target = new Target(host, name, type, user, targetType);
            target.setDescription(description);
            this.targets.put(name, target);
            ++i;
        }
    }

    private void saveTargets() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rse = document.createElement("rse");
            document.appendChild(rse);
            for (ITarget t : this.targets.values()) {
                Element target = document.createElement("target");
                rse.appendChild(target);
                Element host = document.createElement("host");
                host.appendChild(document.createTextNode(t.getHostName()));
                target.appendChild(host);
                Element name = document.createElement("name");
                name.appendChild(document.createTextNode(t.getName()));
                target.appendChild(name);
                Element type = document.createElement("type");
                type.appendChild(document.createTextNode(t.getTargetType()));
                target.appendChild(type);
                Element description = document.createElement("description");
                description.appendChild(document.createTextNode(t.getDescription()));
                target.appendChild(description);
                Element user = document.createElement("user");
                user.appendChild(document.createTextNode(t.getUserId()));
                target.appendChild(user);
            }
            DOMSource source = new DOMSource(document);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("standalone", "yes");
            StreamResult result = new StreamResult(this.targetsXml);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() throws Exception {
        this.loadAvailableTargetTypes();
        this.targets = new LinkedHashMap<String, ITarget>();
        this.listeners = new ArrayList<ITargetListener>();
        File storageDir = TargetPlugin.getDefault().getStorageDirectory();
        if (!storageDir.isDirectory()) {
            storageDir.mkdirs();
        }
        this.targetsXml = new File(storageDir, TARGETS_XML);
        if (this.targetsXml.exists()) {
            this.loadTargets();
        }
    }

    public void cleanup() {
        this.saveTargets();
    }

    public String getId() {
        return TargetPlugin.getDefault().getBundle().getSymbolicName();
    }

    public boolean isInitialized() {
        return true;
    }

    public void addInitListener(ITargetManagerInitListener listener) {
        new Thread(new InitRunnable(listener)).start();
    }

    public void removeInitListener(ITargetManagerInitListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITarget[] getTargets() {
        Map<String, ITarget> map = this.targets;
        synchronized (map) {
            return this.targets.values().toArray(new ITarget[this.targets.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITarget createTarget(String type, String name, String host) {
        Map<String, ITarget> map = this.targets;
        synchronized (map) {
            ITarget target = null;
            if (this.targets.containsKey(name)) {
                target = this.targets.get(name);
            } else {
                target = new Target(host, name, type, null, this.lookupTargetTypeById(type));
                this.targets.put(name, target);
                this.saveTargets();
                TargetChangedEvent event = new TargetChangedEvent(1, new ITarget[]{target});
                for (ITargetListener listener : this.listeners) {
                    listener.targetChanged((ITargetChangedEvent)event);
                }
            }
            return target;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTarget(ITarget target) {
        Map<String, ITarget> map = this.targets;
        synchronized (map) {
            if (this.targets.containsKey(target.getName())) {
                this.targets.remove(target.getName());
                this.saveTargets();
                TargetChangedEvent event = new TargetChangedEvent(2, new ITarget[]{target});
                for (ITargetListener listener : this.listeners) {
                    listener.targetChanged((ITargetChangedEvent)event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITarget findTarget(String name) {
        Map<String, ITarget> map = this.targets;
        synchronized (map) {
            return this.targets.get(name);
        }
    }

    public int executeCommand(ITarget target, String command, ICommandOutputListener listener) throws Exception {
        return target.executeCommand(command, listener, (IProgressMonitor)new NullProgressMonitor());
    }

    public int executeCommand(ITarget target, String command, ICommandOutputListener listener, IProgressMonitor monitor) throws Exception {
        return target.executeCommand(command, listener, monitor);
    }

    public void executeCommandAsync(ITarget target, String command, ICommandOutputListener listener) throws Exception {
        target.executeCommandAsync(command, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetListener(ITargetListener listener) {
        List<ITargetListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargetListener(ITargetListener listener) {
        List<ITargetListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public ITarget openNewConnectionWizard() {
        throw new UnsupportedOperationException();
    }

    public void setBypassKeyCheck(boolean bypass) {
    }

    public List<TargetType> getTargetTypes() {
        return this.targetTypeRegistry.getAvailableTargetTypes();
    }

    public void setSuppressPrompt(boolean prompt) {
    }

    public boolean getSuppressPrompt() {
        return false;
    }

    private class InitRunnable
    implements Runnable {
        private final ITargetManagerInitListener listener;

        public InitRunnable(ITargetManagerInitListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.phaseComplete(0);
        }
    }
}

