/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.api.impl.ssh;

import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class JschProgressMonitorDelegate
implements SftpProgressMonitor {
    private IProgressMonitor monitor;
    private long max;
    private long sizeKb;
    private long completed;
    private int percent;

    public JschProgressMonitorDelegate(IProgressMonitor monitor) {
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
    }

    public void init(int op, String src, String dest, long max) {
        this.max = max;
        this.sizeKb = max / 1024L;
        this.completed = 0L;
        this.percent = 0;
        String name = new File(src).getName();
        this.monitor.beginTask(name, 100);
    }

    public boolean count(long count) {
        this.completed += count;
        long completedKb = this.completed / 1024L;
        int newPercent = (int)(this.completed * 100L / this.max);
        int diff = newPercent - this.percent;
        this.percent = newPercent;
        this.monitor.subTask(String.valueOf(completedKb) + " KB of " + this.sizeKb + " KB complete (" + this.percent + "%)");
        if (diff > 0) {
            this.monitor.worked(diff);
        }
        return !this.monitor.isCanceled();
    }

    public void end() {
        this.monitor.done();
    }
}

