/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.utils.path;

import com.vmware.vide.target.api.ITargetFile;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class RemotePath
implements IPath {
    private final ITargetFile targetFile;
    private final Path path;

    public RemotePath(ITargetFile targetFile) {
        int index;
        this.targetFile = targetFile;
        String device = null;
        String targetPath = targetFile.getAbsolutePath();
        if (targetFile.getTarget().getTargetType() == "windows" && (index = (targetPath = targetPath.replace('\\', '/')).indexOf(58)) != -1) {
            int devStart = targetPath.charAt(0) == '/' ? 1 : 0;
            device = targetPath.substring(devStart, index + 1);
            targetPath = targetPath.substring(index + 1);
        }
        this.path = new Path(device, targetPath);
    }

    public ITargetFile getTargetFile() {
        return this.targetFile;
    }

    public IPath addFileExtension(String extension) {
        return this.path.addFileExtension(extension);
    }

    public IPath addTrailingSeparator() {
        return this.path.addTrailingSeparator();
    }

    public IPath append(String additionalPath) {
        return this.path.append(additionalPath);
    }

    public IPath append(IPath additionalPath) {
        return this.path.append(additionalPath);
    }

    public Object clone() {
        return this.path.clone();
    }

    public String getDevice() {
        return this.path.getDevice();
    }

    public String getFileExtension() {
        return this.path.getFileExtension();
    }

    public boolean hasTrailingSeparator() {
        return this.path.hasTrailingSeparator();
    }

    public boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public boolean isPrefixOf(IPath anotherPath) {
        return this.path.isPrefixOf(anotherPath);
    }

    public boolean isRoot() {
        return this.path.isRoot();
    }

    public boolean isUNC() {
        return this.path.isUNC();
    }

    public boolean isValidPath(String pathStr) {
        return this.path.isValidPath(pathStr);
    }

    public boolean isValidSegment(String segment) {
        return this.path.isValidSegment(segment);
    }

    public String lastSegment() {
        return this.path.lastSegment();
    }

    public IPath makeAbsolute() {
        return this.path.makeAbsolute();
    }

    public IPath makeRelative() {
        return this.path.makeRelative();
    }

    public IPath makeRelativeTo(IPath base) {
        return this.path.makeRelativeTo(base);
    }

    public IPath makeUNC(boolean toUNC) {
        return this.path.makeUNC(toUNC);
    }

    public int matchingFirstSegments(IPath anotherPath) {
        return this.path.matchingFirstSegments(anotherPath);
    }

    public IPath removeFileExtension() {
        return this.path.removeFileExtension();
    }

    public IPath removeFirstSegments(int count) {
        return this.path.removeFirstSegments(count);
    }

    public IPath removeLastSegments(int count) {
        return this.path.removeLastSegments(count);
    }

    public IPath removeTrailingSeparator() {
        return this.path.removeTrailingSeparator();
    }

    public String segment(int index) {
        return this.path.segment(index);
    }

    public int segmentCount() {
        return this.path.segmentCount();
    }

    public String[] segments() {
        return this.path.segments();
    }

    public IPath setDevice(String device) {
        return this.path.setDevice(device);
    }

    public File toFile() {
        throw new UnsupportedOperationException();
    }

    public String toOSString() {
        int len;
        char separator = '/';
        if (this.targetFile.getTarget().getTargetType() == "windows") {
            separator = '\\';
        }
        StringBuilder sb = new StringBuilder();
        if (this.path.getDevice() != null) {
            sb.append(this.path.getDevice());
        }
        if (this.path.isAbsolute()) {
            sb.append(separator);
        }
        if (this.path.isUNC()) {
            sb.append(separator);
        }
        if ((len = this.path.segmentCount() - 1) >= 0) {
            int i = 0;
            while (i < len) {
                sb.append(this.path.segment(i));
                sb.append(separator);
                ++i;
            }
            sb.append(this.path.segment(len));
        }
        if (this.path.hasTrailingSeparator()) {
            sb.append(separator);
        }
        return sb.toString();
    }

    public String toPortableString() {
        return this.path.toPortableString();
    }

    public IPath uptoSegment(int count) {
        return this.path.uptoSegment(count);
    }
}

