/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard.peweb;

import com.vmware.vide.dashboard.peweb.Activator;
import com.vmware.vide.dashboard.peweb.waivers.WaiversList;
import com.vmware.vide.vmwbrepository.HTTPClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertWaiverService {
    private static final String IDENTIFIER = "Certification Waivers";
    private static final String WAIVER_PARTNER = "/vmwb/certwaiver/waivers/partner/";
    private static final Logger logger = LoggerFactory.getLogger(CertWaiverService.class);

    private static HttpEntity executeHttpGet(String path, String query) {
        HttpResponse response;
        block3: {
            DefaultHttpClient httpClient = null;
            try {
                httpClient = HTTPClient.getDefaultHTTPClient();
                String serverName = Activator.getProxyServerName();
                int portNumber = Activator.getProxyPortNumber();
                URI uri = new URI("https", null, serverName, portNumber, path, query, null);
                HTTPClient.checkForProxy((DefaultHttpClient)httpClient, (String)uri.getHost(), (String)"HTTPS");
                HttpGet request = new HttpGet(uri);
                HTTPClient.addAuthenticationHeader((HttpRequestBase)request, null, (String)IDENTIFIER);
                response = httpClient.execute((HttpUriRequest)request);
                StatusLine status = response.getStatusLine();
                if (status.getStatusCode() == 200) break block3;
                logger.error("Get error from web service (" + status.getStatusCode() + ")");
                return null;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return response.getEntity();
    }

    public static WaiversList getGlobalWaivers() {
        WaiversList waiversList;
        block15: {
            HttpEntity entity = CertWaiverService.executeHttpGet(WAIVER_PARTNER, null);
            if (entity == null) {
                return null;
            }
            InputStream input = null;
            waiversList = null;
            try {
                try {
                    input = entity.getContent();
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WaiversList.class});
                    Unmarshaller m = context.createUnmarshaller();
                    waiversList = (WaiversList)m.unmarshal(input);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage(), (Throwable)e);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return waiversList;
    }

    public static WaiversList getApprovedWaivers(String email) {
        WaiversList waiversList;
        block15: {
            HttpEntity entity = CertWaiverService.executeHttpGet(WAIVER_PARTNER + email, null);
            if (entity == null) {
                return null;
            }
            InputStream input = null;
            waiversList = null;
            try {
                try {
                    input = entity.getContent();
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WaiversList.class});
                    Unmarshaller m = context.createUnmarshaller();
                    waiversList = (WaiversList)m.unmarshal(input);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage(), (Throwable)e);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return waiversList;
    }
}

