/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard.peweb;

import com.vmware.vide.dashboard.DynamicBrowser;
import com.vmware.vide.dashboard.VMWBPageEditor;
import com.vmware.vide.dashboard.peweb.InstallUtils;
import com.vmware.vide.utils.net.NetworkHelper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MyVMwareEditor
extends VMWBPageEditor {
    public void createPartControl(Composite parent) {
        Composite vpanel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        vpanel.setLayout((Layout)layout);
        Label label = new Label(vpanel, 0);
        label.setText("  Use this page to select, download and install the desired SDK. For general browsing, please use an external browser.");
        this.browser = new DynamicBrowser(vpanel);
        GridData gd = new GridData(1808);
        this.browser.getBrowser().setLayoutData((Object)gd);
        this.browser.setText("<html><body>Loading...</body></html>");
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String uri = event.location;
                int updIndex = uri.indexOf("UpdateSite");
                int zipIndex = uri.indexOf(".zip");
                if (updIndex >= 0 && zipIndex > updIndex) {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null || tmpDir.isEmpty()) {
                        tmpDir = "/tmp";
                    }
                    String outputFileName = String.valueOf(tmpDir) + "/" + uri.substring(updIndex, zipIndex + 4);
                    MyVMwareEditor.this.downloadUrl(uri, outputFileName);
                    event.doit = false;
                    return;
                }
                MyVMwareEditor.this.browser.onChangingPage(event);
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    protected void downloadUrl(final String url, final String fname) {
        if (!MessageDialog.openConfirm(null, (String)"Confirm download", (String)("The zip file will now be downloaded to '" + fname + "'."))) {
            return;
        }
        final String jobName = "Downloading " + fname;
        Job downloader = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(jobName, 100);
                    SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
                    final String result = NetworkHelper.getFileFromURL((String)url, (String)fname, (IProgressMonitor)sub);
                    if (result != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError(null, (String)"Error", (String)result);
                            }
                        });
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String archName = "jar:file:" + fname + "!/";
                            InstallUtils.addRepository(archName, null);
                            InstallUtils.openInstallWizard(archName, false, null);
                        }
                        catch (Exception e) {
                            MyVMwareEditor.this.showException(e);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        downloader.schedule();
    }

    private void showException(Exception e) {
        MessageDialog.openError(null, (String)"Error", (String)e.getMessage());
    }
}

