/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard.peweb;

import com.vmware.vide.dashboard.ContentPanel;
import com.vmware.vide.dashboard.IInstalledPackages;
import com.vmware.vide.dashboard.PortalEditorInput;
import com.vmware.vide.dashboard.VMWBPageEditor;
import com.vmware.vide.dashboard.peweb.InstallUtils;
import com.vmware.vide.utils.local.VMWBConfig;
import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vide.utils.net.NetworkHelper;
import com.vmware.vide.utils.ui.BrowserEditor;
import com.vmware.vide.utils.ui.SaveFileDialog;
import com.vmware.vide.vmwbrepository.Artifact;
import com.vmware.vide.vmwbrepository.WebServiceController;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PewebPanel
extends ContentPanel {
    protected static final int MAX_ROWS_IN_HOME = 6;
    protected static final int MAX_WORDS_IN_DESCR = 32;
    protected static final String EMPTY_STRING = "";
    private static final String DETAIL_PAGE = "/resources/detail_page.tmpl";
    private static final String VSPHERE_VERSION = "vsphere-version";
    private static final String LINK_PEWEB = "vide:peweb/";
    protected static String VMWB_PAGE_EDITOR_ID = "com.vmware.vide.dashboard.peweb.myvmwareeditor";
    protected String connectError;
    protected String loginError;
    protected WebServiceController webService;
    protected String installIconTag;
    protected String downloadIconTag;
    protected String bookIconTag;
    protected String currentPage;
    String urlBase = "http://10.20.140.48/";
    static SaveFileDialog saveDialog = null;
    public String LINK_LIST_ARTIFACTS = "vide:peweb/list";
    public String LINK_SERVER_ERRORS = "vide:start/";
    public String LINK_LIST_DESCRIPTION = "SDK / Certification List";
    public String LINK_CMD_DETAILS = "/details?";
    public String LINK_FILTER = "/filter?";
    protected Map<String, Artifact> artifactsList;
    protected SortedSet<Map.Entry<String, Artifact>> sortedArtifacts;
    protected Map<String, List<Artifact>> artDependencies;
    private Set<String> addedDependencies;
    private boolean hasDependencies;
    private String typeName;
    private String typeId;

    public boolean init(String typeName, String typeId) {
        this.webService = new WebServiceController();
        this.typeName = typeName;
        this.typeId = typeId;
        this.bookIconTag = this.getIconTag("/resources/book_open.png", "Browse the documentation");
        this.downloadIconTag = this.getIconTag("/resources/download_24x24.png", "Download the package to local disk");
        this.installIconTag = this.getIconTag("/resources/install_32x32.png", "Install the package");
        super.setCredentials(this.webService.getUserName(), this.webService.getPassword());
        return true;
    }

    public void setCredentials(String loginId, String password) {
        super.setCredentials(loginId, password);
        this.artifactsList = null;
        this.artDependencies = null;
        this.loginError = null;
        this.webService.setCredentials(this.getUserName(), this.getPassword());
        this.startRetrievingArtifacts();
    }

    public boolean isLoggedIn() {
        String userName = this.getUserName();
        if (userName == null || userName.isEmpty()) {
            return false;
        }
        return (this.loginError == null || this.loginError.isEmpty()) && (this.connectError == null || this.connectError.isEmpty());
    }

    public String getPrefix() {
        return LINK_PEWEB;
    }

    public void setListAllLinks(String link, String descr) {
        this.LINK_LIST_ARTIFACTS = link;
        this.LINK_LIST_DESCRIPTION = descr;
    }

    public String getRetrieveJobMessage() {
        return "Retrieving the " + this.typeName + " list...";
    }

    protected String getArtifactViewingMsg() {
        StringBuilder msg = new StringBuilder();
        msg.append("<a href=\"" + this.LINK_LIST_ARTIFACTS + "\">Click here</a>");
        msg.append(" for more details about the following ");
        if (this.artifactsList.size() > 6) {
            msg.append("and other ");
            msg.append(this.artifactsList.size() - 6 - 1);
            msg.append(" ");
        }
        msg.append(this.typeName);
        msg.append(":");
        return msg.toString();
    }

    public String getHomeHtml() {
        this.currentPage = null;
        if (this.isWorking()) {
            return this.getRetrieveJobMessage();
        }
        if (!(this.artifactsList == null || this.connectError != null && this.connectError.contains("Unauthorized"))) {
            return this.getHomePageFromList();
        }
        this.startRetrievingArtifacts();
        return this.getRetrieveJobMessage();
    }

    public String getHeaderCommands(boolean isHome) {
        return null;
    }

    protected List<Artifact> getArtifactsFromRepository() throws Exception {
        return this.webService.getArtifacts();
    }

    protected void startRetrievingArtifacts() {
        this.artDependencies = new HashMap<String, List<Artifact>>();
        this.connectError = null;
        this.artifactsList = new TreeMap<String, Artifact>();
        this.sortedArtifacts = new TreeSet<Map.Entry<String, Artifact>>(new Comparator<Map.Entry<String, Artifact>>(){

            @Override
            public int compare(Map.Entry<String, Artifact> e1, Map.Entry<String, Artifact> e2) {
                String e2Cmp;
                String e1Cmp = e1.getValue().getName();
                int nameCompare = e1Cmp.compareTo(e2Cmp = e2.getValue().getName());
                if (nameCompare == 0) {
                    String e2Version;
                    String e1Version = e1.getValue().getVersion();
                    if (e1Version == null || e1Version.trim().isEmpty()) {
                        e1Version = PewebPanel.EMPTY_STRING;
                    }
                    if ((e2Version = e2.getValue().getVersion()) == null || e2Version.trim().isEmpty()) {
                        e2Version = PewebPanel.EMPTY_STRING;
                    }
                    return e1Version.compareTo(e2Version);
                }
                return nameCompare;
            }
        });
        Job updater = new Job(this.getRetrieveJobMessage()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PewebPanel.this.artifactsList.clear();
                    List<Artifact> kits = PewebPanel.this.getArtifactsFromRepository();
                    for (Artifact art : kits) {
                        List deps;
                        String type = art.getType();
                        if (type != null && !type.equalsIgnoreCase(PewebPanel.this.typeId)) continue;
                        if (!art.getIgnoreDependencies() && (deps = PewebPanel.this.webService.getDependencies(art.getId())) != null) {
                            PewebPanel.this.artDependencies.put(art.getId(), deps);
                        }
                        PewebPanel.this.artifactsList.put(art.getId(), art);
                    }
                    PewebPanel.this.sortedArtifacts.addAll(PewebPanel.this.artifactsList.entrySet());
                    PewebPanel.this.setVMWBUpdateSites();
                }
                catch (UnknownHostException unknownHostException) {
                    PewebPanel.this.connectError = "Cannot connect to VMware server.";
                }
                catch (Exception e) {
                    PewebPanel.this.connectError = e.getMessage();
                    if (PewebPanel.this.connectError != null && PewebPanel.this.connectError.contains("Unauthorized")) {
                        PewebPanel.this.loginError = e.getMessage();
                        PewebPanel.this.webService.setCredentials(null, null);
                    }
                    PewebPanel.this.connectError = String.valueOf(PewebPanel.this.connectError) + "<br><a href=\"" + PewebPanel.this.LINK_SERVER_ERRORS + "\"><b>Click here</b></a> to troubleshoot.";
                }
                PewebPanel.this.setWorking(false);
                PewebPanel.this.notifyObservers(PewebPanel.EMPTY_STRING);
                return Status.OK_STATUS;
            }
        };
        this.setWorking(true);
        updater.schedule();
    }

    protected String getHomePageFromList() {
        if (this.isWorking()) {
            return this.getRetrieveJobMessage();
        }
        if (this.artifactsList == null || this.artifactsList.isEmpty()) {
            return this.getMissingMessageFor(this.typeName);
        }
        StringBuilder page = new StringBuilder();
        page.append(this.getArtifactViewingMsg());
        page.append("<br><br>");
        page.append("<table>");
        String sdkLink = null;
        for (Map.Entry entry : this.sortedArtifacts) {
            Artifact art = this.artifactsList.get(entry.getKey());
            sdkLink = String.valueOf(this.getPrefix()) + this.LINK_CMD_DETAILS + art.getId();
            page.append("<li><div  class='contentListItem'>\n");
            page.append("<a href=\"").append(sdkLink).append("\">");
            page.append(art.getName());
            page.append("</a></div>\n</li>\n");
        }
        return page.toString();
    }

    public void startUpdate() {
        Job updater = new Job(this.getRetrieveJobMessage()){

            protected IStatus run(IProgressMonitor monitor) {
                PewebPanel.this.getArtifacts();
                return Status.OK_STATUS;
            }
        };
        this.setWorking(true);
        updater.schedule();
    }

    protected String getShortDescription(Artifact art) {
        String descr = art.getDescription();
        String[] words = descr.split(" ");
        if (words.length < 32) {
            return descr;
        }
        StringBuilder shortDescr = new StringBuilder();
        int i = 0;
        while (i < 32) {
            shortDescr.append(words[i]);
            shortDescr.append(" ");
            ++i;
        }
        shortDescr.append("...");
        return shortDescr.toString();
    }

    protected String getDependenciesString(Artifact art) {
        StringBuilder sb = new StringBuilder();
        List<Artifact> deps = this.artDependencies.get(art.getId());
        if (deps != null && deps.size() > 0) {
            int i = 0;
            while (i < deps.size()) {
                Artifact a = deps.get(i);
                sb.append("<a href=\"" + a.getPackageUrl() + "\">" + a.getName() + "</a>");
                String vSphereVersion = this.getVSphereVersion(a);
                if (vSphereVersion != null && !vSphereVersion.trim().isEmpty()) {
                    sb.append("<br>");
                    sb.append("vsphere-version: " + vSphereVersion);
                }
                sb.append("<br><i>");
                sb.append(a.getDescription());
                sb.append("</i><br>");
                ++i;
            }
        } else {
            return "None";
        }
        return sb.toString();
    }

    protected String getArtifactsHtml() {
        StringBuilder page = new StringBuilder();
        String header = this.getHeader();
        if (this.isWorking()) {
            super.addContentHeader(page, header);
            page.append("<li>").append(this.getRetrieveJobMessage()).append("</li>\n");
            return page.toString();
        }
        if (this.artifactsList == null || this.artifactsList.isEmpty()) {
            super.addContentHeader(page, header);
            page.append("<li>").append(this.getMissingMessageFor(this.typeName)).append("</li>\n");
            return page.toString();
        }
        if (this.connectError != null) {
            super.addContentHeader(page, header);
            page.append("<li>").append(this.connectError).append("</li>\n");
        } else {
            String sdkLink = null;
            int count = this.sortedArtifacts.size();
            header = String.valueOf(header) + " <span class='subheader' style='font-size: 70%;'> " + count + " available</span>";
            super.addContentHeader(page, header);
            for (Map.Entry entry : this.sortedArtifacts) {
                Artifact art = this.artifactsList.get(entry.getKey());
                sdkLink = String.valueOf(this.getPrefix()) + this.LINK_CMD_DETAILS + art.getId();
                page.append("<li><div class='contentListItem'>\n");
                page.append("<span>");
                page.append("<a href=\"").append(sdkLink).append("\">");
                page.append(art.getName());
                page.append("</a>");
                page.append("<span class='listItemDescr' style='font-size: 70%;'> version ");
                page.append(art.getVersion());
                page.append(" </span>");
                page.append("</span>");
                page.append("</div>\n</li>\n");
            }
            page.append("</ul>\n");
        }
        return page.toString();
    }

    protected void addInstallActionIcon(StringBuilder page, Artifact art) {
        page.append("<span width='32px'>");
        if (this.hasAllUpdateURLs(art) && this.supportsCurrentPlatform(art)) {
            page.append("<a href=\"" + this.getPrefix() + "/install?");
            page.append(art.getId());
            if (WebServiceController.isTestEnvironment()) {
                page.append("\" title=\"" + art.getUpdateUrl());
            }
            page.append("\">").append(this.installIconTag).append("</a>");
        } else {
            page.append("&nbsp");
        }
        page.append("&nbsp;&nbsp;</span>");
    }

    protected void addDownloadActionIcon(StringBuilder page, Artifact art) {
        page.append("<span width=32px'>");
        String url = art.getPackageUrl();
        if (url != null && !url.isEmpty()) {
            page.append("<a href=\"" + this.getPrefix() + "/download?");
            page.append(art.getId());
            if (WebServiceController.isTestEnvironment()) {
                page.append("\" title=\"" + url);
            }
            page.append("\">").append(this.downloadIconTag).append("</a>");
        } else {
            page.append("&nbsp");
        }
        page.append("&nbsp;&nbsp;</span>");
    }

    protected void addViewDocsActionIcon(StringBuilder page, Artifact art) {
        page.append("<span width='32px'>");
        String url = art.getDocUrl();
        if (url != null && !url.isEmpty()) {
            page.append("<a href=\"" + this.getPrefix() + "/docs?");
            page.append(art.getId());
            if (WebServiceController.isTestEnvironment()) {
                page.append("\" title=\"" + url);
            }
            page.append("\">").append(this.bookIconTag).append("</a>");
        } else {
            page.append("&nbsp");
        }
        page.append("&nbsp;&nbsp;</span>");
    }

    protected void addInstallAction(StringBuilder page, Artifact art) {
        page.append("</td><td class=\"art-item\" align=\"center\">");
        if (this.hasAllUpdateURLs(art) && this.supportsCurrentPlatform(art)) {
            page.append("<a href=\"" + this.getPrefix() + "/install?");
            page.append(art.getId());
            if (WebServiceController.isTestEnvironment()) {
                page.append("\" title=\"" + art.getUpdateUrl());
            }
            page.append("\">Install</a>");
        } else {
            page.append("&nbsp");
        }
    }

    protected void addDownloadAction(StringBuilder page, Artifact art) {
        page.append("</td><td class=\"art-item\" align=\"center\">");
        String url = art.getPackageUrl();
        if (url != null && !url.isEmpty()) {
            page.append("<a href=\"" + this.getPrefix() + "/download?");
            page.append(art.getId());
            if (WebServiceController.isTestEnvironment()) {
                page.append("\" title=\"" + url);
            }
            page.append("\">Download</a>");
        } else {
            page.append("&nbsp");
        }
    }

    protected void addViewDocsAction(StringBuilder page, Artifact art) {
        page.append("</td><td class=\"art-item\" align=\"center\">");
        String url = art.getDocUrl();
        if (url != null && !url.isEmpty()) {
            page.append("<a href=\"" + this.getPrefix() + "/docs?");
            page.append(art.getId());
            if (WebServiceController.isTestEnvironment()) {
                page.append("\" title=\"" + url);
            }
            page.append("\">View&nbsp;Docs</a>");
        } else {
            page.append("&nbsp");
        }
    }

    protected void addDependencies(StringBuilder page, Artifact art) {
        page.append("</td><td class=\"art-item\">");
        String dependencies = this.getDependenciesString(art);
        page.append(dependencies);
        page.append("</td></tr>\n");
    }

    protected void getArtifacts() {
        String page = this.getArtifactsHtml();
        super.setHtml(page);
        this.setWorking(false);
        this.setChanged();
        this.notifyObservers(EMPTY_STRING);
    }

    public String getDetailsHtml(String id) {
        if (this.isWorking()) {
            return this.getRetrieveJobMessage();
        }
        Artifact art = null;
        if (this.artifactsList != null) {
            art = this.artifactsList.get(id);
        }
        if (this.artifactsList == null || this.artifactsList.isEmpty() || art == null) {
            return this.getMissingInformationMessage();
        }
        String page = "No information";
        File template = this.getResourceFile(DETAIL_PAGE);
        if (template != null) {
            try {
                String label;
                List contents = FileUtils.readLines((File)template);
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("$art.name", art.getName());
                values.put("$art.description", art.getDescription());
                values.put("$art.deps", this.getDependenciesString(art));
                if (this.hasAllUpdateURLs(art)) {
                    if (!this.supportsCurrentPlatform(art)) {
                        label = "This package can only be installed on the following platform(s): ";
                        for (String p : art.getPlatforms()) {
                            label = String.valueOf(label) + Artifact.getPlatformDescription((String)p);
                            label = String.valueOf(label) + ", ";
                        }
                        label = label.substring(0, label.length() - 2);
                    } else {
                        label = "<a href=\"" + this.getPrefix() + "/install?" + art.getId() + "\">Click&nbsp;here</a> to install this package.";
                    }
                    values.put("$art.updateUrl", label);
                    values.put("$art.updateIcon", this.installIconTag);
                } else {
                    values.put("$art.updateUrl", EMPTY_STRING);
                    values.put("$art.updateIcon", EMPTY_STRING);
                }
                String url = art.getPackageUrl();
                if (url != null && !url.isEmpty()) {
                    label = "<a href=\"" + this.getPrefix() + "/download?" + art.getId() + "\">Click&nbsp;here</a> to download the package to a local file (download size: " + art.getPackageSizeInBytes() + " bytes)";
                    values.put("$art.downloadUrl", label);
                    values.put("$art.downloadIcon", this.downloadIconTag);
                } else {
                    values.put("$art.downloadUrl", EMPTY_STRING);
                    values.put("$art.downloadIcon", EMPTY_STRING);
                }
                url = art.getDocUrl();
                if (url != null && !url.isEmpty()) {
                    label = "<a href=\"" + this.getPrefix() + "/docs?" + art.getId() + "\">Click&nbsp;here</a> to view the on-line documentation.";
                    values.put("$art.docsUrl", label);
                    values.put("$art.docsIcon", this.bookIconTag);
                } else {
                    values.put("$art.docsUrl", EMPTY_STRING);
                    values.put("$art.docsIcon", EMPTY_STRING);
                }
                StringBuilder tagRows = new StringBuilder();
                Map tags = art.getTagValues();
                Set entries = tags.entrySet();
                for (Map.Entry e : entries) {
                    tagRows.append("<tr><td>");
                    tagRows.append((String)e.getKey());
                    tagRows.append("</td><td></td><td>");
                    tagRows.append((String)e.getValue());
                    tagRows.append("</td></tr>");
                }
                tagRows.append("<tr><td>Version</td><td></td><td>");
                tagRows.append(art.getVersion());
                tagRows.append("</td></tr>");
                if (!tags.isEmpty()) {
                    tagRows.append("<tr><td>&nbsp;</td></tr>");
                }
                values.put("$art.tags", tagRows.toString());
                page = this.replaceContent(contents, values);
            }
            catch (Exception e) {
                page = String.valueOf(page) + e.getMessage();
            }
        }
        return page.toString();
    }

    public void showDetailsPage(String id) {
        String page = this.getDetailsHtml(id);
        super.setHtml(page);
        this.setChanged();
        this.notifyObservers(EMPTY_STRING);
    }

    public String getLinkDescription(String link) {
        if (link.equals(this.LINK_LIST_ARTIFACTS)) {
            return this.LINK_LIST_DESCRIPTION;
        }
        if (link.startsWith(String.valueOf(this.getPrefix()) + this.LINK_CMD_DETAILS)) {
            return "Package Details";
        }
        return EMPTY_STRING;
    }

    public boolean handleActionClick(String location) {
        if (!location.startsWith(this.getPrefix())) {
            return false;
        }
        String cmd = location.substring(this.getPrefix().length());
        if (cmd.startsWith("/install?")) {
            String id = cmd.substring(9);
            Artifact art = this.artifactsList.get(id);
            if (art == null) {
                return true;
            }
            if (!this.checkCompatibleInstall(art)) {
                return true;
            }
            this.hasDependencies = false;
            this.addedDependencies = new HashSet<String>();
            this.addDependenciesUpdateSites(art);
            this.addedDependencies.clear();
            final String arg = art.getUpdateUrl();
            Job updater = new Job("Retrieving page"){

                protected IStatus run(IProgressMonitor monitor) {
                    PewebPanel.this.startInstallJob(arg);
                    return Status.OK_STATUS;
                }
            };
            this.setWorking(true);
            updater.schedule();
            return true;
        }
        if (cmd.startsWith("/docs?")) {
            String id = cmd.substring(6);
            Artifact art = this.artifactsList.get(id);
            if (art != null) {
                BrowserEditor.open((String)art.getDocUrl(), (String)"Document", (String)art.getName(), (String)art.getDescription());
            }
            return true;
        }
        if (cmd.startsWith("/download?")) {
            String fname;
            int indx;
            String id = cmd.substring(10);
            final Artifact art = this.artifactsList.get(id);
            if (art == null) {
                return true;
            }
            final String url = art.getPackageUrl();
            if (art.getRedirectDownload()) {
                final boolean[] confirmed = new boolean[]{true};
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        confirmed[0] = MessageDialog.openConfirm(null, (String)"Info", (String)"This SDK can only be downloaded from an external web site. A new browser window will open to let you select and download the SDK. Once the download is complete, the install wizard will open to let you install the SDK.");
                    }
                });
                if (!confirmed[0]) {
                    return true;
                }
                this.downloadAndInstallFromExternalSite(url);
                return true;
            }
            if (saveDialog == null) {
                saveDialog = new SaveFileDialog();
            }
            if ((indx = url.lastIndexOf("/")) > 0) {
                String fileName = url.substring(indx + 1);
                if ((indx = fileName.indexOf("?")) > 0) {
                    fileName = fileName.substring(0, indx);
                }
                saveDialog.setFileName(fileName);
            }
            if ((fname = saveDialog.open()) == null) {
                return true;
            }
            int fileSize = art.getPackageSizeInBytes();
            final int totalWork = fileSize == 0 ? -1 : fileSize;
            final String jobName = "Downloading " + fname;
            Job downloader = new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(jobName, 100);
                        HttpLogger.logActivity((String)"artifact", (String)art.getType(), (String)art.getId(), (String)"Download");
                        SubProgressMonitor sub = new SubProgressMonitor(monitor, 100);
                        sub.beginTask(jobName, totalWork);
                        final String result = NetworkHelper.getFileFromURL((String)url, (String)fname, (IProgressMonitor)sub);
                        if (result != null) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openError(null, (String)"Download failed", (String)result);
                                }
                            });
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            downloader.schedule();
            return true;
        }
        return false;
    }

    private void downloadAndInstallFromExternalSite(String url) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IEditorPart editor = page.getActiveEditor();
            PortalEditorInput input = new PortalEditorInput();
            VMWBPageEditor vmwbEditor = (VMWBPageEditor)page.openEditor((IEditorInput)input, VMWB_PAGE_EDITOR_ID);
            vmwbEditor.setOldEditor(editor);
            vmwbEditor.show(url);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public boolean handleClick(String location) {
        if (location.startsWith(this.LINK_LIST_ARTIFACTS) || location.equals(this.getPrefix())) {
            this.currentPage = this.LINK_LIST_ARTIFACTS;
            super.setHtml(this.getHtml());
            this.setChanged();
            this.notifyObservers(EMPTY_STRING);
            return true;
        }
        if (!location.startsWith(this.getPrefix())) {
            return false;
        }
        String cmd = location.substring(this.getPrefix().length());
        if (cmd.startsWith(this.LINK_CMD_DETAILS)) {
            this.currentPage = location;
            super.setHtml(this.getHtml());
            this.setChanged();
            this.notifyObservers(EMPTY_STRING);
            return true;
        }
        return false;
    }

    protected boolean hasAllUpdateURLs(Artifact art) {
        HashSet<String> dependencies = new HashSet<String>();
        return this.hasAllUpdateURLs(art, dependencies);
    }

    private boolean hasAllUpdateURLs(Artifact art, Set<String> dependencies) {
        if (!dependencies.add(art.getId())) {
            return true;
        }
        String updateURL = art.getUpdateUrl();
        if (updateURL == null || updateURL.trim().isEmpty()) {
            return false;
        }
        List<Artifact> deps = this.artDependencies.get(art.getId());
        if (deps == null || deps.isEmpty()) {
            return true;
        }
        for (Artifact artDep : deps) {
            if (this.hasAllUpdateURLs(artDep, dependencies)) continue;
            return false;
        }
        return true;
    }

    protected void addDependenciesUpdateSites(Artifact art) {
        if (!this.addedDependencies.add(art.getId())) {
            return;
        }
        ProvisioningUI pui = ProvisioningUI.getDefaultUI();
        if (pui == null) {
            return;
        }
        RepositoryTracker tracker = pui.getRepositoryTracker();
        if (tracker == null) {
            return;
        }
        URI[] uris = tracker.getKnownRepositories(pui.getSession());
        try {
            List<Artifact> deps;
            boolean found = false;
            URI uri = new URI(art.getUpdateUrl());
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI u = uRIArray[n2];
                if (u.compareTo(uri) == 0) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                tracker.addRepository(uri, null, pui.getSession());
                this.hasDependencies = true;
            }
            if ((deps = this.artDependencies.get(art.getId())) == null || deps.isEmpty()) {
                return;
            }
            for (Artifact dep : deps) {
                this.addDependenciesUpdateSites(dep);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    protected void openInstallWizard(String url, IProgressMonitor monitor) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, URISyntaxException {
        InstallUtils.openInstallWizard(url, this.hasDependencies, monitor);
    }

    protected void startInstallJob(String arg) {
        try {
            final String argUrl = arg;
            this.setWorking(false);
            this.setChanged();
            this.notifyObservers(EMPTY_STRING);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        InstallUtils.addRepository(argUrl, null);
                        NullProgressMonitor monitor = new NullProgressMonitor();
                        PewebPanel.this.openInstallWizard(argUrl, (IProgressMonitor)monitor);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getHtml() {
        if (this.currentPage == null || this.currentPage.startsWith(this.LINK_LIST_ARTIFACTS)) {
            if (this.artifactsList == null || this.connectError != null && this.connectError.contains("Unauthorized")) {
                this.startRetrievingArtifacts();
                super.setHtml(this.getRetrieveJobMessage());
                return super.getHtml();
            }
            return this.getArtifactsHtml();
        }
        String location = this.currentPage.substring(this.getPrefix().length());
        if (location.startsWith(this.LINK_CMD_DETAILS)) {
            if (this.artifactsList == null || this.connectError != null && this.connectError.contains("Unauthorized")) {
                this.startRetrievingArtifacts();
                super.setHtml(this.getRetrieveJobMessage());
                return super.getHtml();
            }
            return this.getDetailsHtml(location.substring(this.LINK_CMD_DETAILS.length()));
        }
        return super.getHtml();
    }

    protected String getIconTag(String resource, String toolTip) {
        File iconFile = this.getResourceFile(resource);
        if (iconFile == null) {
            return EMPTY_STRING;
        }
        return "<img style=\"border: 0 none; text-decoration: none\" alt=\"" + toolTip + "\" height=\"18px\" width=\"18px\" src=\"file://" + iconFile.getPath() + "\">";
    }

    protected boolean supportsCurrentPlatform(Artifact art) {
        if (VMWBConfig.isWorkbenchIde()) {
            return art.supportsPlatform("VMWB") || art.supportsPlatform("NOARCH");
        }
        String arch = Platform.getOSArch();
        boolean is32bit = arch.equalsIgnoreCase("x86");
        String os = Platform.getOS();
        String platform = "NOARCH";
        if (VMWBConfig.isWorkbenchRCP()) {
            platform = "RCP_NOARCH";
            if (os.equalsIgnoreCase("linux")) {
                platform = is32bit ? "RCP_LIN32" : "RCP_LIN64";
            } else if (os.equalsIgnoreCase("win32")) {
                platform = is32bit ? "RCP_WIN32" : "RCP_WIN64";
            } else if (os.equalsIgnoreCase("macosx")) {
                String string = platform = is32bit ? "RCP_MAC32" : "RCP_MAC64";
            }
            if (art.supportsPlatform(platform)) {
                return true;
            }
            return art.supportsPlatform("RCP_NOARCH");
        }
        if (os.equalsIgnoreCase("linux")) {
            platform = is32bit ? "LIN32" : "LIN64";
        } else if (os.equalsIgnoreCase("win32")) {
            platform = is32bit ? "WIN32" : "WIN64";
        } else if (os.equalsIgnoreCase("macosx")) {
            String string = platform = is32bit ? "MAC32" : "MAC64";
        }
        if (art.supportsPlatform(platform)) {
            return true;
        }
        return art.supportsPlatform("NOARCH");
    }

    protected String getMissingInformationMessage() {
        String userName = this.getUserName();
        if (userName == null || userName.isEmpty()) {
            return "You must be logged in to see this page.";
        }
        if (this.connectError == null || this.connectError.isEmpty()) {
            return "No information available.";
        }
        if (this.connectError.contains("Unauthorized")) {
            return "Access was denied. Please try again.";
        }
        return "Could not retrieve the information. Reason: " + this.connectError;
    }

    protected String getMissingMessageFor(String packageTypeName) {
        String userName = this.getUserName();
        if (userName == null) {
            return "You must log in to access available " + packageTypeName + ".";
        }
        if (this.loginError != null) {
            return "Access was denied. Reason: \"" + this.loginError + "\". Please try again.";
        }
        if (this.connectError != null && !this.connectError.isEmpty()) {
            String msg = this.connectError;
            int indx = msg.indexOf("<BODY>");
            if (indx > 0) {
                msg = msg.substring(indx + 6);
            }
            if ((indx = msg.indexOf("</BODY>")) > 0) {
                msg = msg.substring(0, indx);
            }
            return "Could not get the list of " + packageTypeName + ". Reason: " + msg;
        }
        return "No " + packageTypeName + " available.";
    }

    protected String getTagsLine(Artifact art) {
        Map tags = art.getTagValues();
        if (tags.isEmpty()) {
            return null;
        }
        StringBuffer line = new StringBuffer();
        String separator = EMPTY_STRING;
        Set entries = tags.entrySet();
        for (Map.Entry e : entries) {
            line.append(separator);
            line.append((String)e.getKey());
            line.append(": ");
            line.append((String)e.getValue());
            separator = ", ";
        }
        return line.toString();
    }

    protected String getVSphereVersion(Artifact art) {
        Map tags = art.getTagValues();
        if (tags.isEmpty()) {
            return null;
        }
        return (String)tags.get(VSPHERE_VERSION);
    }

    protected boolean checkCompatibleInstall(Artifact art) {
        if (!VMWBConfig.isWorkbenchIde()) {
            return true;
        }
        IInstalledPackages installedPackagesChecker = this.getInstalledPackagesChecker();
        if (installedPackagesChecker == null) {
            return true;
        }
        List pkgs = null;
        String type = art.getType();
        String typeName = EMPTY_STRING;
        if (!type.equals("CERT")) {
            return true;
        }
        pkgs = installedPackagesChecker.getInstalledCerts();
        typeName = "certification";
        if (pkgs == null || pkgs.isEmpty()) {
            return true;
        }
        StringBuilder sb = new StringBuilder("One or more other ");
        sb.append(typeName);
        sb.append("s (");
        sb.append((String)pkgs.get(0));
        sb.append(") is installed in the system. VMware strongly recommends installing one ");
        sb.append(typeName);
        sb.append(" per virtual appliance. If you continue you may experience build errors");
        sb.append(" or failed certifications. Do you still want to continue with the installation?");
        String[] dialogButtonLabels = new String[]{"Continue", "Cancel"};
        MessageDialog warn = new MessageDialog(null, "Possible Conflict", null, sb.toString(), 4, dialogButtonLabels, 0);
        int result = warn.open();
        return result != 1 && result != -1;
    }

    protected synchronized void setVMWBUpdateSites() {
        ProvisioningUI pui = ProvisioningUI.getDefaultUI();
        ProvisioningSession session = pui.getSession();
        IMetadataRepositoryManager metaManager = ProvUI.getMetadataRepositoryManager((ProvisioningSession)session);
        RepositoryTracker tracker = pui.getRepositoryTracker();
        int visibilityFlags = tracker.getMetadataRepositoryFlags();
        URI[] currentlyEnabled = metaManager.getKnownRepositories(visibilityFlags);
        try {
            List vmwbArtifacts = this.webService.getVMWBPackagesArtifacts();
            for (Artifact art : vmwbArtifacts) {
                String url;
                if (!this.supportsCurrentPlatform(art) || (url = art.getUpdateUrl()) == null || url.isEmpty()) continue;
                URI uri = new URI(url);
                int indx = 0;
                while (indx < currentlyEnabled.length) {
                    if (currentlyEnabled[indx].equals(uri)) break;
                    ++indx;
                }
                if (indx < currentlyEnabled.length) continue;
                tracker.addRepository(uri, art.getName(), session);
            }
        }
        catch (Exception exception) {}
    }
}

