/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard.peweb;

import com.vmware.vide.dashboard.peweb.PewebPanel;
import com.vmware.vide.vmwbrepository.Artifact;
import java.util.ArrayList;
import java.util.List;

public class SdksPanel
extends PewebPanel {
    public static final String LINK_PREFIX = "vide:peweb/devkits";
    public static final String LINK_LIST_SDK = "vide:peweb/devkits/list";
    public static final String LINK_LIST_DESCRIPTION = "SDK List";
    public String LINK_REFRESH = "vide:peweb/devkits/refresh";
    public static final String PANEL_UI_NAME = "SDKs";
    private static final String SDK_ARTIFACTS = "devkit";
    private static final String SDK_ARTIFACTS_OPEN = "devkit/open";

    public boolean init() {
        super.init(PANEL_UI_NAME, "DEVKIT");
        this.setListAllLinks(LINK_LIST_SDK, LINK_LIST_DESCRIPTION);
        return true;
    }

    public String getHeader() {
        return PANEL_UI_NAME;
    }

    @Override
    public String getPrefix() {
        return LINK_PREFIX;
    }

    @Override
    public String getHeaderCommands(boolean isHome) {
        StringBuffer buffer = new StringBuffer();
        if (this.isLoggedIn() && this.currentPage.startsWith(LINK_LIST_SDK)) {
            buffer.append("<a href=\"");
            buffer.append(this.LINK_REFRESH);
            buffer.append("\">");
            buffer.append("Refresh");
            buffer.append("</a>&nbsp;&nbsp;&nbsp;");
            return buffer.toString();
        }
        return null;
    }

    @Override
    public boolean handleActionClick(String location) {
        if (location.startsWith(this.LINK_REFRESH)) {
            this.setCredentials(this.getUserName(), this.getPassword());
            return true;
        }
        return super.handleActionClick(location);
    }

    @Override
    protected String getArtifactViewingMsg() {
        StringBuilder msg = new StringBuilder();
        msg.append("<a href=\"" + this.LINK_LIST_ARTIFACTS + "\">Click here</a>");
        if (!this.isLoggedIn()) {
            msg.append(" for more details about the following public ");
        } else {
            msg.append(" for more details about the following ");
        }
        if (this.artifactsList.size() > 6) {
            msg.append("and other ");
            msg.append(this.artifactsList.size() - 6 - 1);
            msg.append(" ");
        }
        msg.append(PANEL_UI_NAME);
        msg.append(":");
        return msg.toString();
    }

    @Override
    public void setCredentials(String loginId, String password) {
        super.setCredentials(loginId, password);
        this.setChanged();
        this.notifyObservers("");
    }

    @Override
    protected List<Artifact> getArtifactsFromRepository() throws Exception {
        ArrayList<Artifact> allArtifacts = new ArrayList<Artifact>();
        if (this.webService.getUserName() != null) {
            this.webService.getArtifacts(allArtifacts, SDK_ARTIFACTS);
        } else {
            this.webService.getArtifacts(allArtifacts, SDK_ARTIFACTS_OPEN);
        }
        return allArtifacts;
    }
}

